/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.renderer.lite.AbstractLabelLineTest;
import org.geotools.renderer.lite.PerpendicularOffsetVisitor;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.Style;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class LabelUnderlineTest
extends AbstractLabelLineTest {
    @Test
    public void testLabelsUnderline() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "underlineText", "VENDOR_VALUE", "true");
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, style, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/underlineStyle.sld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)4900);
    }

    @Test
    public void testLabelsUnderline_legacyAnchorPoint() throws Exception {
        System.setProperty("org.geotools.renderer.style.legacyAnchorPoint", "true");
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "underlineText", "VENDOR_VALUE", "true");
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, style, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/underlineStyle-legacyAnchorPoint.sld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)4900);
        System.clearProperty("org.geotools.renderer.style.legacyAnchorPoint");
    }

    @Test
    public void testLabelInOrigin() throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        SimpleFeatureSource view = DataUtilities.createView((SimpleFeatureSource)this.featureSource, (Query)new Query(null, (Filter)ff.id(Collections.singleton(ff.featureId("Line.4")))));
        Style style = RendererBaseTest.loadStyle(this, "labelStyle.sld");
        ReferencedEnvelope bounds = this.featureSource.getBounds();
        bounds.expandBy(-1.0, -1.0);
        BufferedImage image = this.renderNonStraightLines(view, style, 768, 754, bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/labelTopLeft.sld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)3000);
    }

    @Test
    @Ignore
    public void testLabelsUnderlineWithOffset() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "underlineText", "VENDOR_VALUE", "true");
        Style offsetStyle = PerpendicularOffsetVisitor.apply(style, 15.0);
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, offsetStyle, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/underlineOffsetStyle.sld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)3600);
    }

    @Test
    @Ignore
    public void testLabelsUnderlineWithNegativeOffset() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "underlineText", "VENDOR_VALUE", "true");
        Style offsetStyle = PerpendicularOffsetVisitor.apply(style, -15.0);
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, offsetStyle, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/underlineNegativeOffsetStyle.sld.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)4800);
    }
}

