/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.image.test.ImageAssert;
import org.geotools.renderer.lite.AbstractLabelLineTest;
import org.geotools.styling.Style;
import org.junit.Test;

public class LabelSpacingTest
extends AbstractLabelLineTest {
    @Test
    public void testLabelsIncreaseSpacing() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "charSpacing", "VENDOR_VALUE", "10");
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, style, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelsIncreaseSpacing.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)3000);
    }

    @Test
    public void testLabelsDecreaseSpacing() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "charSpacing", "VENDOR_VALUE", "-5");
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, style, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelsDecreaseSpacing.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)3000);
    }

    @Test
    public void testLabelsIncreaseWordSpacing() throws Exception {
        Style style = this.loadParametricStyle(this, "lineStyleTemplate.sld", "VENDOR_KEY", "wordSpacing", "VENDOR_VALUE", "10");
        BufferedImage image = this.renderNonStraightLines((SimpleFeatureSource)this.featureSource, style, 1000, 1000, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/lineLabelsIncreaseWordSpacing.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)6100);
    }
}

