/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelOrientationTest {
    private static final long TIME = 10000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"diaglines.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("diaglines");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testLabelNatural() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textNaturalOrientation.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        this.renderer.setMapContent(mc);
        RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)this.renderer, 10000L, this.bounds);
    }

    @Test
    public void testLabelLineOrientation() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLineOrientation.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        this.renderer.setMapContent(mc);
        RendererBaseTest.showRender("Lines with circl stroke", (GTRenderer)this.renderer, 10000L, this.bounds);
    }
}

