/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class GeometryFunctionTest {
    private static final long TIME = 40000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"squareUTM.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.5);
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testPointSize() throws Exception {
        this.runSingleLayerTest("pointSizeGeometryFunction.sld", 100);
    }

    @Test
    public void testLabel() throws Exception {
        this.runSingleLayerTest("labelGeometryFunction.sld", 300);
    }

    private void runSingleLayerTest(String styleName, int threshold) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender(styleName, (GTRenderer)renderer, 40000L, this.bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/" + styleName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)threshold);
    }
}

