/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.Font;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.TextSymbolizer;
import org.geotools.test.TestGraphics;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class LabelCacheImplTest {
    private static final Geometry L4 = LabelCacheImplTest.geometry("POLYGON((0 0, 0 0.1, 0.1 0.1, 0.1 0, 0 0))");
    private static final Geometry L3 = LabelCacheImplTest.geometry("LINESTRING(20 20, 30 30)");
    private static final Geometry L2 = LabelCacheImplTest.geometry("LINESTRING(10 10, 20 20)");
    private static final Geometry L1 = LabelCacheImplTest.geometry("LINESTRING(0 0, 10 10)");
    private static final String LAYER_ID = "layerId";
    SimpleFeatureType schema;
    SimpleFeatureBuilder fb;
    LabelCacheImpl cache;
    StyleBuilder sb;
    NumberRange<Double> ALL_SCALES = new NumberRange(Double.class, (Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY);

    @Before
    public void setupSchema() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("name", String.class);
        tb.add("geom", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.schema = tb.buildFeatureType();
        this.fb = new SimpleFeatureBuilder(this.schema);
        this.cache = new LabelCacheImpl();
        this.cache.startLayer(LAYER_ID);
        this.sb = new StyleBuilder();
    }

    @Before
    public void setVeraFont() throws IOException, FontFormatException {
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testSimpleGrouping() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        ts.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        this.cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.put(LAYER_ID, ts, (Feature)f2, new LiteShape2((Geometry)f2.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)1L, (long)labels.size());
        LabelCacheItem item = (LabelCacheItem)labels.get(0);
        Assert.assertEquals((Object)"label1", (Object)item.getLabel());
        Assert.assertEquals((long)2L, (long)item.getGeoms().size());
    }

    @Test
    public void testGroupDifferentSymbolizers() throws Exception {
        TextSymbolizer ts1 = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        ts1.getOptions().put("group", "true");
        TextSymbolizer ts2 = this.sb.createTextSymbolizer(Color.YELLOW, (Font)null, "name");
        ts2.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        this.cache.put(LAYER_ID, ts1, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.put(LAYER_ID, ts2, (Feature)f2, new LiteShape2((Geometry)f2.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
    }

    @Test
    public void testMinNonGrouped() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        TextSymbolizer tsGroup = this.sb.createTextSymbolizer(Color.YELLOW, (Font)null, "name");
        tsGroup.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        SimpleFeature f3 = this.createFeature("label1", L3);
        this.cache.put(LAYER_ID, tsGroup, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.put(LAYER_ID, ts, (Feature)f2, new LiteShape2((Geometry)f2.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.put(LAYER_ID, tsGroup, (Feature)f3, new LiteShape2((Geometry)f3.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
        LabelCacheItem item1 = (LabelCacheItem)labels.get(0);
        Assert.assertEquals((Object)"label1", (Object)item1.getLabel());
        Assert.assertEquals(Arrays.asList(L1, L3), (Object)item1.getGeoms());
        LabelCacheItem item2 = (LabelCacheItem)labels.get(1);
        Assert.assertEquals((Object)"label1", (Object)item2.getLabel());
        Assert.assertEquals(Arrays.asList(L2), (Object)item2.getGeoms());
    }

    @Test
    public void testCustomBehaviour() throws TransformException, FactoryException {
        final ArrayList labels = new ArrayList();
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        LabelCacheImpl myCache = new LabelCacheImpl(){

            int paintLabel(Graphics2D graphics, Rectangle displayArea, LabelIndex glyphs, int paintedLineLabels, LabelPainter painter, LabelCacheItem labelItem) {
                labels.add(labelItem.getLabel());
                return super.paintLabel(graphics, displayArea, glyphs, paintedLineLabels, painter, labelItem);
            }
        };
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        SimpleFeature f1 = this.createFeature("label1", L1);
        myCache.enableLayer(LAYER_ID);
        myCache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        myCache.endLayer(LAYER_ID, graphics, new Rectangle(0, 0, 256, 256));
        myCache.end(graphics, new Rectangle(0, 0, 256, 256));
        Assert.assertEquals((long)1L, (long)labels.size());
    }

    @Test
    public void testRendererListener() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                exception.set(e);
            }
        };
        this.cache.addRenderListener(listener);
        SimpleFeature f1 = this.createFeature("label1", L1);
        this.cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.endLayer(LAYER_ID, null, null);
        TestGraphics testGraphics = new TestGraphics();
        testGraphics.setRenderingHints(Collections.emptyMap());
        this.cache.end((Graphics2D)testGraphics, new Rectangle(0, 0, 10, 10));
        Assert.assertNotNull(exception.get());
    }

    @Test
    public void testUsesCustomLabelPainter() throws Exception {
        LabelPainter painter = (LabelPainter)Mockito.mock(LabelPainter.class);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.cache.setConstructPainter((x, y) -> painter);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        SimpleFeature f1 = this.createFeature("label1", L1);
        this.cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.endLayer(LAYER_ID, graphics, new Rectangle(0, 0, 256, 256));
        this.cache.end(graphics, new Rectangle(0, 0, 256, 256));
        ((LabelPainter)Mockito.verify((Object)painter)).setLabel((LabelCacheItem)Mockito.any(LabelCacheItem.class));
        ((LabelPainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.atLeastOnce())).getLabel();
    }

    @Test
    public void testDecimateSmallRing() throws Exception {
        Font font = this.sb.createFont("Bitstream Vera Sans", 12.0);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, font, "name");
        ts.getOptions().put("followLine", "true");
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                exception.set(e);
            }
        };
        this.cache.addRenderListener(listener);
        SimpleFeature f1 = this.createFeature("label1", L4);
        this.cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        this.cache.endLayer(LAYER_ID, null, null);
        BufferedImage bi = new BufferedImage(10, 10, 6);
        Graphics2D graphics = bi.createGraphics();
        this.cache.end(graphics, new Rectangle(0, 0, 10, 10));
        Assert.assertNull(exception.get());
    }

    @Test
    public void testFollowLineAutoWrap() throws Exception {
        Font font = this.sb.createFont("Bitstream Vera Sans", 12.0);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, font, "name");
        ts.getOptions().put("autoWrap", "10");
        ts.getOptions().put("followLine", "true");
        SimpleFeature f1 = this.createFeature("label1", L4);
        this.cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
        List items = this.cache.getActiveLabels();
        LabelCacheItem item = (LabelCacheItem)items.get(0);
        Assert.assertTrue((boolean)item.isFollowLineEnabled());
        Assert.assertEquals((long)0L, (long)item.getAutoWrap());
    }

    private SimpleFeature createFeature(String label, Geometry geom) {
        this.fb.add((Object)label);
        this.fb.add((Object)geom);
        return this.fb.buildFeature(null);
    }

    private static Geometry geometry(String wkt) {
        try {
            return new WKTReader().read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

