/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.transform.SimilarityTransformProvider;
import org.junit.Assert;
import org.junit.Test;

public final class SimilarityTransformProviderTest {
    @Test
    public void testSimilarityTransform() throws FactoryException, TransformException {
        int i;
        ParameterGroup params = new ParameterGroup(SimilarityTransformProvider.PARAMETERS);
        params.parameter("8621").setValue(-129.549);
        params.parameter("8622").setValue(-208.185);
        params.parameter("8611").setValue(1.0000015504);
        params.parameter("8614").setValue(1.56504);
        MathTransform mt = new DefaultMathTransformFactory().createParameterizedTransform((ParameterValueGroup)params);
        double precision = 0.001;
        double[] srcPoints = new double[]{300000.0, 4500000.0};
        double[] dstPoints = new double[]{299905.06, 4499796.515};
        double[] calculatedPoints = new double[srcPoints.length];
        mt.transform(srcPoints, 0, calculatedPoints, 0, srcPoints.length / 2);
        for (i = 0; i < calculatedPoints.length; ++i) {
            Assert.assertEquals((double)dstPoints[i], (double)calculatedPoints[i], (double)0.001);
        }
        mt.inverse().transform(dstPoints, 0, calculatedPoints, 0, dstPoints.length / 2);
        for (i = 0; i < calculatedPoints.length; ++i) {
            Assert.assertEquals((double)srcPoints[i], (double)calculatedPoints[i], (double)0.001);
        }
    }
}

