/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.parameter.ParameterWriter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.projection.HotineObliqueMercator;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ObliqueMercator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DirectCreationTest {
    private static boolean VERBOSE = false;
    private static final double[] TOL_DEG = new double[]{1.0E-6, 1.0E-6};
    private static final double[] TOL_M = new double[]{0.01, 0.01};
    private MathTransformFactory mtFactory;

    @Before
    public void setUp() {
        this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
    }

    @After
    public void tearDown() {
        this.mtFactory = null;
    }

    private static void assertPositionEquals(Position expected, Position actual, double[] tolerance) {
        int dimension = actual.getDimension();
        int lastToleranceIndex = tolerance.length - 1;
        Assert.assertEquals((String)"The coordinate point doesn't have the expected dimension", (long)expected.getDimension(), (long)dimension);
        for (int i = 0; i < dimension; ++i) {
            Assert.assertEquals((String)("Mismatch for ordinate " + i + " (zero-based):"), (double)expected.getOrdinate(i), (double)actual.getOrdinate(i), (double)tolerance[Math.min(i, lastToleranceIndex)]);
        }
    }

    private static void doTransform(Position source, Position target, MathTransform transform) throws TransformException {
        DirectCreationTest.doTransform(source, target, transform, TOL_M);
    }

    private static void doTransform(Position source, Position target, MathTransform transform, double[] tolerance) throws TransformException {
        Position calculated = transform.transform(source, null);
        DirectCreationTest.assertPositionEquals(target, calculated, tolerance);
        target = source;
        source = calculated;
        calculated = transform.inverse().transform(source, null);
        DirectCreationTest.assertPositionEquals(target, calculated, TOL_DEG);
    }

    private void printParameters(String proj) throws NoSuchIdentifierException {
        ParameterValueGroup values = this.mtFactory.getDefaultParameters(proj);
        ParameterWriter.print((ParameterDescriptorGroup)values.getDescriptor());
    }

    @Test
    public void testEquidistantCylindrical() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Equidistant_Cylindrical");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Equidistant_Cylindrical");
        params.parameter("semi_major").setValue(6378137);
        params.parameter("semi_minor").setValue(6378137);
        params.parameter("central_meridian").setValue(0.0);
        params.parameter("standard_parallel_1").setValue(0.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-2.5, 51.37), (Position)new Position2D(-278298.73, 5718482.24), transform);
    }

    @Test
    public void testMercator() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Mercator_1SP");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Mercator_1SP");
        params.parameter("semi_major").setValue(6377397.155);
        params.parameter("semi_minor").setValue(6356078.963);
        params.parameter("central_meridian").setValue(110.0);
        params.parameter("scale_factor").setValue(0.997);
        params.parameter("false_easting").setValue(3900000.0);
        params.parameter("false_northing").setValue(900000.0);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(120.0, -3.0), (Position)new Position2D(5009726.58, 569150.82), transform);
        params.parameter("semi_major").setValue(1.0);
        params.parameter("semi_minor").setValue(1.0);
        params.parameter("central_meridian").setValue(-180.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-75.0, 35.0), (Position)new Position2D(1.8325957, 0.6528366), transform);
        params.parameter("semi_major").setValue(6370997.0);
        params.parameter("semi_minor").setValue(6370997.0);
        params.parameter("central_meridian").setValue(0.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-123.1, 49.2166666666), (Position)new Position2D(-1.36880890244348E7, 6304639.84599441), transform);
        params.parameter("semi_major").setValue(6378137.0);
        params.parameter("semi_minor").setValue(6356752.314245);
        params.parameter("latitude_of_origin").setValue(38.0);
        params.parameter("central_meridian").setValue(3.03);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(4.999999999999999, 26.996561536844165), (Position)new Position2D(173029.94823812644, 2448819.342941506), transform);
        if (VERBOSE) {
            this.printParameters("Mercator_2SP");
        }
        params = this.mtFactory.getDefaultParameters("Mercator_2SP");
        params.parameter("semi_major").setValue(6378245.0);
        params.parameter("semi_minor").setValue(6356863.019);
        params.parameter("central_meridian").setValue(51.0);
        params.parameter("standard_parallel_1").setValue(42.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(53.0, 53.0), (Position)new Position2D(165704.29, 5171848.07), transform);
        params = this.mtFactory.getDefaultParameters("Mercator_2SP");
        params.parameter("semi_major").setValue(6370997.0);
        params.parameter("semi_minor").setValue(6370997.0);
        params.parameter("central_meridian").setValue(180.0);
        params.parameter("standard_parallel_1").setValue(60.0);
        params.parameter("false_easting").setValue(-500000.0);
        params.parameter("false_northing").setValue(-1000000.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-123.1, 49.2166666666), (Position)new Position2D(2663494.1734, 2152319.923), transform);
    }

    @Test
    public void testObliqueMercator() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Oblique Mercator");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Oblique Mercator");
        DirectCreationTest.setObliqueMercatorParameter(params);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        Assert.assertEquals(transform.getClass(), ObliqueMercator.class);
        Assert.assertEquals((Object)transform, (Object)new ObliqueMercator(params));
        ParameterDescriptorGroup descriptor = ((MapProjection)transform).getParameterDescriptors();
        Assert.assertTrue((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (String)"Oblique Mercator"));
        Assert.assertFalse((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (String)"Hotine Oblique Mercator"));
        MathTransform standard = transform;
        params = this.mtFactory.getDefaultParameters("Hotine Oblique Mercator");
        DirectCreationTest.setObliqueMercatorParameter(params);
        transform = this.mtFactory.createParameterizedTransform(params);
        Assert.assertEquals(transform.getClass(), HotineObliqueMercator.class);
        Assert.assertEquals((Object)transform, (Object)new HotineObliqueMercator(params));
        descriptor = ((MapProjection)transform).getParameterDescriptors();
        Assert.assertFalse((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (String)"Oblique Mercator"));
        Assert.assertTrue((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (String)"Hotine Oblique Mercator"));
        Assert.assertNotEquals((Object)transform, (Object)standard);
    }

    private static void setObliqueMercatorParameter(ParameterValueGroup params) {
        params.parameter("semi_major").setValue(6377397.155);
        params.parameter("semi_minor").setValue(6356078.963);
        params.parameter("longitude_of_center").setValue(7.439583333333333);
        params.parameter("latitude_of_center").setValue(46.952405555555565);
        params.parameter("azimuth").setValue(90.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(600000.0);
        params.parameter("false_northing").setValue(200000.0);
        params.parameter("rectified_grid_angle").setValue(90.0);
    }

    @Test
    public void testLambert() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Lambert_Conformal_Conic_1SP");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Lambert_Conformal_Conic_1SP");
        params.parameter("semi_major").setValue(6378206.4);
        params.parameter("semi_minor").setValue(6356583.8);
        params.parameter("central_meridian").setValue(-77.0);
        params.parameter("latitude_of_origin").setValue(18.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(250000.0);
        params.parameter("false_northing").setValue(150000.0);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-76.943683333, 17.932166666), (Position)new Position2D(255966.58, 142493.51), transform);
        params.parameter("semi_major").setValue(6370997.0);
        params.parameter("semi_minor").setValue(6370997.0);
        params.parameter("central_meridian").setValue(111.0);
        params.parameter("latitude_of_origin").setValue(-55.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(500000.0);
        params.parameter("false_northing").setValue(1000000.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(151.283333333, -33.916666666), (Position)new Position2D(4232963.1816, 2287639.9866), transform);
        if (VERBOSE) {
            this.printParameters("Lambert_Conformal_Conic_2SP");
        }
        params = this.mtFactory.getDefaultParameters("Lambert_Conformal_Conic_2SP");
        params.parameter("semi_major").setValue(6378206.4);
        params.parameter("semi_minor").setValue(6356583.8);
        params.parameter("central_meridian").setValue(-99.0);
        params.parameter("latitude_of_origin").setValue(27.833333333);
        params.parameter("standard_parallel_1").setValue(28.383333333);
        params.parameter("standard_parallel_2").setValue(30.283333333);
        params.parameter("false_easting").setValue(609601.218);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-96.0, 28.5), (Position)new Position2D(903277.7965, 77650.94219), transform);
        params.parameter("semi_major").setValue(6370997.0);
        params.parameter("semi_minor").setValue(6370997.0);
        params.parameter("central_meridian").setValue(-120.0);
        params.parameter("latitude_of_origin").setValue(0.0);
        params.parameter("standard_parallel_1").setValue(2.0);
        params.parameter("standard_parallel_2").setValue(60.0);
        params.parameter("false_easting").setValue(0.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(139.733333333, 35.6833333333), (Position)new Position2D(-6789805.6471, 7107623.6859), transform);
        params.parameter("semi_major").setValue(6378137.0);
        params.parameter("semi_minor").setValue(6356752.31424518);
        params.parameter("central_meridian").setValue(0.0);
        params.parameter("latitude_of_origin").setValue(-50.0);
        params.parameter("standard_parallel_1").setValue(-40.0);
        params.parameter("standard_parallel_2").setValue(-40.0);
        params.parameter("false_easting").setValue(100000.0);
        params.parameter("false_northing").setValue(0.0);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(18.45, -33.9166666666), (Position)new Position2D(1803288.3324, 1616657.7846), transform);
        if (VERBOSE) {
            this.printParameters("Lambert_Conformal_Conic_2SP_Belgium");
        }
        params = this.mtFactory.getDefaultParameters("Lambert_Conformal_Conic_2SP_Belgium");
        params.parameter("semi_major").setValue(6378388.0);
        params.parameter("semi_minor").setValue(6356911.946);
        params.parameter("central_meridian").setValue(4.356939722);
        params.parameter("latitude_of_origin").setValue(90.0);
        params.parameter("standard_parallel_1").setValue(49.833333333);
        params.parameter("standard_parallel_2").setValue(51.166666666);
        params.parameter("false_easting").setValue(150000.01);
        params.parameter("false_northing").setValue(5400088.44);
        transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(5.807370277, 50.6795725), (Position)new Position2D(251763.2, 153034.13), transform);
    }

    @Test
    public void testKrovak() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Krovak");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Krovak");
        params.parameter("semi_major").setValue(6377397.155);
        params.parameter("semi_minor").setValue(6356078.963);
        params.parameter("latitude_of_center").setValue(49.5);
        params.parameter("longitude_of_center").setValue(24.83333333333333);
        params.parameter("azimuth").setValue(30.28813972222222);
        params.parameter("pseudo_standard_parallel_1").setValue(78.5);
        params.parameter("scale_factor").setValue(0.9999);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(14.370530947, 50.071153856), (Position)new Position2D(-746742.6075, -1044389.4516), transform);
    }

    @Test
    public void testStereographic() throws FactoryException, TransformException {
        if (VERBOSE) {
            this.printParameters("Polar_Stereographic");
        }
        ParameterValueGroup params = this.mtFactory.getDefaultParameters("Stereographic_North_Pole");
        params.parameter("semi_major").setValue(6378137.0);
        params.parameter("semi_minor").setValue(6356752.31424518);
        params.parameter("standard_parallel_1").setValue(71.0);
        params.parameter("central_meridian").setValue(-96.0);
        params.parameter("scale_factor").setValue(1.0);
        params.parameter("false_easting").setValue(0);
        params.parameter("false_northing").setValue(0);
        MathTransform transform = this.mtFactory.createParameterizedTransform(params);
        DirectCreationTest.doTransform((Position)new Position2D(-121.33955, 39.1012523), (Position)new Position2D(-2529570.0, -5341800.0), transform);
        params = this.mtFactory.getDefaultParameters("Polar_Stereographic");
        params.parameter("semi_major").setValue(6378137.0);
        params.parameter("semi_minor").setValue(6356752.31424518);
        params.parameter("latitude_of_origin").setValue(-90);
        params.parameter("central_meridian").setValue(0);
        params.parameter("scale_factor").setValue(0.97276901289);
        params.parameter("false_easting").setValue(0);
        params.parameter("false_northing").setValue(0);
        transform = this.mtFactory.createParameterizedTransform(params);
        double[] tolerance = new double[]{0.1, 0.1};
        DirectCreationTest.doTransform((Position)new Position2D(10.0, -85.0), (Position)new Position2D(94393.99, 535334.89), transform);
        DirectCreationTest.doTransform((Position)new Position2D(-75.0, -80.0), (Position)new Position2D(-1052066.625, 281900.375), transform, tolerance);
        DirectCreationTest.doTransform((Position)new Position2D(-75.0, -70.0), (Position)new Position2D(-2119718.75, 567976.875), transform, tolerance);
        DirectCreationTest.doTransform((Position)new Position2D(-75.0, -60.0), (Position)new Position2D(-3219560.25, 862678.563), transform, tolerance);
    }
}

