/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2004, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */

/**
 * Basic geometry concepts to support referencing and coverage use.
 *
 * <p>The {@link org.geotools.geometry.GeneralPosition} class represents a point in a multi-dimensional space. This
 * space may have an arbitrary number of dimensions. For a two-dimensional space, {@code Position} is conceptually
 * equivalent to {@code java.awt.geom.Point2D}. The class {@link org.geotools.geometry.GeneralBounds} represents a box
 * in a multi-dimensional space. For a two-dimensional space, {@code Bounds} is conceptually equivalent to
 * {@link java.awt.geom.Rectangle2D}.
 */
package org.geotools.geometry;
