/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.OperationNotFoundException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.operation.transform.WarpBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class WarpBuilderTest {
    @BeforeClass
    public static void setupClass() {
        MapProjection.SKIP_SANITY_CHECKS = true;
    }

    @Test
    public void testUTM32N() throws FactoryException, TransformException, NoninvertibleTransformException {
        CoordinateReferenceSystem utm32n = CRS.parseWKT((String)"PROJCS[\"WGS 84 / UTM zone 32N\",   GEOGCS[\"WGS 84\",     DATUM[\"World Geodetic System 1984\",       SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],       AUTHORITY[\"EPSG\",\"6326\"]],     PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],     UNIT[\"degree\", 0.017453292519943295],     AXIS[\"Geodetic longitude\", EAST],     AXIS[\"Geodetic latitude\", NORTH],     AUTHORITY[\"EPSG\",\"4326\"]],   PROJECTION[\"Transverse_Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],   PARAMETER[\"central_meridian\", 9.0],   PARAMETER[\"latitude_of_origin\", 0.0],   PARAMETER[\"scale_factor\", 0.9996],   PARAMETER[\"false_easting\", 500000.0],   PARAMETER[\"false_northing\", 0.0],   UNIT[\"m\", 1.0],   AXIS[\"Easting\", EAST],   AXIS[\"Northing\", NORTH],   AUTHORITY[\"EPSG\",\"32632\"]]");
        Rectangle screen = new Rectangle(0, 0, 512, 512);
        GeneralBounds env = new GeneralBounds(new double[]{-31.0, 0.0}, new double[]{9.0, 40.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, utm32n, screen, new int[]{32, 32}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-11.0, 0.0}, new double[]{9.0, 20.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, utm32n, screen, new int[]{8, 16}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-1.0, 0.0}, new double[]{9.0, 10.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, utm32n, screen, new int[]{4, 8}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{4.0, 0.0}, new double[]{9.0, 5.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, utm32n, screen, new int[]{2, 2}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{4.0, 0.0}, new double[]{9.0, 5.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(new GeneralBounds(new double[]{7.0, 0.0}, new double[]{9.0, 2.0}), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, utm32n, screen, new int[]{1, 1}, new boolean[]{false, true});
    }

    @Test
    public void testPolarStereo() throws FactoryException, TransformException, NoninvertibleTransformException {
        CoordinateReferenceSystem polar = CRS.parseWKT((String)"PROJCS[\"WGS 84 / Antarctic Polar Stereographic\",   GEOGCS[\"WGS 84\",     DATUM[\"World Geodetic System 1984\",       SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],       AUTHORITY[\"EPSG\",\"6326\"]],     PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],     UNIT[\"degree\", 0.017453292519943295],     AXIS[\"Geodetic longitude\", EAST],     AXIS[\"Geodetic latitude\", NORTH],     AUTHORITY[\"EPSG\",\"4326\"]],   PROJECTION[\"Polar Stereographic (variant B)\", AUTHORITY[\"EPSG\",\"9829\"]],   PARAMETER[\"central_meridian\", 0.0],   PARAMETER[\"Standard_Parallel_1\", -71.0],   PARAMETER[\"false_easting\", 0.0],   PARAMETER[\"false_northing\", 0.0],   UNIT[\"m\", 1.0],   AXIS[\"Easting\", \"North along 90 deg East\"],   AXIS[\"Northing\", \"North along 0 deg\"],   AUTHORITY[\"EPSG\",\"3031\"]]");
        Rectangle screen = new Rectangle(0, 0, 512, 512);
        GeneralBounds env = new GeneralBounds(new double[]{-10.0, -90.0}, new double[]{10.0, -85.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{16, 16}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-10.0, -90.0}, new double[]{10.0, -70.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{32, 16}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-10.0, -90.0}, new double[]{10.0, -45.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{64, 8}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-10.0, -90.0}, new double[]{10.0, 0.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{128, 8}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{80.0, -90.0}, new double[]{110.0, 0.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{32, 32}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-110.0, -90.0}, new double[]{-80.0, 0.0});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{32, 32}, new boolean[]{false, true});
        env = new GeneralBounds(new double[]{-110.0, -109.1}, new double[]{-80.0, -79.9});
        env.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.assertRowCols(env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, polar, screen, new int[]{16, 32}, new boolean[]{false, true});
    }

    private void assertRowCols(GeneralBounds sourceEnvelope, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Rectangle screen, int[] expectedSplit, boolean[] reverse) throws TransformException, FactoryException, NoninvertibleTransformException {
        MathTransform2D crsTransform = (MathTransform2D)CRS.findMathTransform((CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)sourceCRS), (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)targetCRS));
        GeneralBounds targetEnvelope = this.transformEnvelope(sourceEnvelope, targetCRS);
        AffineTransform at = this.worldToScreenTransform((Bounds)targetEnvelope, screen, reverse);
        AffineTransform2D screenTransform = new AffineTransform2D(at);
        MathTransform2D fullTranform = (MathTransform2D)ConcatenatedTransform.create((MathTransform)crsTransform, (MathTransform)screenTransform);
        Rectangle2D.Double sourceDomain = new Rectangle2D.Double(sourceEnvelope.getLowerCorner().getOrdinate(0), sourceEnvelope.getLowerCorner().getOrdinate(1), sourceEnvelope.getSpan(0), sourceEnvelope.getSpan(1));
        WarpBuilder wb = new WarpBuilder(0.8);
        int[] actualSplit = wb.getRowColsSplit(fullTranform, sourceDomain);
        Assert.assertArrayEquals((int[])expectedSplit, (int[])actualSplit);
    }

    private AffineTransform worldToScreenTransform(Bounds mapExtent, Rectangle paintArea, boolean[] reverse) throws NoninvertibleTransformException {
        GeneralBounds gridRange = new GeneralBounds(new double[]{0.0, 0.0}, new double[]{paintArea.getWidth(), paintArea.getHeight()});
        XMatrix matrix = MatrixFactory.create((int)3);
        for (int i = 0; i < 2; ++i) {
            double offset;
            int j = i;
            double scale = mapExtent.getSpan(j) / gridRange.getSpan(i);
            if (reverse == null || j >= reverse.length || !reverse[j]) {
                offset = mapExtent.getMinimum(j);
            } else {
                scale = -scale;
                offset = mapExtent.getMaximum(j);
            }
            matrix.setElement(j, j, 0.0);
            matrix.setElement(j, i, scale);
            matrix.setElement(j, 2, offset -= scale * gridRange.getLowerCorner().getOrdinate(i));
        }
        return ((AffineTransform)ProjectiveTransform.create((Matrix)matrix)).createInverse();
    }

    private GeneralBounds transformEnvelope(GeneralBounds env, CoordinateReferenceSystem targetCRS) throws TransformException, OperationNotFoundException, FactoryException {
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory((boolean)true);
        CoordinateOperation operation = coordinateOperationFactory.createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, targetCRS);
        GeneralBounds transformed = CRS.transform((CoordinateOperation)operation, (Bounds)env);
        transformed.setCoordinateReferenceSystem(targetCRS);
        MathTransform transform = operation.getMathTransform();
        GeneralBounds target = new GeneralBounds((Bounds)transformed);
        this.transform(env, target, transform, 5);
        return target;
    }

    private Bounds transform(GeneralBounds sourceEnvelope, GeneralBounds targetEnvelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        double[] coordinates = new double[4 * ++npoints * 2];
        double xmin = sourceEnvelope.getLowerCorner().getOrdinate(0);
        double xmax = sourceEnvelope.getUpperCorner().getOrdinate(0);
        double ymin = sourceEnvelope.getLowerCorner().getOrdinate(1);
        double ymax = sourceEnvelope.getUpperCorner().getOrdinate(1);
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[offset++] = xmin;
            coordinates[offset++] = ymin + dy;
            coordinates[offset++] = xmin + dx;
            coordinates[offset++] = ymax;
            coordinates[offset++] = xmax;
            coordinates[offset++] = ymax - dy;
            coordinates[offset++] = xmax - dx;
            coordinates[offset++] = ymin;
        }
        assert (offset == coordinates.length);
        this.xform(transform, coordinates, coordinates);
        if (targetEnvelope == null) {
            return null;
        }
        t = 0;
        while (t < offset) {
            targetEnvelope.add((Position)new Position2D(coordinates[t++], coordinates[t++]));
        }
        return targetEnvelope;
    }

    private void xform(MathTransform transform, double[] src, double[] dest) throws TransformException {
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int i = 0; i < src.length; i += sourceDim) {
            try {
                transform.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(dest, j, dest, i, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, i - targetDim, dest, i, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }
}

