/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.operation.projection.NewZealandMapGrid;
import org.junit.Assert;
import org.junit.Test;

public final class NewZealandMapGridTest {
    private static final double[] GEOGRAPHIC = new double[]{172.739194, -34.444066, 172.723106, -40.512409, 169.172062, -46.651295};
    private static final double[] PROJECTED = new double[]{2487100.638, 6751049.719, 2486533.395, 6077263.661, 2216746.425, 5388508.765};

    @Test
    public void testTransform() throws TransformException {
        double[] dst = new double[6];
        new NewZealandMapGrid().transform(GEOGRAPHIC, 0, dst, 0, 3);
        for (int i = 0; i < PROJECTED.length; ++i) {
            Assert.assertEquals((double)PROJECTED[i], (double)dst[i], (double)0.1);
        }
    }

    @Test
    public void testInverseTransform() throws TransformException {
        double[] dst = new double[6];
        new NewZealandMapGrid().inverse().transform(PROJECTED, 0, dst, 0, 3);
        for (int i = 0; i < GEOGRAPHIC.length; ++i) {
            Assert.assertEquals((double)GEOGRAPHIC[i], (double)dst[i], (double)1.0E-4);
        }
    }

    @Test
    public void testWKT() {
        String wkt = new NewZealandMapGrid().toWKT();
        Assert.assertTrue((wkt.indexOf("central_meridian") >= 0 ? 1 : 0) != 0);
    }
}

