/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.junit.Assert;
import org.junit.Test;

public final class XAffineTransformTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testUnflipped() {
        XAffineTransformTest.runTest(1);
    }

    @Test
    public void testFlipped() {
        XAffineTransformTest.runTest(-1);
    }

    private static int getFlipFromType(AffineTransform tr) {
        return (tr.getType() & 0x40) != 0 ? -1 : 1;
    }

    private static void runTest(int f) {
        AffineTransform tr = new AffineTransform();
        tr.setToScale(1.0, f);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransformTest.getFlipFromType(tr));
        double r = Math.toRadians(25.0);
        tr.rotate(r);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)r, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransformTest.getFlipFromType(tr));
        r = Math.toRadians(65.0);
        tr.rotate(Math.toRadians(40.0));
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)r, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)-1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransformTest.getFlipFromType(tr));
        tr.setToScale(2.0, 3 * f);
        Assert.assertEquals((double)2.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransformTest.getFlipFromType(tr));
        tr.rotate(r);
        Assert.assertEquals((double)2.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)r, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)-1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)f, (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)1L, (long)XAffineTransformTest.getFlipFromType(tr));
        r = Math.toRadians(-90 * f);
        tr.setTransform(0.0, 1.0, f, 0.0, 0.0, 0.0);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)r, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)-1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)(-f), (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)(-f), (long)XAffineTransformTest.getFlipFromType(tr));
        tr.scale(2.0, 3.0);
        Assert.assertEquals((double)3.0, (double)XAffineTransform.getScaleX0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)XAffineTransform.getScaleY0((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((double)r, (double)XAffineTransform.getRotation((AffineTransform)tr), (double)1.0E-10);
        Assert.assertEquals((long)-1L, (long)XAffineTransform.getSwapXY((AffineTransform)tr));
        Assert.assertEquals((long)(-f), (long)XAffineTransform.getFlip((AffineTransform)tr));
        Assert.assertEquals((long)(-f), (long)XAffineTransformTest.getFlipFromType(tr));
    }
}

