/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.CachedCRSAuthorityDecorator;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.wms.OGCAPICRSFactory;
import org.geotools.referencing.factory.wms.WebCRSFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OGCAPITest {
    private WebCRSFactory factory;

    @Before
    public void setUp() {
        this.factory = new OGCAPICRSFactory();
    }

    @Test
    public void testAuthority() {
        Citation authority = this.factory.getAuthority();
        Assert.assertTrue((boolean)Citations.identifierMatches((Citation)authority, (String)"OGC"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"CRS"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"EPSG"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"AUTO"));
        Assert.assertFalse((boolean)Citations.identifierMatches((Citation)authority, (String)"AUTO2"));
    }

    @Test
    public void testCRS84() throws FactoryException {
        GeographicCRS crs = this.factory.createGeographicCRS("OGC:84");
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("84"));
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("CRS84"));
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("OGC:CRS84"));
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("ogc : crs84"));
        Assert.assertNotSame((Object)crs, (Object)this.factory.createGeographicCRS("OGC:83"));
        Assert.assertNotEquals((Object)DefaultGeographicCRS.WGS84, (Object)crs);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
    }

    @Test
    public void testCRS83() throws FactoryException {
        GeographicCRS crs = this.factory.createGeographicCRS("OGC:83");
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("83"));
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("CRS83"));
        Assert.assertSame((Object)crs, (Object)this.factory.createGeographicCRS("OGC:CRS83"));
        Assert.assertNotSame((Object)crs, (Object)this.factory.createGeographicCRS("OGC:84"));
        Assert.assertFalse((boolean)CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)crs));
    }

    @Test
    public void testFind() throws FactoryException {
        GeographicCRS CRS84 = this.factory.createGeographicCRS("OGC:84");
        IdentifiedObjectFinder finder = this.factory.getIdentifiedObjectFinder(CoordinateReferenceSystem.class);
        Assert.assertTrue((String)"Newly created finder should default to full scan.", (boolean)finder.isFullScanAllowed());
        finder.setFullScanAllowed(false);
        Assert.assertSame((String)"Should find without the need for scan, since we can use the CRS:84 identifier.", (Object)CRS84, (Object)finder.find((IdentifiedObject)CRS84));
        finder.setFullScanAllowed(true);
        Assert.assertSame((String)"Allowing scanning should not make any difference for this CRS84 instance.", (Object)CRS84, (Object)finder.find((IdentifiedObject)CRS84));
        Assert.assertNotSame((String)"Required condition for next test.", (Object)CRS84, (Object)DefaultGeographicCRS.WGS84);
        Assert.assertNotEquals((String)"Required condition for next test.", (Object)CRS84, (Object)DefaultGeographicCRS.WGS84);
        Assert.assertTrue((String)"Required condition for next test.", (boolean)CRS.equalsIgnoreMetadata((Object)CRS84, (Object)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(false);
        Assert.assertNull((String)"Should not find WGS84 without a full scan, since it doesn't contains the CRS:84 identifier.", (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(true);
        Assert.assertSame((String)"A full scan should allow us to find WGS84, since it is equals ignoring metadata to CRS:84.", (Object)CRS84, (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(false);
        Assert.assertNull((String)"The scan result should not be cached.", (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        String wkt = "GEOGCS[\"WGS 84\",\n  DATUM[\"WGS84\",\n    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563]],\n  PRIMEM[\"Greenwich\", 0.0],\n  UNIT[\"degree\", 0.017453292519943295]]";
        CoordinateReferenceSystem search = CRS.parseWKT((String)wkt);
        Assert.assertNotEquals((String)"Required condition for next test.", (Object)CRS84, (Object)search);
        Assert.assertTrue((String)"Required condition for next test.", (boolean)CRS.equalsIgnoreMetadata((Object)CRS84, (Object)search));
        finder.setFullScanAllowed(false);
        Assert.assertNull((String)"Should not find WGS84 without a full scan, since it doesn't contains the CRS:84 identifier.", (Object)finder.find((IdentifiedObject)search));
        finder.setFullScanAllowed(true);
        Assert.assertSame((String)"A full scan should allow us to find WGS84, since it is equals ignoring metadata to CRS:84.", (Object)CRS84, (Object)finder.find((IdentifiedObject)search));
        Assert.assertEquals((Object)"OGC:84", (Object)finder.findIdentifier((IdentifiedObject)search));
    }

    @Test
    public void testBufferedFind() throws FactoryException {
        CachedCRSAuthorityDecorator factory = new CachedCRSAuthorityDecorator((CRSAuthorityFactory)this.factory);
        GeographicCRS CRS84 = factory.createGeographicCRS("OGC:84");
        IdentifiedObjectFinder finder = factory.getIdentifiedObjectFinder(CoordinateReferenceSystem.class);
        finder.setFullScanAllowed(false);
        Assert.assertSame((String)"Should find without the need for scan, since we can use the CRS:84 identifier.", (Object)CRS84, (Object)finder.find((IdentifiedObject)CRS84));
        finder.setFullScanAllowed(false);
        Assert.assertNull((String)"Should not find WGS84 without a full scan, since it doesn't contains the CRS:84 identifier.", (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(true);
        Assert.assertSame((String)"A full scan should allow us to find WGS84, since it is equals ignoring metadata to CRS:84.", (Object)CRS84, (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        finder.setFullScanAllowed(false);
        Assert.assertSame((String)"At the contrary of testFind(), the scan result should be cached.", (Object)CRS84, (Object)finder.find((IdentifiedObject)DefaultGeographicCRS.WGS84));
        Assert.assertEquals((Object)"OGC:84", (Object)finder.findIdentifier((IdentifiedObject)DefaultGeographicCRS.WGS84));
    }
}

