/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.util.GenericName;
import org.geotools.api.util.InternationalString;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.text.Text;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;

public abstract class MockCRSAuthorityFactory
extends AbstractAuthorityFactory
implements CRSAuthorityFactory,
OptionalFactory {
    public static final String USE_MOCK_CRS_FACTORY = "org.geotools.referencing.crs.usemockcrsfactory";
    private final String name;
    private final Citation authority;
    private final Set<String> codes;

    protected MockCRSAuthorityFactory(String name, Citation authority, int priority, Hints hints) {
        super(priority);
        this.name = name;
        this.authority = authority;
        if (hints != null) {
            for (Map.Entry entry : hints.entrySet()) {
                this.hints.putIfAbsent((Hints.Key)entry.getKey(), entry.getValue());
            }
        }
        this.codes = Collections.singleton("EPSG:99999");
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.codes;
    }

    public boolean isAvailable() {
        String useMock = System.getProperty(USE_MOCK_CRS_FACTORY);
        return Boolean.parseBoolean(useMock);
    }

    public IdentifiedObject createObject(String code) throws NoSuchAuthorityCodeException, FactoryException {
        if (this.codes.contains(code)) {
            return new MockCRS();
        }
        return super.createObject(code);
    }

    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return Text.text((String)"description");
    }

    public Citation getAuthority() {
        return this.authority;
    }

    class MockCRS
    implements CoordinateReferenceSystem {
        MockCRS() {
        }

        public ReferenceIdentifier getName() {
            return new NamedIdentifier(MockCRSAuthorityFactory.this.authority, MockCRSAuthorityFactory.this.name);
        }

        public Extent getDomainOfValidity() {
            throw new UnsupportedOperationException();
        }

        public InternationalString getScope() {
            throw new UnsupportedOperationException();
        }

        public Collection<GenericName> getAlias() {
            throw new UnsupportedOperationException();
        }

        public Set<ReferenceIdentifier> getIdentifiers() {
            throw new UnsupportedOperationException();
        }

        public InternationalString getRemarks() {
            throw new UnsupportedOperationException();
        }

        public String toWKT() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public CoordinateSystem getCoordinateSystem() {
            throw new UnsupportedOperationException();
        }
    }
}

