/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.junit.Assert;
import org.junit.Test;

public final class DefaultCoordinateSystemAxisTest {
    private static final double EPS = 1.0E-10;

    @Test
    public void testNameMatches() {
        Assert.assertTrue((boolean)DefaultCoordinateSystemAxis.LONGITUDE.nameMatches(DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE.getName().getCode()));
        Assert.assertFalse((boolean)DefaultCoordinateSystemAxis.LONGITUDE.nameMatches(DefaultCoordinateSystemAxis.GEODETIC_LATITUDE.getName().getCode()));
        Assert.assertFalse((boolean)DefaultCoordinateSystemAxis.LONGITUDE.nameMatches(DefaultCoordinateSystemAxis.ALTITUDE.getName().getCode()));
        Assert.assertFalse((boolean)DefaultCoordinateSystemAxis.X.nameMatches(DefaultCoordinateSystemAxis.LONGITUDE.getName().getCode()));
        Assert.assertFalse((boolean)DefaultCoordinateSystemAxis.X.nameMatches(DefaultCoordinateSystemAxis.EASTING.getName().getCode()));
        Assert.assertFalse((boolean)DefaultCoordinateSystemAxis.X.nameMatches(DefaultCoordinateSystemAxis.NORTHING.getName().getCode()));
    }

    @Test
    public void testPredefined() {
        Assert.assertNull((Object)DefaultCoordinateSystemAxis.getPredefined((String)"Dummy", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"\u03c6", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"\u03bb", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"h", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_X, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"X", (AxisDirection)AxisDirection.OTHER));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_Y, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Y", (AxisDirection)AxisDirection.EAST));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_Z, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Z", (AxisDirection)AxisDirection.NORTH));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.LONGITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Lon", (AxisDirection)AxisDirection.EAST));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Lat", (AxisDirection)AxisDirection.NORTH));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.X, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"X", (AxisDirection)AxisDirection.EAST));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.Y, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Y", (AxisDirection)AxisDirection.NORTH));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.Z, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Z", (AxisDirection)AxisDirection.UP));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Latitude", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.LONGITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Longitude", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Geodetic latitude", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Geodetic longitude", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.NORTHING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Northing", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.NORTHING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"N", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.EASTING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Easting", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.EASTING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"E", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.SOUTHING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Southing", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.SOUTHING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"S", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.WESTING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Westing", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.WESTING, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"W", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_X, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"X", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_Y, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Y", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEOCENTRIC_Z, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"Z", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.X, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"x", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.Y, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"y", null));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.Z, (Object)DefaultCoordinateSystemAxis.getPredefined((String)"z", null));
    }

    @Test
    public void testPredefinedAxis() {
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((CoordinateSystemAxis)DefaultCoordinateSystemAxis.LATITUDE));
        Assert.assertSame((Object)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (Object)DefaultCoordinateSystemAxis.getPredefined((CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE));
        DefaultCoordinateSystemAxis[] values = DefaultCoordinateSystemAxis.values();
        for (int i = 0; i < values.length; ++i) {
            DefaultCoordinateSystemAxis axis = values[i];
            String message = "values[" + i + "]";
            Assert.assertNotNull((String)message, (Object)axis);
            Assert.assertSame((String)message, (Object)axis, (Object)DefaultCoordinateSystemAxis.getPredefined((CoordinateSystemAxis)axis));
        }
    }

    @Test
    public void testCompass() {
        AxisDirection[] compass = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.NORTH_NORTH_EAST, AxisDirection.NORTH_EAST, AxisDirection.EAST_NORTH_EAST, AxisDirection.EAST, AxisDirection.EAST_SOUTH_EAST, AxisDirection.SOUTH_EAST, AxisDirection.SOUTH_SOUTH_EAST, AxisDirection.SOUTH, AxisDirection.SOUTH_SOUTH_WEST, AxisDirection.SOUTH_WEST, AxisDirection.WEST_SOUTH_WEST, AxisDirection.WEST, AxisDirection.WEST_NORTH_WEST, AxisDirection.NORTH_WEST, AxisDirection.NORTH_NORTH_WEST};
        Assert.assertEquals((long)compass.length, (long)16L);
        int base = AxisDirection.NORTH.ordinal();
        int h = compass.length / 2;
        for (int i = 0; i < compass.length; ++i) {
            String index = "compass[" + i + "]";
            AxisDirection c = compass[i];
            double angle = (double)i * (360.0 / (double)compass.length);
            if (angle > 180.0) {
                angle -= 360.0;
            }
            Assert.assertEquals((String)index, (long)(base + i), (long)c.ordinal());
            Assert.assertEquals((String)index, (long)(base + i + (i < h ? h : -h)), (long)c.opposite().ordinal());
            Assert.assertEquals((String)index, (double)0.0, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)c, (AxisDirection)c), (double)1.0E-10);
            Assert.assertEquals((String)index, (double)180.0, (double)Math.abs(DefaultCoordinateSystemAxis.getAngle((AxisDirection)c, (AxisDirection)c.opposite())), (double)1.0E-10);
            Assert.assertEquals((String)index, (double)angle, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)c, (AxisDirection)AxisDirection.NORTH), (double)1.0E-10);
        }
    }

    @Test
    public void testAngle() {
        Assert.assertEquals((double)90.0, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)AxisDirection.WEST, (AxisDirection)AxisDirection.SOUTH), (double)1.0E-10);
        Assert.assertEquals((double)-90.0, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)AxisDirection.SOUTH, (AxisDirection)AxisDirection.WEST), (double)1.0E-10);
        Assert.assertEquals((double)45.0, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)AxisDirection.SOUTH, (AxisDirection)AxisDirection.SOUTH_EAST), (double)1.0E-10);
        Assert.assertEquals((double)-22.5, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)AxisDirection.NORTH_NORTH_WEST, (AxisDirection)AxisDirection.NORTH), (double)1.0E-10);
    }

    @Test
    public void testAngle2() {
        DefaultCoordinateSystemAxisTest.compareAngle(90.0, "West", "South");
        DefaultCoordinateSystemAxisTest.compareAngle(-90.0, "South", "West");
        DefaultCoordinateSystemAxisTest.compareAngle(45.0, "South", "South-East");
        DefaultCoordinateSystemAxisTest.compareAngle(-22.5, "North-North-West", "North");
        DefaultCoordinateSystemAxisTest.compareAngle(-22.5, "North_North_West", "North");
        DefaultCoordinateSystemAxisTest.compareAngle(-22.5, "North North West", "North");
        DefaultCoordinateSystemAxisTest.compareAngle(90.0, "North along 90 deg East", "North along 0 deg");
        DefaultCoordinateSystemAxisTest.compareAngle(90.0, "South along 180 deg", "South along 90 deg West");
    }

    private static void compareAngle(double expected, String source, String target) {
        AxisDirection dir1 = DefaultCoordinateSystemAxis.getDirection((String)source);
        AxisDirection dir2 = DefaultCoordinateSystemAxis.getDirection((String)target);
        Assert.assertNotNull((Object)dir1);
        Assert.assertNotNull((Object)dir2);
        Assert.assertEquals((double)expected, (double)DefaultCoordinateSystemAxis.getAngle((AxisDirection)dir1, (AxisDirection)dir2), (double)1.0E-10);
    }
}

