/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.junit.Assert;
import org.junit.Test;
import si.uom.SI;

public final class AbstractCSTest {
    @Test
    public void testAxisSwapping() {
        DefaultEllipsoidalCS cs1 = new DefaultEllipsoidalCS("cs1", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE);
        DefaultEllipsoidalCS cs2 = new DefaultEllipsoidalCS("cs2", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE);
        Assert.assertTrue((boolean)AbstractCS.swapAndScaleAxis((CoordinateSystem)cs1, (CoordinateSystem)cs1).isIdentity());
        Assert.assertTrue((boolean)AbstractCS.swapAndScaleAxis((CoordinateSystem)cs2, (CoordinateSystem)cs2).isIdentity());
        AbstractCSTest.compareMatrix((CoordinateSystem)cs1, (CoordinateSystem)cs2, new double[]{0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
        cs1 = new DefaultEllipsoidalCS("cs1", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
        cs2 = new DefaultEllipsoidalCS("cs2", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LATITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.GEODETIC_LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
        AbstractCSTest.compareMatrix((CoordinateSystem)cs1, (CoordinateSystem)cs2, new double[]{0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
        cs1 = new DefaultCartesianCS("cs1", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.NORTHING);
        cs2 = new DefaultCartesianCS("cs2", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.SOUTHING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.ELLIPSOIDAL_HEIGHT);
        AbstractCSTest.compareMatrix((CoordinateSystem)cs1, (CoordinateSystem)cs2, new double[]{0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    private static void compareMatrix(CoordinateSystem cs1, CoordinateSystem cs2, double[] expected) {
        Matrix matrix = AbstractCS.swapAndScaleAxis((CoordinateSystem)cs1, (CoordinateSystem)cs2);
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        Assert.assertEquals((long)expected.length, (long)(numRow * numCol));
        GeneralMatrix em = new GeneralMatrix(numRow, numCol, expected);
        Assert.assertEquals((Object)em, (Object)matrix);
    }

    @Test
    public void testAxisUsingUnit() {
        Assert.assertNull((String)"Should detect that no axis change is needed", (Object)DefaultCartesianCS.PROJECTED.axisUsingUnit(SI.METRE));
        Unit KILOMETER = MetricPrefix.KILO((Unit)SI.METRE);
        CoordinateSystemAxis[] axis = DefaultCartesianCS.PROJECTED.axisUsingUnit(KILOMETER);
        Assert.assertNotNull((Object)axis);
        Assert.assertEquals((String)"Expected two-dimensional", (long)2L, (long)axis.length);
        Assert.assertEquals((Object)KILOMETER, (Object)axis[0].getUnit());
        Assert.assertEquals((Object)KILOMETER, (Object)axis[1].getUnit());
        Assert.assertEquals((Object)AxisDirection.EAST, (Object)axis[0].getDirection());
        Assert.assertEquals((Object)AxisDirection.NORTH, (Object)axis[1].getDirection());
        Assert.assertEquals((Object)"Easting", (Object)axis[0].getName().getCode());
        Assert.assertEquals((Object)"Northing", (Object)axis[1].getName().getCode());
    }

    @Test
    public void testStandards() {
        DefaultCartesianCS cs = DefaultCartesianCS.GRID;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultCartesianCS.GEOCENTRIC;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultCartesianCS.GENERIC_2D;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultCartesianCS.GENERIC_3D;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultCartesianCS.PROJECTED;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultEllipsoidalCS.GEODETIC_2D;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultEllipsoidalCS.GEODETIC_3D;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultSphericalCS.GEOCENTRIC;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultTimeCS.DAYS;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultVerticalCS.ELLIPSOIDAL_HEIGHT;
        Assert.assertSame((Object)cs, (Object)AbstractCS.standard((CoordinateSystem)cs));
        cs = DefaultVerticalCS.GRAVITY_RELATED_HEIGHT;
        Assert.assertSame((String)"\"Standard\" vertical axis should be forced to ellipsoidal height.", (Object)DefaultVerticalCS.ELLIPSOIDAL_HEIGHT, (Object)AbstractCS.standard((CoordinateSystem)cs));
    }
}

