/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.HashMap;
import java.util.Locale;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.NamedIdentifier;
import org.junit.Assert;
import org.junit.Test;

public final class IdentifiedObjectTest {
    @Test
    public void testIdentifier() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Assert.assertNull((Object)properties.put("code", "This is a code"));
        Assert.assertNull((Object)properties.put("authority", "This is an authority"));
        Assert.assertNull((Object)properties.put("version", "This is a version"));
        Assert.assertNull((Object)properties.put("dummy", "Doesn't matter"));
        Assert.assertNull((Object)properties.put("remarks", "There is remarks"));
        Assert.assertNull((Object)properties.put("remarks_fr", "Voici des remarques"));
        Assert.assertNull((Object)properties.put("remarks_fr_CA", "Pareil"));
        NamedIdentifier identifier = new NamedIdentifier(properties);
        Assert.assertEquals((String)"code", (Object)"This is a code", (Object)identifier.getCode());
        Assert.assertEquals((String)"authority", (Object)"This is an authority", (Object)identifier.getAuthority().getTitle().toString());
        Assert.assertEquals((String)"version", (Object)"This is a version", (Object)identifier.getVersion());
        Assert.assertEquals((String)"remarks", (Object)"There is remarks", (Object)identifier.getRemarks().toString(Locale.ENGLISH));
        Assert.assertEquals((String)"remarks_fr", (Object)"Voici des remarques", (Object)identifier.getRemarks().toString(Locale.FRENCH));
        Assert.assertEquals((String)"remarks_fr_CA", (Object)"Pareil", (Object)identifier.getRemarks().toString(Locale.CANADA_FRENCH));
        Assert.assertEquals((String)"remarks_fr_BE", (Object)"Voici des remarques", (Object)identifier.getRemarks().toString(new Locale("fr", "BE")));
        Assert.assertNotNull(properties.remove("authority"));
        Assert.assertNull((Object)properties.put("AutHOrITY", new CitationImpl((CharSequence)"An other authority")));
        identifier = new NamedIdentifier(properties);
        Assert.assertEquals((String)"authority", (Object)"An other authority", (Object)identifier.getAuthority().getTitle().toString(Locale.ENGLISH));
        Assert.assertNotNull(properties.remove("AutHOrITY"));
        Assert.assertNull((Object)properties.put("authority", Locale.CANADA));
        try {
            identifier = new NamedIdentifier(properties);
            Assert.fail();
        }
        catch (InvalidParameterValueException invalidParameterValueException) {
            // empty catch block
        }
    }

    @Test
    public void testIdentifiedObject() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Assert.assertNull((Object)properties.put("name", "This is a name"));
        Assert.assertNull((Object)properties.put("remarks", "There is remarks"));
        Assert.assertNull((Object)properties.put("remarks_fr", "Voici des remarques"));
        Assert.assertNull((Object)properties.put("dummy", "Doesn't matter"));
        Assert.assertNull((Object)properties.put("dummy_fr", "Rien d'int\u00e9ressant"));
        Assert.assertNull((Object)properties.put("local", "A custom localized string"));
        Assert.assertNull((Object)properties.put("local_fr", "Une cha\u00eene personalis\u00e9e"));
        Assert.assertNull((Object)properties.put("anchorPoint", "Anchor point"));
        Assert.assertNull((Object)properties.put("realizationEpoch", "Realization epoch"));
        Assert.assertNull((Object)properties.put("validArea", "Valid area"));
        HashMap remaining = new HashMap();
        AbstractIdentifiedObject reference = new AbstractIdentifiedObject(properties, remaining, new String[]{"local"});
        Assert.assertEquals((String)"name", (Object)"This is a name", (Object)reference.getName().getCode());
        Assert.assertEquals((String)"remarks", (Object)"There is remarks", (Object)reference.getRemarks().toString(null));
        Assert.assertEquals((String)"remarks_fr", (Object)"Voici des remarques", (Object)reference.getRemarks().toString(Locale.FRENCH));
        Assert.assertEquals((String)"Size:", (long)6L, (long)remaining.size());
        Assert.assertEquals((String)"dummy", (Object)"Doesn't matter", remaining.get("dummy"));
        Assert.assertEquals((String)"dummy_fr", (Object)"Rien d'int\u00e9ressant", remaining.get("dummy_fr"));
        Assert.assertEquals((String)"local", (Object)"A custom localized string", (Object)((InternationalString)remaining.get("local")).toString(null));
        Assert.assertEquals((String)"local_fr", (Object)"Une cha\u00eene personalis\u00e9e", (Object)((InternationalString)remaining.get("local")).toString(Locale.FRENCH));
        Assert.assertFalse((String)"local_fr", (boolean)remaining.containsKey("local_fr"));
        Assert.assertEquals((String)"anchorPoint", (Object)"Anchor point", remaining.get("anchorPoint"));
        Assert.assertEquals((String)"realizationEpoch", (Object)"Realization epoch", remaining.get("realizationEpoch"));
        Assert.assertEquals((String)"validArea", (Object)"Valid area", remaining.get("validArea"));
    }

    @Test
    public void testReferenceSystem() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Assert.assertNull((Object)properties.put("name", "This is a name"));
        Assert.assertNull((Object)properties.put("scope", "This is a scope"));
        Assert.assertNull((Object)properties.put("scope_fr", "Valide dans ce domaine"));
        Assert.assertNull((Object)properties.put("remarks", "There is remarks"));
        Assert.assertNull((Object)properties.put("remarks_fr", "Voici des remarques"));
        AbstractReferenceSystem reference = new AbstractReferenceSystem(properties);
        Assert.assertEquals((String)"name", (Object)"This is a name", (Object)reference.getName().getCode());
        Assert.assertEquals((String)"scope", (Object)"This is a scope", (Object)reference.getScope().toString(null));
        Assert.assertEquals((String)"scope_fr", (Object)"Valide dans ce domaine", (Object)reference.getScope().toString(Locale.FRENCH));
        Assert.assertEquals((String)"remarks", (Object)"There is remarks", (Object)reference.getRemarks().toString(null));
        Assert.assertEquals((String)"remarks_fr", (Object)"Voici des remarques", (Object)reference.getRemarks().toString(Locale.FRENCH));
    }
}

