/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.builder.AdvancedAffineBuilder;
import org.geotools.referencing.operation.builder.AffineToGeometric;
import org.geotools.referencing.operation.builder.AffineTransformBuilder;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.MissingInfoException;
import org.geotools.referencing.operation.builder.ProjectiveTransformBuilder;
import org.geotools.referencing.operation.builder.RubberSheetBuilder;
import org.geotools.referencing.operation.builder.SimilarTransformBuilder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Test;

public final class MathTransformBuilderTest {
    private List<MappedPosition> generateCoords(int numberOfVertices, long seed) {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_2D;
        return this.generateCoordsWithCRS(numberOfVertices, (CoordinateReferenceSystem)crs, seed, true);
    }

    private List<MappedPosition> generateCoords(int numberOfVertices, long seed, boolean includeAccuracy) {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_2D;
        return this.generateCoordsWithCRS(numberOfVertices, (CoordinateReferenceSystem)crs, seed, includeAccuracy);
    }

    private List<MappedPosition> generateCoordsWithCRS(int numberOfVertices, CoordinateReferenceSystem crs, long seed, boolean includeAccuracy) {
        ArrayList<MappedPosition> vert = new ArrayList<MappedPosition>();
        Random randomCoord = new Random(seed);
        for (int i = 0; i < numberOfVertices; ++i) {
            double xs = randomCoord.nextDouble() * 1000.0;
            double ys = randomCoord.nextDouble() * 1000.0;
            double xd = randomCoord.nextDouble() * 1000.0;
            double yd = randomCoord.nextDouble() * 1000.0;
            MappedPosition p = new MappedPosition((Position)new Position2D(crs, xs, ys), (Position)new Position2D(crs, xd, yd));
            if (includeAccuracy) {
                p.setAccuracy(randomCoord.nextDouble());
            }
            vert.add(p);
        }
        return vert;
    }

    private void transformTest(MathTransform mt, List<MappedPosition> pts) throws FactoryException, TransformException {
        int i;
        double[] points = new double[pts.size() * 2];
        double[] ptCalculated = new double[pts.size() * 2];
        for (i = 0; i < pts.size(); ++i) {
            points[2 * i] = pts.get(i).getSource().getCoordinate()[0];
            points[2 * i + 1] = pts.get(i).getSource().getCoordinate()[1];
        }
        mt.transform(points, 0, ptCalculated, 0, pts.size());
        for (i = 0; i < pts.size(); ++i) {
            Assert.assertEquals((double)pts.get(i).getTarget().getCoordinate()[0], (double)ptCalculated[2 * i], (double)0.001);
            Assert.assertEquals((double)pts.get(i).getTarget().getCoordinate()[1], (double)ptCalculated[2 * i + 1], (double)0.001);
        }
    }

    @Test
    public void testRubberBuilder() throws FactoryException, TransformException {
        List<MappedPosition> pts = this.generateCoords(20, 8324L);
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_2D;
        ArrayList<Position2D> dpl = new ArrayList<Position2D>();
        dpl.add(new Position2D((CoordinateReferenceSystem)crs, 1000.0, 0.0));
        dpl.add(new Position2D((CoordinateReferenceSystem)crs, 0.0, 0.0));
        dpl.add(new Position2D((CoordinateReferenceSystem)crs, 0.0, 1000.0));
        dpl.add(new Position2D((CoordinateReferenceSystem)crs, 1000.0, 1000.0));
        RubberSheetBuilder ppc = new RubberSheetBuilder(pts, dpl);
        this.transformTest(ppc.getMathTransform(), pts);
        Assert.assertTrue((ppc.getErrorStatistics().rms() < 1.0E-5 ? 1 : 0) != 0);
        Assert.assertTrue((ppc.toString().indexOf(" x ") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testProjectiveBuilder() throws FactoryException, TransformException {
        List<MappedPosition> pts = this.generateCoords(4, 312243L);
        ProjectiveTransformBuilder ppc = new ProjectiveTransformBuilder(pts);
        this.transformTest(ppc.getMathTransform(), pts);
        Assert.assertTrue((ppc.getErrorStatistics().rms() < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testLSMCalculation() throws FactoryException, TransformException {
        List<MappedPosition> pts = this.generateCoords(15, 3121123L);
        LSMTester buildTester = new LSMTester(pts);
        buildTester.includeWeights(true);
        buildTester.testLSM();
    }

    @Test
    public void testAffineBuilder() throws FactoryException, TransformException {
        List<MappedPosition> pts = this.generateCoords(3, 2345L);
        AffineTransformBuilder ppc = new AffineTransformBuilder(pts);
        this.transformTest(ppc.getMathTransform(), pts);
        Assert.assertTrue((ppc.getErrorStatistics().rms() < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testSimilarBuilder() throws FactoryException, TransformException {
        List<MappedPosition> pts = this.generateCoords(2, 24535L);
        SimilarTransformBuilder ppc = new SimilarTransformBuilder(pts);
        this.transformTest(ppc.getMathTransform(), pts);
        Assert.assertTrue((ppc.getErrorStatistics().rms() < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testAdvancedAffineBuilder() {
        try {
            List<MappedPosition> pts = this.generateCoords(3, 1245L);
            AdvancedAffineBuilder aab = new AdvancedAffineBuilder(pts);
            aab.setConstrain("sxy", 0.0);
            AffineToGeometric a2g = new AffineToGeometric((AffineTransform2D)aab.getMathTransform());
            Assert.assertEquals((double)a2g.getSkew(), (double)0.0, (double)1.0E-9);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMismatchedSizeException() throws TransformException {
        List<MappedPosition> pts = this.generateCoords(2, 2453655L);
        new AffineTransformBuilder(pts);
    }

    @Test(expected=MissingInfoException.class)
    public void testMissingInfoException() throws FactoryException {
        List<MappedPosition> pts = this.generateCoords(5, 2434765L, false);
        AffineTransformBuilder builder = new AffineTransformBuilder(pts);
        builder.includeWeights(true);
    }

    final class LSMTester
    extends ProjectiveTransformBuilder {
        LSMTester(List<MappedPosition> pts) {
            super(pts);
        }

        @Test
        public void testLSM() {
            this.calculateLSM();
            GeneralMatrix AT = this.A.clone();
            AT.transpose();
            GeneralMatrix ATP = new GeneralMatrix(AT.getNumRow(), this.P.getNumCol());
            GeneralMatrix ATPA = new GeneralMatrix(AT.getNumRow(), this.A.getNumCol());
            GeneralMatrix ATPX = new GeneralMatrix(AT.getNumRow(), 1);
            GeneralMatrix x = new GeneralMatrix(this.A.getNumCol(), 1);
            ATP.mul((Matrix)AT, (Matrix)this.P);
            ATPA.mul((Matrix)ATP, (Matrix)this.A);
            ATPX.mul((Matrix)ATP, (Matrix)this.X);
            GeneralMatrix ATPAI = ATPA.clone();
            ATPAI.invert();
            x.mul((Matrix)ATPAI, (Matrix)ATPX);
            x.mul((Matrix)ATPA, (Matrix)x);
            x.sub((Matrix)ATPX);
            double[] tx = new double[x.getNumRow()];
            x.getColumn(0, tx);
            for (double v : tx) {
                Assert.assertTrue((v < 0.001 ? 1 : 0) != 0);
            }
        }
    }
}

