/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Random;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.ProjectionAnalyzer;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.junit.Assert;
import org.junit.Test;
import si.uom.SI;

public final class LinearConversionTest {
    @Test
    public void testMatrix2() {
        Matrix2 m = new Matrix2();
        Assert.assertTrue((boolean)m.isAffine());
        Assert.assertTrue((boolean)m.isIdentity());
        Random random = new Random(8447482612423035360L);
        GeneralMatrix identity = new GeneralMatrix(2);
        for (int i = 0; i < 100; ++i) {
            m.setElement(0, 0, 100.0 * random.nextDouble());
            m.setElement(0, 1, 100.0 * random.nextDouble());
            m.setElement(1, 0, 100.0 * random.nextDouble());
            m.setElement(1, 1, 100.0 * random.nextDouble());
            Matrix2 original = m.clone();
            GeneralMatrix check = new GeneralMatrix((Matrix)m);
            m.invert();
            check.invert();
            Assert.assertTrue((boolean)check.equals((Matrix)m, 1.0E-9));
            m.multiply((Matrix)original);
            Assert.assertTrue((boolean)identity.equals((Matrix)m, 1.0E-9));
        }
    }

    @Test
    public void testAxisSwapping() {
        AxisDirection[] srcAxis = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.EAST, AxisDirection.UP};
        AxisDirection[] dstAxis = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.EAST, AxisDirection.UP};
        GeneralMatrix matrix = new GeneralMatrix(srcAxis, dstAxis);
        Assert.assertTrue((boolean)matrix.isAffine());
        Assert.assertTrue((boolean)matrix.isIdentity());
        dstAxis = new AxisDirection[]{AxisDirection.WEST, AxisDirection.UP, AxisDirection.SOUTH};
        matrix = new GeneralMatrix(srcAxis, dstAxis);
        Assert.assertTrue((boolean)matrix.isAffine());
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((Object)new GeneralMatrix((double[][])new double[][]{{0.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}), (Object)matrix);
        dstAxis = new AxisDirection[]{AxisDirection.DOWN, AxisDirection.NORTH};
        matrix = new GeneralMatrix(srcAxis, dstAxis);
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((Object)new GeneralMatrix((double[][])new double[][]{{0.0, 0.0, -1.0, 0.0}, {1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}), (Object)matrix);
        dstAxis = new AxisDirection[]{AxisDirection.DOWN, AxisDirection.DOWN};
        matrix = new GeneralMatrix(srcAxis, dstAxis);
        Assert.assertFalse((boolean)matrix.isIdentity());
        Assert.assertEquals((Object)new GeneralMatrix((double[][])new double[][]{{0.0, 0.0, -1.0, 0.0}, {0.0, 0.0, -1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}), (Object)matrix);
        dstAxis = new AxisDirection[]{AxisDirection.DOWN, AxisDirection.GEOCENTRIC_X};
        try {
            matrix = new GeneralMatrix(srcAxis, dstAxis);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        srcAxis = dstAxis;
        dstAxis = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.EAST, AxisDirection.UP, AxisDirection.WEST};
        try {
            matrix = new GeneralMatrix(srcAxis, dstAxis);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testScaleAndSwapAxis() {
        Unit cm = MetricPrefix.CENTI((Unit)SI.METRE);
        Unit mm = MetricPrefix.MILLI((Unit)SI.METRE);
        DefaultCartesianCS cs = new DefaultCartesianCS("Test", (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("y", AxisDirection.SOUTH, cm), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("x", AxisDirection.EAST, mm));
        Matrix matrix = AbstractCS.swapAndScaleAxis((CoordinateSystem)DefaultCartesianCS.GENERIC_2D, (CoordinateSystem)cs);
        Assert.assertEquals((Object)new GeneralMatrix((double[][])new double[][]{{0.0, -100.0, 0.0}, {1000.0, 0.0, 0.0}, {0.0, 0.0, 1.0}}), (Object)matrix);
        matrix = AbstractCS.swapAndScaleAxis((CoordinateSystem)DefaultCartesianCS.GENERIC_3D, (CoordinateSystem)cs);
        Assert.assertEquals((Object)new GeneralMatrix((double[][])new double[][]{{0.0, -100.0, 0.0, 0.0}, {1000.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}), (Object)matrix);
    }

    @Test
    public void testCreateLinearConversion() throws FactoryException {
        double EPS = 1.0E-12;
        DefaultMathTransformFactory factory = new DefaultMathTransformFactory();
        ParameterValueGroup parameters = factory.getDefaultParameters("Mercator_1SP");
        parameters.parameter("semi_major").setValue(DefaultEllipsoid.WGS84.getSemiMajorAxis());
        parameters.parameter("semi_minor").setValue(DefaultEllipsoid.WGS84.getSemiMinorAxis());
        MathTransform transform = factory.createParameterizedTransform(parameters);
        DefaultProjectedCRS sourceCRS = new DefaultProjectedCRS("source", (GeographicCRS)DefaultGeographicCRS.WGS84, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
        parameters.parameter("false_easting").setValue(1000);
        parameters.parameter("false_northing").setValue(2000);
        transform = factory.createParameterizedTransform(parameters);
        DefaultProjectedCRS targetCRS = new DefaultProjectedCRS("source", (GeographicCRS)DefaultGeographicCRS.WGS84, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
        Matrix conversion = ProjectionAnalyzer.createLinearConversion((ProjectedCRS)sourceCRS, (ProjectedCRS)targetCRS, (double)1.0E-12);
        Assert.assertEquals((Object)new Matrix3(1.0, 0.0, 1000.0, 0.0, 1.0, 2000.0, 0.0, 0.0, 1.0), (Object)conversion);
        parameters.parameter("scale_factor").setValue(2);
        transform = factory.createParameterizedTransform(parameters);
        targetCRS = new DefaultProjectedCRS("source", (GeographicCRS)DefaultGeographicCRS.WGS84, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
        conversion = ProjectionAnalyzer.createLinearConversion((ProjectedCRS)sourceCRS, (ProjectedCRS)targetCRS, (double)1.0E-12);
        Assert.assertEquals((Object)new Matrix3(2.0, 0.0, 1000.0, 0.0, 2.0, 2000.0, 0.0, 0.0, 1.0), (Object)conversion);
        parameters.parameter("semi_minor").setValue(DefaultEllipsoid.WGS84.getSemiMajorAxis());
        transform = factory.createParameterizedTransform(parameters);
        targetCRS = new DefaultProjectedCRS("source", (GeographicCRS)DefaultGeographicCRS.WGS84, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
        conversion = ProjectionAnalyzer.createLinearConversion((ProjectedCRS)sourceCRS, (ProjectedCRS)targetCRS, (double)1.0E-12);
        Assert.assertNull((Object)conversion);
    }
}

