/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.logging.Logging;

public class TestGridShiftLocator
extends AbstractFactory
implements GridShiftLocator {
    static final Logger LOGGER = Logging.getLogger(TestGridShiftLocator.class);

    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    public URL locateGrid(String grid) {
        block13: {
            try {
                URL compressed = ((Object)((Object)this)).getClass().getResource(grid + ".gz");
                if (compressed == null) break block13;
                File out = new File("./target/" + grid);
                try (GZIPInputStream is = new GZIPInputStream(compressed.openStream());
                     FileOutputStream fos = new FileOutputStream(out);){
                    int read;
                    byte[] buf = new byte[1024];
                    while ((read = is.read(buf)) > 0) {
                        fos.write(buf, 0, read);
                    }
                }
                return out.toURI().toURL();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to unpack the grid", e);
            }
        }
        return null;
    }
}

