/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTemporalDatumTest {
    private DateFormat format;

    @Before
    public void setUp() {
        this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CANADA);
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Test
    public void testOrigins() {
        double epoch = DefaultTemporalDatumTest.epoch((TemporalDatum)DefaultTemporalDatum.JULIAN);
        Assert.assertTrue((epoch < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)2400000.5, (double)(DefaultTemporalDatumTest.epoch((TemporalDatum)DefaultTemporalDatum.MODIFIED_JULIAN) - epoch), (double)0.0);
        Assert.assertEquals((Object)"1858-11-17 00:00:00", (Object)this.epochString((TemporalDatum)DefaultTemporalDatum.MODIFIED_JULIAN));
        Assert.assertEquals((double)2440000.5, (double)(DefaultTemporalDatumTest.epoch((TemporalDatum)DefaultTemporalDatum.TRUNCATED_JULIAN) - epoch), (double)0.0);
        Assert.assertEquals((Object)"1968-05-24 00:00:00", (Object)this.epochString((TemporalDatum)DefaultTemporalDatum.TRUNCATED_JULIAN));
        Assert.assertEquals((double)2415020.0, (double)(DefaultTemporalDatumTest.epoch((TemporalDatum)DefaultTemporalDatum.DUBLIN_JULIAN) - epoch), (double)0.0);
        Assert.assertEquals((Object)"1899-12-31 12:00:00", (Object)this.epochString((TemporalDatum)DefaultTemporalDatum.DUBLIN_JULIAN));
    }

    private static double epoch(TemporalDatum datum) {
        return (double)datum.getOrigin().getTime() / 8.64E7;
    }

    private String epochString(TemporalDatum datum) {
        return this.format.format(datum.getOrigin());
    }
}

