/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.referencing.CRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.junit.Assert;
import org.junit.Test;
import si.uom.SI;

public final class DefaultCartesianCSTest {
    @Test
    public void testAxis() {
        try {
            new DefaultCartesianCS("Test", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.LONGITUDE, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.LATITUDE);
            Assert.fail((String)"Angular units should not be accepted.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new DefaultCartesianCS("Test", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.NORTHING);
        try {
            new DefaultCartesianCS("Test", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.SOUTHING, (CoordinateSystemAxis)DefaultCoordinateSystemAxis.NORTHING);
            Assert.fail((String)"Colinear units should not be accepted.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DefaultCartesianCSTest.create(AxisDirection.NORTH_EAST, AxisDirection.SOUTH_EAST);
        try {
            DefaultCartesianCSTest.create(AxisDirection.NORTH_EAST, AxisDirection.EAST);
            Assert.fail((String)"Non-perpendicular axis should not be accepted.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DefaultCartesianCSTest.create(AxisDirection.NORTH_EAST, AxisDirection.UP);
        try {
            new DefaultCartesianCS("Test", (CoordinateSystemAxis)DefaultCoordinateSystemAxis.EASTING, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("Northing", AxisDirection.SOUTH, SI.METRE));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStandard() {
        DefaultCartesianCSTest.assertOrdered("East", "North", "East", "North");
        DefaultCartesianCSTest.assertOrdered("North", "East", "East", "North");
        DefaultCartesianCSTest.assertOrdered("South", "East", "East", "North");
        DefaultCartesianCSTest.assertOrdered("South", "West", "East", "North");
        DefaultCartesianCSTest.assertOrdered("East", "North");
        DefaultCartesianCSTest.assertOrdered("South-East", "North-East");
        DefaultCartesianCSTest.assertOrdered("North along  90 deg East", "North along   0 deg");
        DefaultCartesianCSTest.assertOrdered("North along  90 deg East", "North along   0 deg");
        DefaultCartesianCSTest.assertOrdered("North along  75 deg West", "North along 165 deg West");
        DefaultCartesianCSTest.assertOrdered("South along  90 deg West", "South along   0 deg");
        DefaultCartesianCSTest.assertOrdered("South along 180 deg", "South along  90 deg West");
        DefaultCartesianCSTest.assertOrdered("North along 130 deg West", "North along 140 deg East");
    }

    private static DefaultCoordinateSystemAxis create(AxisDirection direction) {
        if (direction.equals((Object)AxisDirection.NORTH)) {
            return DefaultCoordinateSystemAxis.NORTHING;
        }
        if (direction.equals((Object)AxisDirection.EAST)) {
            return DefaultCoordinateSystemAxis.EASTING;
        }
        if (direction.equals((Object)AxisDirection.SOUTH)) {
            return DefaultCoordinateSystemAxis.SOUTHING;
        }
        if (direction.equals((Object)AxisDirection.WEST)) {
            return DefaultCoordinateSystemAxis.WESTING;
        }
        return new DefaultCoordinateSystemAxis("Test", direction, SI.METRE);
    }

    private static DefaultCartesianCS create(AxisDirection x, AxisDirection y) {
        return new DefaultCartesianCS("Test", (CoordinateSystemAxis)DefaultCartesianCSTest.create(x), (CoordinateSystemAxis)DefaultCartesianCSTest.create(y));
    }

    private static DefaultCartesianCS create(String x, String y) {
        return DefaultCartesianCSTest.create(DefaultCoordinateSystemAxis.getDirection((String)x), DefaultCoordinateSystemAxis.getDirection((String)y));
    }

    private static void assertOrdered(String expectedX, String expectedY) {
        DefaultCartesianCSTest.assertOrdered(expectedY, expectedX, expectedX, expectedY);
        DefaultCartesianCSTest.assertOrdered(expectedX, expectedY, expectedX, expectedY);
    }

    private static void assertOrdered(String testX, String testY, String expectedX, String expectedY) {
        CoordinateSystem cs = AbstractCS.standard((CoordinateSystem)DefaultCartesianCSTest.create(testX, testY));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)DefaultCartesianCSTest.create(expectedX, expectedY), (Object)cs));
    }
}

