/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultAuthorityFactoryTest {
    @Before
    public void setupFactories() {
        ReferencingFactoryFinder.reset();
        System.setProperty("org.geotools.referencing.crs.usemockcrsfactory", Boolean.toString(true));
    }

    @Test
    public void testCRSStraight() throws Exception {
        DefaultAuthorityFactory factory = new DefaultAuthorityFactory(false);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("EPSG:99999");
        Assert.assertEquals((Object)"First", (Object)crs.getName().getCode());
    }

    @Test
    public void testMissingVersion() throws Exception {
        DefaultAuthorityFactory factory = new DefaultAuthorityFactory(false);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("urn:ogc:def:crs:EPSG:2.0:99999");
        Assert.assertEquals((Object)"First", (Object)crs.getName().getCode());
    }

    @Test
    public void testVersionBeforePriority() throws Exception {
        DefaultAuthorityFactory factory = new DefaultAuthorityFactory(false);
        CoordinateReferenceSystem crs = factory.createCoordinateReferenceSystem("urn:ogc:def:crs:EPSG:3.0:99999");
        Assert.assertEquals((Object)"Third", (Object)crs.getName().getCode());
    }

    @After
    public void cleanUp() {
        System.clearProperty("org.geotools.referencing.crs.usemockcrsfactory");
        ReferencingFactoryFinder.reset();
    }
}

