/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.net.URI;
import org.geotools.referencing.operation.transform.NTv2Transform;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.operation.TransformException;

public class NTv2TransformTest {
    private static final String TEST_GRID = "BALR2009.gsb";
    private static final String INEXISTENT_GRID = "this_NTv2_grid_does_not_exist";
    private static final double[] TEST_POINT_SRC = new double[]{3.084896111, 39.592654167};
    private static final double[] TEST_POINT_DST = new double[]{3.083801819, 39.5914804};
    private static final double TOLERANCE = 1.8E-6;
    private NTv2Transform transform;

    @Before
    public void setUp() throws Exception {
        this.transform = new NTv2Transform(new URI(TEST_GRID));
    }

    @Test
    public void testGetSourceDimensions() {
        Assert.assertEquals((long)this.transform.getSourceDimensions(), (long)2L);
    }

    @Test
    public void testGetTargetDimensions() {
        Assert.assertEquals((long)this.transform.getTargetDimensions(), (long)2L);
    }

    @Test
    public void testGetParameterValues() {
        ParameterValueGroup pvg = this.transform.getParameterValues();
        Assert.assertEquals((Object)pvg.getDescriptor(), (Object)NTv2Transform.Provider.PARAMETERS);
        Assert.assertEquals((long)pvg.values().size(), (long)1L);
        Object value = pvg.parameter("8656").getValue();
        Assert.assertTrue((boolean)(value instanceof URI));
        Assert.assertEquals((Object)value.toString(), (Object)TEST_GRID);
        value = pvg.parameter("Latitude and longitude difference file").getValue();
        Assert.assertTrue((boolean)(value instanceof URI));
        Assert.assertEquals((Object)value.toString(), (Object)TEST_GRID);
    }

    @Test
    public void testNTv2Transform() throws Exception {
        try {
            new NTv2Transform(null);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            // empty catch block
        }
        try {
            new NTv2Transform(new URI(INEXISTENT_GRID));
        }
        catch (NoSuchIdentifierException e) {
            return;
        }
        try {
            new NTv2Transform(new URI(INEXISTENT_GRID));
        }
        catch (NoSuchIdentifierException e) {
            return;
        }
    }

    @Test
    public void testInverse() throws TransformException {
        Assert.assertSame((Object)this.transform, (Object)this.transform.inverse().inverse());
        double[] p1 = new double[2];
        double[] p2 = new double[2];
        this.transform.inverse().transform(TEST_POINT_SRC, 0, p1, 0, 1);
        this.transform.inverseTransform(TEST_POINT_SRC, 0, p2, 0, 1);
        Assert.assertEquals((double)p1[0], (double)p2[0], (double)1.8E-6);
        Assert.assertEquals((double)p1[1], (double)p2[1], (double)1.8E-6);
    }

    @Test
    public void testTransform() throws TransformException {
        double[] p = new double[2];
        this.transform.transform(TEST_POINT_SRC, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)TEST_POINT_DST[0], (double)1.8E-6);
        Assert.assertEquals((double)p[1], (double)TEST_POINT_DST[1], (double)1.8E-6);
    }

    @Test
    public void testTransformTranslated() throws TransformException {
        double[] src = new double[4];
        double[] dst = new double[4];
        src[2] = TEST_POINT_SRC[0];
        src[3] = TEST_POINT_SRC[1];
        this.transform.transform(src, 2, dst, 2, 1);
        Assert.assertEquals((double)0.0, (double)dst[0], (double)1.8E-6);
        Assert.assertEquals((double)0.0, (double)dst[1], (double)1.8E-6);
        Assert.assertEquals((double)dst[2], (double)TEST_POINT_DST[0], (double)1.8E-6);
        Assert.assertEquals((double)dst[3], (double)TEST_POINT_DST[1], (double)1.8E-6);
    }

    @Test
    public void testInverseTransform() throws TransformException {
        double[] p = new double[2];
        this.transform.inverseTransform(TEST_POINT_DST, 0, p, 0, 1);
        Assert.assertEquals((double)p[0], (double)TEST_POINT_SRC[0], (double)1.8E-6);
        Assert.assertEquals((double)p[1], (double)TEST_POINT_SRC[1], (double)1.8E-6);
    }

    @Test
    public void testInverseTransformTranslated() throws TransformException {
        double[] src = new double[4];
        double[] dst = new double[4];
        src[2] = TEST_POINT_DST[0];
        src[3] = TEST_POINT_DST[1];
        this.transform.inverseTransform(src, 2, dst, 2, 1);
        Assert.assertEquals((double)0.0, (double)dst[0], (double)1.8E-6);
        Assert.assertEquals((double)0.0, (double)dst[1], (double)1.8E-6);
        Assert.assertEquals((double)dst[2], (double)TEST_POINT_SRC[0], (double)1.8E-6);
        Assert.assertEquals((double)dst[3], (double)TEST_POINT_SRC[1], (double)1.8E-6);
    }

    @Test
    public void testHashCodeEquals() throws Exception {
        NTv2Transform t2 = new NTv2Transform(new URI(TEST_GRID));
        Assert.assertEquals((Object)this.transform, (Object)t2);
        Assert.assertEquals((long)this.transform.hashCode(), (long)t2.hashCode());
    }
}

