/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import javax.measure.Unit;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.TransformTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class GeocentricTransformTest
extends TransformTestBase {
    @Test
    public void testEllipsoid() throws FactoryException {
        double i;
        DefaultEllipsoid e = DefaultEllipsoid.WGS84;
        double hm = 0.008333333333333333;
        Assert.assertEquals((String)"Nautical mile at equator", (double)1842.78, (double)e.orthodromicDistance(0.0, -0.008333333333333333, 0.0, 0.008333333333333333), (double)0.2);
        Assert.assertEquals((String)"Nautical mile at North pole", (double)1861.67, (double)e.orthodromicDistance(0.0, 89.98333333333333, 0.0, 90.0), (double)0.2);
        Assert.assertEquals((String)"Nautical mile at South pole", (double)1861.67, (double)e.orthodromicDistance(0.0, -89.98333333333333, 0.0, -90.0), (double)0.2);
        Assert.assertEquals((String)"International nautical mile", (double)1852.0, (double)e.orthodromicDistance(0.0, 44.99166666666667, 0.0, 45.00833333333333), (double)0.2);
        for (double i2 = 0.01; i2 < 180.0; i2 += 1.0) {
            double base = 180.0 * random.nextDouble() - 90.0;
            Assert.assertEquals((String)(i2 + "\u00b0 rotation"), (double)(e.getSemiMajorAxis() * Math.toRadians(i2)), (double)e.orthodromicDistance(base, 0.0, base + i2, 0.0), (double)0.2);
        }
        double radius = e.getSemiMajorAxis();
        double circumference = radius * 1.00000001 * (Math.PI * 2);
        DefaultEllipsoid s = DefaultEllipsoid.createEllipsoid((String)"Sphere", (double)radius, (double)radius, (Unit)e.getAxisUnit());
        Assert.assertTrue((String)"Spheroid class", (!DefaultEllipsoid.class.equals(s.getClass()) ? 1 : 0) != 0);
        for (i = 0.0; i <= 180.0; i += 1.0) {
            double base = 360.0 * random.nextDouble() - 180.0;
            Assert.assertEquals((String)(i + "\u00b0 rotation"), (double)(s.getSemiMajorAxis() * Math.toRadians(i)), (double)s.orthodromicDistance(base, 0.0, base + i, 0.0), (double)0.001);
        }
        for (i = -90.0; i <= 90.0; i += 1.0) {
            double meridian = 360.0 * random.nextDouble() - 180.0;
            Assert.assertEquals((String)(i + "\u00b0 rotation"), (double)(s.getSemiMajorAxis() * Math.toRadians(Math.abs(i))), (double)s.orthodromicDistance(meridian, 0.0, meridian, i), (double)0.001);
        }
        for (int i3 = 0; i3 < 100; ++i3) {
            double x2;
            double y1 = -90.0 + 180.0 * random.nextDouble();
            double y2 = -90.0 + 180.0 * random.nextDouble();
            double x1 = -180.0 + 360.0 * random.nextDouble();
            double distance = s.orthodromicDistance(x1, y1, x2 = -180.0 + 360.0 * random.nextDouble(), y2);
            Assert.assertTrue((String)"Range of legal values", (distance >= 0.0 && distance <= circumference ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGeocentricTransform() throws FactoryException, TransformException {
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.WGS84;
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84_3D;
        DefaultGeocentricCRS targetCRS = DefaultGeocentricCRS.CARTESIAN;
        CoordinateOperation operation = this.opFactory.createOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        MathTransform transform = operation.getMathTransform();
        int dimension = transform.getSourceDimensions();
        Assert.assertEquals((String)"Source dimension", (long)3L, (long)dimension);
        Assert.assertEquals((String)"Target dimension", (long)3L, (long)transform.getTargetDimensions());
        Assert.assertSame((String)"Inverse transform", (Object)transform, (Object)transform.inverse().inverse());
        GeocentricTransformTest.assertInterfaced(transform);
        double[] cartesianDistance = new double[4];
        double[] orthodromicDistance = new double[4];
        double[] array0 = new double[900];
        for (int i = 0; i < array0.length; ++i) {
            int range;
            switch (i % 3) {
                case 0: {
                    range = 360;
                    break;
                }
                case 1: {
                    range = 180;
                    break;
                }
                case 2: {
                    range = 10000;
                    break;
                }
                default: {
                    range = 0;
                }
            }
            array0[i] = (double)range * random.nextDouble() - (double)(range / 2);
        }
        array0[0] = 35.0;
        array0[1] = 24.0;
        array0[2] = 8000.0;
        array0[3] = 34.8;
        array0[4] = 24.7;
        array0[5] = 5000.0;
        cartesianDistance[0] = 80284.0;
        orthodromicDistance[0] = 80302.99;
        array0[6] = 0.0;
        array0[7] = 0.0;
        array0[8] = 0.0;
        array0[9] = 180.0;
        array0[10] = 0.0;
        array0[11] = 0.0;
        cartesianDistance[1] = ellipsoid.getSemiMajorAxis() * 2.0;
        orthodromicDistance[1] = 2.000393146E7;
        array0[12] = 0.0;
        array0[13] = -90.0;
        array0[14] = 0.0;
        array0[15] = 180.0;
        array0[16] = 90.0;
        array0[17] = 0.0;
        cartesianDistance[2] = ellipsoid.getSemiMinorAxis() * 2.0;
        orthodromicDistance[2] = 2.000393146E7;
        array0[18] = 95.0;
        array0[19] = -38.0;
        array0[20] = 0.0;
        array0[21] = -85.0;
        array0[22] = 38.0;
        array0[23] = 0.0;
        cartesianDistance[3] = 1.274014719E7;
        orthodromicDistance[3] = 2.000393146E7;
        double[] array1 = new double[array0.length];
        double[] array2 = new double[array0.length];
        transform.transform(array0, 0, array1, 0, array0.length / dimension);
        transform.inverse().transform(array1, 0, array2, 0, array1.length / dimension);
        GeocentricTransformTest.assertPointsEqual("transform(Geographic --> Geocentric --> Geographic)", array0, array2, new double[]{2.777777777777778E-5, 2.777777777777778E-5, 0.01});
        for (int i = 0; i < array0.length / 6; ++i) {
            int base = i * 6;
            double[] pt1 = new double[]{array1[base + 0], array1[base + 1], array1[base + 2]};
            double[] pt2 = new double[]{array1[base + 3], array1[base + 4], array1[base + 5]};
            double dX = Math.abs(pt1[0] - pt2[0]);
            double dY = Math.abs(pt1[1] - pt2[1]);
            double dZ = Math.abs(pt1[2] - pt2[2]);
            double cartesian = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
            if (i < cartesianDistance.length) {
                Assert.assertEquals((String)("Cartesian distance[" + i + ']'), (double)cartesianDistance[i], (double)cartesian, (double)0.1);
            }
            try {
                double altitude = Math.max(array0[base + 2], array0[base + 5]);
                DefaultEllipsoid ellip = DefaultEllipsoid.createFlattenedSphere((String)"Temporary", (double)(ellipsoid.getSemiMajorAxis() + altitude), (double)ellipsoid.getInverseFlattening(), (Unit)ellipsoid.getAxisUnit());
                double orthodromic = ellip.orthodromicDistance(array0[base + 0], array0[base + 1], array0[base + 3], array0[base + 4]);
                orthodromic = Math.hypot(orthodromic, array0[base + 2] - array0[base + 5]);
                if (i < orthodromicDistance.length) {
                    Assert.assertEquals((String)("Orthodromic distance[" + i + ']'), (double)orthodromicDistance[i], (double)orthodromic, (double)0.1);
                }
                Assert.assertTrue((String)("Distance consistency[" + i + ']'), (cartesian <= orthodromic ? 1 : 0) != 0);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
    }
}

