/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.operation.Matrix;

public class GeneralMatrixTest {
    private static double EPSILON_TOLERANCE = 1.0E-6;
    private static double[][] zero2 = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
    private static double[][] id2 = new double[][]{{1.0, 0.0}, {0.0, 1.0}};
    private static double[][] id4 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private static double[][] id23 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    private static double[][] id32 = new double[][]{{1.0, 0.0}, {0.0, 1.0}, {0.0, 0.0}};
    private static double[][] array1 = new double[][]{{1.2, -3.4}, {-5.6, 7.8}, {9.0, -1.0}};
    private static double[][] negativeArray1 = new double[][]{{-1.2, 3.4}, {5.6, -7.8}, {-9.0, 1.0}};
    private static double[] array1flatten = new double[]{1.2, -3.4, -5.6, 7.8, 9.0, -1.0};
    private static AffineTransform affineTransform = new AffineTransform(1.2, 3.4, 5.6, 7.8, 9.0, 1.0);
    private static double[][] affineMatrix = new double[][]{{1.2, 5.6, 9.0}, {3.4, 7.8, 1.0}, {0.0, 0.0, 1.0}};
    private static double[][] matrix33 = new double[][]{{1.2, 5.6, 9.0}, {3.4, 7.8, 1.0}, {-2.3, 4.6, 1.0}};
    private static double[][] sub32 = new double[][]{{1.2, 5.6}, {3.4, 7.8}, {-2.3, 4.6}};
    private static double[][] sub22 = new double[][]{{1.2, 5.6}, {3.4, 7.8}};
    private static double[][] arrayA = new double[][]{{2.0, 6.0}, {4.0, 7.0}};
    private static double[][] arrayAInverse = new double[][]{{-0.7, 0.6}, {0.4, -0.2}};
    private static GeneralMatrix generalAffineMatrix = new GeneralMatrix(affineMatrix);
    private static GeneralMatrix matrix1 = new GeneralMatrix(array1);
    AffineTransform2D affineTransform2D = new AffineTransform2D(affineTransform);

    @Test
    public void constructorTests() {
        GeneralMatrix squareId2 = new GeneralMatrix(2);
        double[][] array2 = squareId2.getElements();
        Assert.assertArrayEquals((Object[])array2, (Object[])id2);
        GeneralMatrix squareId = new GeneralMatrix(4);
        double[][] array = squareId.getElements();
        Assert.assertArrayEquals((Object[])array, (Object[])id4);
        GeneralMatrix squareId23 = new GeneralMatrix(2, 3);
        double[][] array23 = squareId23.getElements();
        Assert.assertArrayEquals((Object[])array23, (Object[])id23);
        GeneralMatrix squareId32 = new GeneralMatrix(3, 2);
        double[][] array32 = squareId32.getElements();
        Assert.assertArrayEquals((Object[])array32, (Object[])id32);
        GeneralMatrix matrix1 = new GeneralMatrix(3, 2, array1flatten);
        double[][] matrix1array = matrix1.getElements();
        Assert.assertArrayEquals((Object[])array1, (Object[])matrix1array);
        GeneralMatrix matrix2 = new GeneralMatrix(array1);
        double[][] matrix2array = matrix2.getElements();
        Assert.assertArrayEquals((Object[])array1, (Object[])matrix2array);
        Matrix2 matrix2zero = new Matrix2(0.0, 0.0, 0.0, 0.0);
        GeneralMatrix gm2zero = new GeneralMatrix((Matrix)matrix2zero);
        Assert.assertArrayEquals((Object[])gm2zero.getElements(), (Object[])zero2);
        matrix2zero.setIdentity();
        GeneralMatrix gm2id = new GeneralMatrix((Matrix)matrix2zero);
        Assert.assertArrayEquals((Object[])gm2id.getElements(), (Object[])id2);
        GeneralMatrix gmsid2 = new GeneralMatrix(squareId2);
        double[][] gmsid2array = gmsid2.getElements();
        Assert.assertArrayEquals((Object[])gmsid2array, (Object[])id2);
        GeneralMatrix affineGeneralMatrix = new GeneralMatrix(affineTransform);
        double[][] affineMatrixarray = affineGeneralMatrix.getElements();
        Assert.assertArrayEquals((Object[])affineMatrixarray, (Object[])affineMatrix);
    }

    @Test
    public void getElementsTest() {
        double[][] affineTransformElements = GeneralMatrix.getElements((Matrix)this.affineTransform2D);
        Assert.assertArrayEquals((Object[])affineTransformElements, (Object[])affineMatrix);
        double[][] generalAffineMatrixElements = GeneralMatrix.getElements((Matrix)generalAffineMatrix);
        Assert.assertArrayEquals((Object[])generalAffineMatrixElements, (Object[])affineMatrix);
    }

    @Test(expected=IllegalStateException.class)
    public void affineTest() {
        Assert.assertTrue((boolean)generalAffineMatrix.isAffine());
        Assert.assertFalse((boolean)matrix1.isAffine());
        AffineTransform affineTransform1 = generalAffineMatrix.toAffineTransform2D();
        Assert.assertNotNull((Object)affineTransform1);
        matrix1.toAffineTransform2D();
    }

    @Test
    public void negateTest() {
        GeneralMatrix gm = new GeneralMatrix(array1);
        gm.negate();
        Assert.assertArrayEquals((Object[])gm.getElements(), (Object[])negativeArray1);
        gm.negate();
        Assert.assertArrayEquals((Object[])gm.getElements(), (Object[])array1);
    }

    @Test
    public void invertTest() {
        GeneralMatrix gm = new GeneralMatrix(id4);
        gm.invert();
        GeneralMatrix gm2 = new GeneralMatrix(id4);
        GeneralMatrix.epsilonEquals((Matrix)gm, (Matrix)gm2, (double)EPSILON_TOLERANCE);
        GeneralMatrix gma = new GeneralMatrix(arrayA);
        gma.invert();
        GeneralMatrix gmaInverse = new GeneralMatrix(arrayAInverse);
        GeneralMatrix.epsilonEquals((Matrix)gma, (Matrix)gmaInverse, (double)EPSILON_TOLERANCE);
        gma.invert();
        GeneralMatrix gma2 = new GeneralMatrix(arrayA);
        GeneralMatrix.epsilonEquals((Matrix)gma, (Matrix)gma2, (double)EPSILON_TOLERANCE);
    }

    @Test
    public void invertAccuracyTest() {
        GeneralMatrix matrix = new GeneralMatrix((double[][])new double[][]{{1.0000000000000002, 0.0, -1.1641532182693481E-10}, {0.0, 1.0000000000000002, 0.0}, {0.0, 0.0, 1.0}});
        GeneralMatrix inverse = matrix.clone();
        inverse.invert();
        matrix.mul((Matrix)inverse);
        GeneralMatrix sourceScale = new GeneralMatrix((double[][])new double[][]{{0.9996, 0.0, 500000.0}, {0.0, 0.9996, 0.0}, {0.0, 0.0, 1.0}});
        GeneralMatrix targetScale = new GeneralMatrix((double[][])new double[][]{{0.9996, 0.0, 500000.0}, {0.0, 0.9996, 0.0}, {0.0, 0.0, 1.0}});
        sourceScale.invert();
        targetScale.multiply((Matrix)sourceScale);
        Assert.assertFalse((String)"inverse exact", (boolean)targetScale.isIdentity());
        Assert.assertFalse((String)"inverse 1E-10", (boolean)targetScale.isIdentity(1.0E-10));
        Assert.assertTrue((String)"inverse 1E-9", (boolean)targetScale.isIdentity(1.0E-9));
    }

    @Test
    public void sizeTests() {
        GeneralMatrix gm = new GeneralMatrix(id32);
        Assert.assertEquals((long)gm.getNumRow(), (long)3L);
        Assert.assertEquals((long)gm.getNumCol(), (long)2L);
    }

    @Test
    public void getSetElementTest() {
        GeneralMatrix gm = new GeneralMatrix(id2);
        Assert.assertEquals((double)gm.getElement(0, 0), (double)1.0, (double)EPSILON_TOLERANCE);
        double[] newRow = new double[]{10.11, 12.23};
        gm.setRow(0, newRow);
        Assert.assertEquals((double)gm.getElement(0, 0), (double)10.11, (double)EPSILON_TOLERANCE);
        gm.setElement(0, 0, 12.23);
        Assert.assertEquals((double)gm.getElement(0, 0), (double)12.23, (double)EPSILON_TOLERANCE);
        gm.setZero();
        Assert.assertEquals((double)gm.getElement(0, 0), (double)0.0, (double)EPSILON_TOLERANCE);
    }

    @Test
    public void identityTest() {
        GeneralMatrix id = new GeneralMatrix(id4);
        Assert.assertTrue((boolean)id.isIdentity());
        id.setElement(0, 0, 1.0001);
        Assert.assertFalse((boolean)id.isIdentity());
        Assert.assertTrue((boolean)GeneralMatrix.isIdentity((Matrix)id, (double)0.01));
        id.setIdentity();
        Assert.assertTrue((boolean)id.isIdentity());
    }

    @Test
    public void equalsHashcodeTest() {
        GeneralMatrix gm1 = new GeneralMatrix(affineMatrix);
        GeneralMatrix gm2 = new GeneralMatrix(affineMatrix);
        Assert.assertTrue((boolean)gm1.equals((Object)gm2));
        gm2.setElement(2, 2, gm2.getElement(2, 2) + 1.0E-4);
        Assert.assertTrue((boolean)gm1.equals((Matrix)gm2, 0.001));
        Assert.assertTrue((boolean)GeneralMatrix.epsilonEquals((Matrix)gm1, (Matrix)gm2, (double)0.001));
        Assert.assertFalse((boolean)gm1.equals((Object)gm2));
    }

    @Test
    public void copySubMatrixTest() {
        GeneralMatrix big = new GeneralMatrix(matrix33);
        GeneralMatrix m32 = new GeneralMatrix(3, 2);
        GeneralMatrix m22 = new GeneralMatrix(2, 2);
        GeneralMatrix second = new GeneralMatrix(2, 2);
        big.copySubMatrix(0, 0, 3, 2, 0, 0, m32);
        Assert.assertArrayEquals((Object[])m32.getElements(), (Object[])sub32);
        m32.copySubMatrix(0, 0, 2, 2, 0, 0, m22);
        Assert.assertArrayEquals((Object[])m22.getElements(), (Object[])sub22);
        big.copySubMatrix(0, 0, 2, 2, 0, 0, second);
        Assert.assertTrue((boolean)m22.equals((Object)second));
    }
}

