/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.net.URL;
import java.util.Set;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.epsg.FactoryUsingWKT;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;

public final class FallbackAuthorityFactoryTest {
    private static final boolean VERBOSE = false;
    private FactoryEPSGExtra extra;

    @Before
    public void setUp() {
        Assert.assertNull((Object)((Object)this.extra));
        CRS.reset((String)"all");
        this.extra = new FactoryEPSGExtra();
        ReferencingFactoryFinder.addAuthorityFactory((AuthorityFactory)this.extra);
        ReferencingFactoryFinder.scanForPlugins();
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)((Object)this.extra));
        ReferencingFactoryFinder.removeAuthorityFactory((AuthorityFactory)this.extra);
        this.extra = null;
    }

    @Test
    public void testFactoryOrdering() {
        Set factories = ReferencingFactoryFinder.getCRSAuthorityFactories(null);
        for (CRSAuthorityFactory cRSAuthorityFactory : factories) {
        }
        boolean foundWkt = false;
        boolean foundExtra = false;
        for (CRSAuthorityFactory factory : factories) {
            Class<?> type = factory.getClass();
            if (type == FactoryEPSGExtra.class) {
                foundExtra = true;
                continue;
            }
            if (type != FactoryUsingWKT.class) continue;
            foundWkt = true;
            Assert.assertTrue((String)"We should have encountered WKT factory after the extra one", (boolean)foundExtra);
        }
        Assert.assertTrue((boolean)foundWkt);
        Assert.assertTrue((boolean)foundExtra);
    }

    @Test
    public void test42101() throws FactoryException {
        Assert.assertTrue((boolean)(CRS.decode((String)"EPSG:42101") instanceof ProjectedCRS));
    }

    @Test
    public void test00001() throws FactoryException {
        try {
            CRS.decode((String)"EPSG:00001");
            Assert.fail((String)"This code should not be there");
        }
        catch (NoSuchAuthorityCodeException e) {
            Assert.fail((String)"The code 00001 is there, exception should report it's broken");
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
    }

    @Test
    public void testLookupSuccessfull() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:42101");
        String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
        Assert.assertEquals((Object)"EPSG:42101", (Object)code);
    }

    @Test
    public void testLookupFailing() throws FactoryException {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"Google Mercator\",\n  GEOGCS[\"WGS 84\",\n    DATUM[\"World Geodetic System 1984\",\n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],\n      AUTHORITY[\"EPSG\",\"6326\"]],\n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Geodetic latitude\", NORTH],\n    AXIS[\"Geodetic longitude\", EAST],\n    AUTHORITY[\"EPSG\",\"4326\"]],\n  PROJECTION[\"Mercator_1SP\"],\n  PARAMETER[\"semi_minor\", 6378137.0],\n  PARAMETER[\"latitude_of_origin\", 0.0],\n  PARAMETER[\"central_meridian\", 0.0],\n  PARAMETER[\"scale_factor\", 1.0],\n  PARAMETER[\"false_easting\", 0.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"m\", 1.0],\n  AXIS[\"Easting\", EAST],\n  AXIS[\"Northing\", NORTH],\n  AUTHORITY[\"EPSG\",\"900913\"]]");
        Assert.assertNull((Object)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true));
    }

    private static class FactoryEPSGExtra
    extends FactoryUsingWKT {
        public FactoryEPSGExtra() {
            super(null, 85);
        }

        protected URL getDefinitionsURL() {
            return FactoryUsingWKT.class.getResource("epsg2.properties");
        }
    }
}

