/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.DefaultOperation;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.InternationalString;

public class PropertyCoordinateOperationAuthorityFactory
extends DirectAuthorityFactory
implements CoordinateOperationAuthorityFactory {
    private final Citation authority;
    private final Properties definitions = new Properties();
    private final Set<String> codes = Collections.unmodifiableSet(this.definitions.keySet());

    public PropertyCoordinateOperationAuthorityFactory(ReferencingFactoryContainer factories, Citation authority, URL definitions) throws IOException {
        super(factories, 11);
        this.authority = authority;
        PropertyCoordinateOperationAuthorityFactory.ensureNonNull("authority", authority);
        try (InputStream in = definitions.openStream();){
            this.definitions.load(in);
        }
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        Set<CoordinateOperation> coordopset;
        String[] crsPair = this.trimAuthority(code).split(",");
        if (crsPair.length == 2 && !(coordopset = this.createFromCoordinateReferenceSystemCodes(this.trimAuthority(crsPair[0]), this.trimAuthority(crsPair[1]))).isEmpty()) {
            return coordopset.iterator().next();
        }
        return null;
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws NoSuchAuthorityCodeException, FactoryException {
        HashSet<CoordinateOperation> coordops = new HashSet<CoordinateOperation>(1);
        CoordinateOperation coordop = this.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS, false);
        if (coordop == null) {
            coordop = this.createFromCoordinateReferenceSystemCodes(targetCRS, sourceCRS, true);
        }
        if (coordop != null) {
            coordops.add(coordop);
        }
        return coordops;
    }

    CoordinateOperation createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS, boolean inverse) throws NoSuchAuthorityCodeException, FactoryException {
        String methodName;
        String id = (sourceCRS = this.trimAuthority(sourceCRS)) + "," + (targetCRS = this.trimAuthority(targetCRS));
        String WKT = this.definitions.getProperty(id);
        if (WKT == null) {
            return null;
        }
        MathTransform mt = null;
        try {
            mt = this.factories.getMathTransformFactory().createFromWKT(WKT);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Error creating transformation: " + WKT, e);
            return null;
        }
        String s = ((Identifier)this.authority.getIdentifiers().iterator().next()).getCode();
        CoordinateReferenceSystem source = CRS.decode(s + ":" + sourceCRS);
        CoordinateReferenceSystem target = CRS.decode(s + ":" + targetCRS);
        DefaultMathTransformFactory mtf = (DefaultMathTransformFactory)this.factories.getMathTransformFactory();
        MathTransform mt2 = mtf.createBaseToDerived(source, mt, target.getCoordinateSystem());
        try {
            methodName = mt instanceof AbstractMathTransform ? ((AbstractMathTransform)mt).getParameterValues().getDescriptor().getName().getCode() : (mt instanceof AffineTransform2D ? ((AffineTransform2D)mt).getParameterValues().getDescriptor().getName().getCode() : mt.getClass().getSimpleName());
        }
        catch (NullPointerException e) {
            methodName = mt.getClass().getSimpleName();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("name", methodName);
        DefaultOperationMethod method = new DefaultOperationMethod(props, mt2.getSourceDimensions(), mt2.getTargetDimensions(), null);
        CoordinateOperation coordop = null;
        if (!inverse) {
            props.put("name", sourceCRS + " \u21e8 " + targetCRS);
            coordop = DefaultOperation.create(props, source, target, mt2, method, CoordinateOperation.class);
        } else {
            try {
                props.put("name", targetCRS + " \u21e8 " + sourceCRS);
                coordop = DefaultOperation.create(props, target, source, mt2.inverse(), method, CoordinateOperation.class);
            }
            catch (NoninvertibleTransformException e) {
                return null;
            }
        }
        return coordop;
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) {
        if (type == null || type.isAssignableFrom(CoordinateOperation.class)) {
            return this.codes;
        }
        return Collections.emptySet();
    }

    public InternationalString getDescriptionText(String code) throws NoSuchAuthorityCodeException, FactoryException {
        int end;
        String wkt = this.definitions.getProperty(this.trimAuthority(code));
        if (wkt == null) {
            throw this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        int start = wkt.indexOf(34);
        if (start >= 0 && (end = wkt.indexOf(34, ++start)) >= 0) {
            return new SimpleInternationalString(wkt.substring(start, end).trim());
        }
        return null;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }
}

