/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.util.Classes;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationMethod;

abstract class AuthorityFactoryProxy {
    private static final List<Class<? extends IdentifiedObject>> TYPES = new ArrayList<Class>(Arrays.asList(CoordinateOperation.class, OperationMethod.class, ParameterDescriptor.class, ProjectedCRS.class, GeographicCRS.class, GeocentricCRS.class, ImageCRS.class, DerivedCRS.class, VerticalCRS.class, TemporalCRS.class, EngineeringCRS.class, CompoundCRS.class, CoordinateReferenceSystem.class, CoordinateSystemAxis.class, CartesianCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, CoordinateSystem.class, PrimeMeridian.class, Ellipsoid.class, GeodeticDatum.class, ImageDatum.class, VerticalDatum.class, TemporalDatum.class, EngineeringDatum.class, Datum.class, IdentifiedObject.class));

    AuthorityFactoryProxy() {
    }

    public static AuthorityFactoryProxy getInstance(AuthorityFactory factory, Class<? extends IdentifiedObject> type) {
        AbstractAuthorityFactory.ensureNonNull("type", type);
        AbstractAuthorityFactory.ensureNonNull("factory", factory);
        type = AuthorityFactoryProxy.getType(type);
        if (factory instanceof CRSAuthorityFactory) {
            CRSAuthorityFactory crsFactory = (CRSAuthorityFactory)factory;
            if (type.equals(ProjectedCRS.class)) {
                return new Projected(crsFactory);
            }
            if (type.equals(GeographicCRS.class)) {
                return new Geographic(crsFactory);
            }
            if (type.equals(CoordinateReferenceSystem.class)) {
                return new CRS(crsFactory);
            }
        }
        return new Default(factory, type);
    }

    public static Class<? extends IdentifiedObject> getType(Class<? extends IdentifiedObject> type) throws IllegalArgumentException {
        for (Class<? extends IdentifiedObject> candidate : TYPES) {
            if (!candidate.isAssignableFrom(type)) continue;
            return candidate;
        }
        throw new IllegalArgumentException(Errors.format((int)61, type, IdentifiedObject.class));
    }

    public abstract Class<? extends IdentifiedObject> getType();

    public abstract AuthorityFactory getAuthorityFactory();

    public final Set<String> getAuthorityCodes() throws FactoryException {
        return this.getAuthorityFactory().getAuthorityCodes(this.getType());
    }

    public abstract IdentifiedObject create(String var1) throws NoSuchAuthorityCodeException, FactoryException;

    public String toString() {
        return this.toString(AuthorityFactoryProxy.class);
    }

    final String toString(Class owner) {
        AuthorityFactory factory = this.getAuthorityFactory();
        return Classes.getShortName((Class)owner) + "[" + Classes.getShortName(this.getType()) + " in " + Classes.getShortClassName((Object)factory) + "(\"" + String.valueOf(factory.getAuthority().getTitle()) + "\")]";
    }

    private static final class Projected
    extends CRS {
        protected Projected(CRSAuthorityFactory factory) {
            super(factory);
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return ProjectedCRS.class;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createProjectedCRS(code);
        }
    }

    private static final class Geographic
    extends CRS {
        protected Geographic(CRSAuthorityFactory factory) {
            super(factory);
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return GeographicCRS.class;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createGeographicCRS(code);
        }
    }

    private static class CRS
    extends AuthorityFactoryProxy {
        protected final CRSAuthorityFactory factory;

        protected CRS(CRSAuthorityFactory factory) {
            this.factory = factory;
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return CoordinateReferenceSystem.class;
        }

        @Override
        public final AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            return this.factory.createCoordinateReferenceSystem(code);
        }
    }

    private static final class Default
    extends AuthorityFactoryProxy {
        private static final Class[] PARAMETERS = new Class[]{String.class};
        private final AuthorityFactory factory;
        private final Class<? extends IdentifiedObject> type;
        private final Method method;

        Default(AuthorityFactory factory, Class<? extends IdentifiedObject> type) throws IllegalArgumentException {
            Method[] candidates;
            this.factory = factory;
            this.type = type;
            for (Method c : candidates = factory.getClass().getMethods()) {
                if (!c.getName().startsWith("create") || !type.equals(c.getReturnType()) || !Arrays.equals(PARAMETERS, c.getParameterTypes())) continue;
                this.method = c;
                return;
            }
            throw new IllegalArgumentException(Errors.format((int)187, type));
        }

        @Override
        public Class<? extends IdentifiedObject> getType() {
            return this.type;
        }

        @Override
        public AuthorityFactory getAuthorityFactory() {
            return this.factory;
        }

        @Override
        public IdentifiedObject create(String code) throws FactoryException {
            try {
                return (IdentifiedObject)this.method.invoke((Object)this.factory, code);
            }
            catch (InvocationTargetException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    throw (FactoryException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new FactoryException(cause.getLocalizedMessage(), cause);
            }
            catch (IllegalAccessException exception) {
                throw new FactoryException(exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }
}

