/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.Properties;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.NameFactory;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class AbstractIdentifiedObject
extends Formattable
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final ReferenceIdentifier[] EMPTY_IDENTIFIER_ARRAY = new ReferenceIdentifier[0];
    public static final GenericName[] EMPTY_ALIAS_ARRAY = new GenericName[0];
    public static final Comparator<IdentifiedObject> NAME_COMPARATOR = new NameComparator();
    public static final Comparator<IdentifiedObject> IDENTIFIER_COMPARATOR = new IdentifierComparator();
    public static final Comparator<IdentifiedObject> REMARKS_COMPARATOR = new RemarksComparator();
    private final ReferenceIdentifier name;
    private final Collection<GenericName> alias;
    private final Set<ReferenceIdentifier> identifiers;
    private final InternationalString remarks;

    public AbstractIdentifiedObject(IdentifiedObject object) {
        this.name = object.getName();
        this.alias = object.getAlias();
        this.identifiers = object.getIdentifiers();
        this.remarks = object.getRemarks();
    }

    public AbstractIdentifiedObject(Map<String, ?> properties) throws IllegalArgumentException {
        this(properties, null, null);
    }

    protected AbstractIdentifiedObject(Map<String, ?> properties, Map<String, Object> subProperties, String ... localizables) throws IllegalArgumentException {
        AbstractIdentifiedObject.ensureNonNull("properties", properties);
        Object name = null;
        GrowableInternationalString alias = null;
        ReferenceIdentifier[] identifiers = null;
        GrowableInternationalString remarks = null;
        GrowableInternationalString growable = null;
        GrowableInternationalString[] subGrowables = null;
        block16: for (Map.Entry<String, ?> entry : properties.entrySet()) {
            String key = entry.getKey().trim().toLowerCase();
            Object value = entry.getValue();
            switch (key.hashCode()) {
                case -1528693765: {
                    if (!key.equalsIgnoreCase("anchorPoint")) break;
                    key = "anchorPoint";
                    break;
                }
                case -1805658881: {
                    if (!key.equalsIgnoreCase("bursaWolf")) break;
                    key = "bursaWolf";
                    break;
                }
                case 109688209: {
                    if (!key.equalsIgnoreCase("operationVersion")) break;
                    key = "operationVersion";
                    break;
                }
                case 1479434472: {
                    if (!key.equalsIgnoreCase("coordinateOperationAccuracy")) break;
                    key = "coordinateOperationAccuracy";
                    break;
                }
                case 1126917133: {
                    if (!key.equalsIgnoreCase("positionalAccuracy")) break;
                    key = "positionalAccuracy";
                    break;
                }
                case 1127093059: {
                    if (!key.equalsIgnoreCase("realizationEpoch")) break;
                    key = "realizationEpoch";
                    break;
                }
                case 1790520781: {
                    if (!key.equalsIgnoreCase("domainOfValidity")) break;
                    key = "domainOfValidity";
                    break;
                }
                case -1109785975: {
                    if (!key.equalsIgnoreCase("validArea")) break;
                    key = "validArea";
                    break;
                }
                case 3373707: {
                    if (!key.equals("name")) break;
                    if (value instanceof String) {
                        name = new NamedIdentifier(properties, false);
                        assert (value.equals(((Identifier)name).getCode())) : name;
                        continue block16;
                    }
                    name = value;
                    continue block16;
                }
                case 92902992: {
                    if (!key.equals("alias")) break;
                    alias = NameFactory.toArray(value);
                    continue block16;
                }
                case 1368189162: {
                    if (!key.equals("identifiers")) break;
                    if (value == null) continue block16;
                    if (value instanceof ReferenceIdentifier) {
                        identifiers = new ReferenceIdentifier[]{(ReferenceIdentifier)value};
                        continue block16;
                    }
                    identifiers = (ReferenceIdentifier[])value;
                    continue block16;
                }
                case 1091415283: {
                    if (!key.equals("remarks") || !(value instanceof InternationalString)) break;
                    remarks = (GrowableInternationalString)value;
                    continue block16;
                }
            }
            if (value instanceof String) {
                if (growable == null) {
                    growable = remarks instanceof GrowableInternationalString ? (GrowableInternationalString)remarks : new GrowableInternationalString();
                }
                if (growable.add("remarks", key, value.toString())) continue;
            }
            if (subProperties == null) continue;
            if (localizables != null) {
                String prefix;
                for (int i = 0; !(i >= localizables.length || key.equals(prefix = localizables[i]) && value instanceof InternationalString); ++i) {
                    if (!(value instanceof String)) continue;
                    if (subGrowables == null) {
                        subGrowables = new GrowableInternationalString[localizables.length];
                    }
                    if (subGrowables[i] == null) {
                        Object previous = subProperties.get(prefix);
                        subGrowables[i] = previous instanceof GrowableInternationalString ? (GrowableInternationalString)previous : new GrowableInternationalString();
                    }
                    if (subGrowables[i].add(prefix, key, value.toString())) continue block16;
                }
            }
            subProperties.put(key, value);
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else if (!growable.isSubsetOf(remarks)) {
                Logger logger = Logging.getLogger(AbstractIdentifiedObject.class);
                LogRecord record = Loggings.format((Level)Level.WARNING, (int)28);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        if (subProperties != null && subGrowables != null) {
            for (int i = 0; i < subGrowables.length; ++i) {
                growable = subGrowables[i];
                if (growable == null || growable.getLocales().isEmpty()) continue;
                String prefix = localizables[i];
                Object current = subProperties.get(prefix);
                if (current == null) {
                    subProperties.put(prefix, growable);
                    continue;
                }
                if (growable.isSubsetOf(current)) continue;
                Logger logger = Logging.getLogger(AbstractIdentifiedObject.class);
                LogRecord record = Loggings.format((Level)Level.WARNING, (int)28);
                record.setLoggerName(logger.getName());
                logger.log(record);
            }
        }
        String key = null;
        GrowableInternationalString value = null;
        try {
            key = "name";
            value = name;
            this.name = (ReferenceIdentifier)value;
            key = "alias";
            value = alias;
            this.alias = AbstractIdentifiedObject.asSet(value);
            key = "identifiers";
            value = identifiers;
            this.identifiers = AbstractIdentifiedObject.asSet(identifiers);
            key = "remarks";
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(Errors.format((int)58, (Object)key, value), key, value);
            e.initCause((Throwable)exception);
            throw e;
        }
        AbstractIdentifiedObject.ensureNonNull("name", name);
        AbstractIdentifiedObject.ensureNonNull("name", name.toString());
    }

    public ReferenceIdentifier getName() {
        return this.name;
    }

    public Collection<GenericName> getAlias() {
        if (this.alias == null) {
            return Collections.emptySet();
        }
        return this.alias;
    }

    public Set<ReferenceIdentifier> getIdentifiers() {
        if (this.identifiers == null) {
            return Collections.emptySet();
        }
        return this.identifiers;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public static Map<String, ?> getProperties(IdentifiedObject info) {
        return new Properties(info);
    }

    public static Map<String, Object> getProperties(IdentifiedObject info, Citation authority) {
        HashMap<String, Object> properties = new HashMap<String, Object>(AbstractIdentifiedObject.getProperties(info));
        properties.put("name", new NamedIdentifier(authority, info.getName().getCode()));
        properties.remove("identifiers");
        return properties;
    }

    public ReferenceIdentifier getIdentifier(Citation authority) {
        return AbstractIdentifiedObject.getIdentifier0(this, authority);
    }

    public static ReferenceIdentifier getIdentifier(IdentifiedObject info, Citation authority) {
        if (info instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)info).getIdentifier(authority);
        }
        return AbstractIdentifiedObject.getIdentifier0(info, authority);
    }

    private static ReferenceIdentifier getIdentifier0(IdentifiedObject info, Citation authority) {
        if (info == null) {
            return null;
        }
        for (Identifier candidate : info.getIdentifiers()) {
            if (!(candidate instanceof ReferenceIdentifier)) continue;
            ReferenceIdentifier identifier = (ReferenceIdentifier)candidate;
            if (authority == null) {
                return identifier;
            }
            Citation infoAuthority = identifier.getAuthority();
            if (infoAuthority == null || !Citations.identifierMatches((Citation)authority, (Citation)infoAuthority)) continue;
            return identifier;
        }
        return authority == null ? info.getName() : null;
    }

    public String getName(Citation authority) {
        return AbstractIdentifiedObject.getName0(this, authority);
    }

    public static String getName(IdentifiedObject info, Citation authority) {
        if (info instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)info).getName(authority);
        }
        return AbstractIdentifiedObject.getName0(info, authority);
    }

    private static String getName0(IdentifiedObject info, Citation authority) {
        ReferenceIdentifier identifier = info.getName();
        if (authority == null) {
            return identifier.getCode();
        }
        String name = null;
        Citation infoAuthority = identifier.getAuthority();
        if (infoAuthority != null) {
            if (Citations.identifierMatches((Citation)authority, (Citation)infoAuthority)) {
                name = identifier.getCode();
            } else {
                for (GenericName alias : info.getAlias()) {
                    if (alias instanceof Identifier) {
                        identifier = (Identifier)alias;
                        infoAuthority = identifier.getAuthority();
                        if (infoAuthority == null || !Citations.identifierMatches((Citation)authority, (Citation)infoAuthority)) continue;
                        name = identifier.getCode();
                        break;
                    }
                    GenericName scope = alias.scope().name();
                    if (scope == null || !Citations.identifierMatches((Citation)authority, (String)scope.toString())) continue;
                    name = alias.tip().toString();
                    break;
                }
            }
        }
        return name;
    }

    public boolean nameMatches(String name) {
        return AbstractIdentifiedObject.nameMatches(this, this.alias, name);
    }

    public static boolean nameMatches(IdentifiedObject object, String name) {
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).nameMatches(name);
        }
        return AbstractIdentifiedObject.nameMatches(object, object.getAlias(), name);
    }

    public static boolean nameMatches(IdentifiedObject o1, IdentifiedObject o2) {
        return AbstractIdentifiedObject.nameMatches(o1, o2.getName().getCode()) || AbstractIdentifiedObject.nameMatches(o2, o1.getName().getCode());
    }

    private static boolean nameMatches(IdentifiedObject object, Collection<GenericName> alias, String name) {
        if ((name = name.trim()).equalsIgnoreCase(object.getName().getCode().trim())) {
            return true;
        }
        if (alias != null) {
            for (GenericName asName : alias) {
                GenericName asScoped = asName.toFullyQualifiedName();
                if (asScoped != asName && name.equalsIgnoreCase(asScoped.toString().trim())) {
                    return true;
                }
                if (!name.equalsIgnoreCase(asName.tip().toString().trim())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return object instanceof AbstractIdentifiedObject && this.equals((AbstractIdentifiedObject)object, true);
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object != null && object.getClass().equals(this.getClass())) {
            if (!compareMetadata) {
                return true;
            }
            return Utilities.equals((Object)this.name, (Object)object.name) && Utilities.equals(this.alias, object.alias) && Utilities.equals(this.identifiers, object.identifiers) && Utilities.equals((Object)this.remarks, (Object)object.remarks);
        }
        return false;
    }

    static boolean equals(AbstractIdentifiedObject object1, AbstractIdentifiedObject object2, boolean compareMetadata) {
        return object1 == object2 || object1 != null && object1.equals(object2, compareMetadata);
    }

    protected static boolean equals(IdentifiedObject object1, IdentifiedObject object2, boolean compareMetadata) {
        if (!(object1 instanceof AbstractIdentifiedObject)) {
            return Utilities.equals((Object)object1, (Object)object2);
        }
        if (!(object2 instanceof AbstractIdentifiedObject)) {
            return Utilities.equals((Object)object2, (Object)object1);
        }
        return AbstractIdentifiedObject.equals((AbstractIdentifiedObject)object1, (AbstractIdentifiedObject)object2, compareMetadata);
    }

    protected static boolean equals(IdentifiedObject[] array1, IdentifiedObject[] array2, boolean compareMetadata) {
        if (array1 != array2) {
            if (array1 == null || array2 == null || array1.length != array2.length) {
                return false;
            }
            int i = array1.length;
            while (--i >= 0) {
                if (AbstractIdentifiedObject.equals(array1[i], array2[i], compareMetadata)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean equals(Collection<? extends IdentifiedObject> collection1, Collection<? extends IdentifiedObject> collection2, boolean compareMetadata) {
        if (collection1 == collection2) {
            return true;
        }
        if (collection1 == null || collection2 == null) {
            return false;
        }
        Iterator<? extends IdentifiedObject> it1 = collection1.iterator();
        Iterator<? extends IdentifiedObject> it2 = collection2.iterator();
        while (it1.hasNext()) {
            if (it2.hasNext() && AbstractIdentifiedObject.equals(it1.next(), it2.next(), compareMetadata)) continue;
            return false;
        }
        return !it2.hasNext();
    }

    private static <E extends Comparable<E>> int doCompare(E c1, E c2) {
        if (c1 == null) {
            return c2 == null ? 0 : -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    public int hashCode() {
        return 0x52B12FC0 ^ this.getClass().hashCode();
    }

    @SafeVarargs
    protected static <E> Set<E> asSet(E ... array) {
        if (array == null) {
            return null;
        }
        switch (array.length) {
            case 0: {
                return null;
            }
            case 1: {
                return Collections.singleton(array[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<E>(Arrays.asList(array)));
    }

    protected static void ensureNonNull(String name, Object object) throws InvalidParameterValueException {
        if (object == null) {
            throw new InvalidParameterValueException(Errors.format((int)143, (Object)name), name, object);
        }
    }

    protected static void ensureNonNull(String name, Object[] array, int index) throws InvalidParameterValueException {
        if (array[index] == null) {
            throw new InvalidParameterValueException(Errors.format((int)143, (Object)(name + "[" + index + "]")), name, (Object)array);
        }
    }

    protected static void ensureTimeUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.SECOND.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format((int)117, unit));
        }
    }

    protected static void ensureLinearUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.METRE.isCompatible(unit)) {
            throw new IllegalArgumentException(Errors.format((int)113, unit));
        }
    }

    protected static void ensureAngularUnit(Unit<?> unit) throws IllegalArgumentException {
        if (!SI.RADIAN.isCompatible(unit) && !AbstractUnit.ONE.equals(unit)) {
            throw new IllegalArgumentException(Errors.format((int)107, unit));
        }
    }

    private static final class RemarksComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -6675419613224162715L;

        private RemarksComparator() {
        }

        @Override
        public int compare(IdentifiedObject o1, IdentifiedObject o2) {
            return AbstractIdentifiedObject.doCompare(o1.getRemarks(), o2.getRemarks());
        }

        protected Object readResolve() throws ObjectStreamException {
            return REMARKS_COMPARATOR;
        }
    }

    private static final class IdentifierComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -7315726806679993522L;

        private IdentifierComparator() {
        }

        @Override
        @SuppressFBWarnings(value={"NS_DANGEROUS_NON_SHORT_CIRCUIT"})
        public int compare(IdentifiedObject o1, IdentifiedObject o2) {
            boolean n2;
            boolean n1;
            Set a1 = o1.getIdentifiers();
            Set a2 = o2.getIdentifiers();
            if (a1 == null) {
                a1 = Collections.emptySet();
            }
            if (a2 == null) {
                a2 = Collections.emptySet();
            }
            Iterator i1 = a1.iterator();
            Iterator i2 = a2.iterator();
            while ((n1 = i1.hasNext()) & (n2 = i2.hasNext())) {
                int c = AbstractIdentifiedObject.doCompare(((ReferenceIdentifier)i1.next()).getCode(), ((ReferenceIdentifier)i2.next()).getCode());
                if (c == 0) continue;
                return c;
            }
            if (n1) {
                return 1;
            }
            if (n2) {
                return -1;
            }
            return 0;
        }

        protected Object readResolve() throws ObjectStreamException {
            return IDENTIFIER_COMPARATOR;
        }
    }

    private static final class NameComparator
    implements Comparator<IdentifiedObject>,
    Serializable {
        private static final long serialVersionUID = -6605097017814062198L;

        private NameComparator() {
        }

        @Override
        public int compare(IdentifiedObject o1, IdentifiedObject o2) {
            return AbstractIdentifiedObject.doCompare(o1.getName().getCode(), o2.getName().getCode());
        }

        protected Object readResolve() throws ObjectStreamException {
            return NAME_COMPARATOR;
        }
    }
}

