/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpPolynomial;
import javax.media.jai.WarpQuadratic;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.WarpAdapter;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.geotools.util.Classes;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class WarpTransformTest {
    private static final int WIDTH = 1000;
    private static final int HEIGHT = 2000;

    private static WarpPolynomial executeTest(Formula formula, int degree, float EPS) throws TransformException {
        Random random = new Random(-854734760285695284L);
        Point2D[] sources = new Point[100];
        Point2D[] dest = new Point[sources.length];
        for (int i = 0; i < dest.length; ++i) {
            Point p;
            sources[i] = p = new Point(random.nextInt(1000), random.nextInt(2000));
            dest[i] = p = new Point(p);
            formula.transform(p);
        }
        Point ext = new Point(1000, 2000);
        formula.transform(ext);
        WarpTransform2D transform = new WarpTransform2D((Rectangle2D)new Rectangle(0, 0, 1000, 2000), sources, 0, (Rectangle2D)new Rectangle(0, 0, ext.x, ext.y), dest, 0, sources.length, degree);
        WarpTransform2D inverse = (WarpTransform2D)transform.inverse();
        Assert.assertNotNull((String)"WKT formatting test", (Object)transform.toString());
        Warp warp = transform.getWarp();
        Assert.assertTrue((String)("Expected a polynomial warp but got " + Classes.getShortClassName((Object)warp)), (boolean)(warp instanceof WarpPolynomial));
        WarpPolynomial poly = (WarpPolynomial)warp;
        for (int i = 0; i < sources.length; ++i) {
            String message = formula.message() + " Point #" + i;
            Point2D source = sources[i];
            Point2D expected = dest[i];
            Point2D.Double computed = new Point2D.Double(((Point)source).x, ((Point)source).y);
            Assert.assertSame((String)message, (Object)computed, (Object)transform.transform((Point2D)computed, (Point2D)computed));
            Assert.assertEquals((String)message, (double)((Point)expected).x, (double)((Point2D)computed).getX(), (double)(EPS * (float)((Point)expected).x));
            Assert.assertEquals((String)message, (double)((Point)expected).y, (double)((Point2D)computed).getY(), (double)(EPS * (float)((Point)expected).y));
            float[] farray = new float[]{((Point)source).x, ((Point)source).y};
            transform.transform(farray, 0, farray, 0, 1);
            Assert.assertEquals((String)message, (float)((Point)expected).x, (float)farray[0], (float)(EPS * (float)((Point)expected).x));
            Assert.assertEquals((String)message, (float)((Point)expected).y, (float)farray[1], (float)(EPS * (float)((Point)expected).y));
            double[] darray = new double[]{((Point)source).x, ((Point)source).y};
            transform.transform(darray, 0, darray, 0, 1);
            Assert.assertEquals((String)message, (double)((Point)expected).x, (double)darray[0], (double)(EPS * (float)((Point)expected).x));
            Assert.assertEquals((String)message, (double)((Point)expected).y, (double)darray[1], (double)(EPS * (float)((Point)expected).y));
            if (degree != 1) continue;
            ((Point2D)computed).setLocation(((Point)expected).x, ((Point)expected).y);
            Assert.assertSame((String)message, (Object)computed, (Object)inverse.transform((Point2D)computed, (Point2D)computed));
            Assert.assertEquals((String)message, (double)((Point)source).x, (double)((Point2D)computed).getX(), (double)(EPS * (float)((Point)expected).x));
            Assert.assertEquals((String)message, (double)((Point)source).y, (double)((Point2D)computed).getY(), (double)(EPS * (float)((Point)expected).y));
        }
        return poly;
    }

    @Test
    public void testAffine() throws TransformException {
        int[] scalesX = new int[]{1, 2, 3, 4, 5, 6, 2, 7, 3, 1, 8};
        int[] scalesY = new int[]{1, 2, 3, 4, 5, 6, 6, 2, 5, 9, 1};
        for (int i = 0; i < scalesX.length; ++i) {
            final int scaleX = scalesX[i];
            final int scaleY = scalesY[i];
            WarpPolynomial warp = WarpTransformTest.executeTest(new Formula(){

                @Override
                public String message() {
                    return "WarpAffine[" + scaleX + "," + scaleY + "]";
                }

                @Override
                public void transform(Point point) {
                    point.x *= scaleX;
                    point.y *= scaleY;
                }
            }, 1, 1.0E-5f);
            Assert.assertTrue((String)("Expected an affine warp but got " + Classes.getShortClassName((Object)warp)), (boolean)(warp instanceof WarpAffine));
        }
    }

    @Test
    public void testQuadratic() throws TransformException {
        int[] scalesX = new int[]{1, 2, 3, 4, 5, 6, 2, 7, 3, 1, 8};
        int[] scalesY = new int[]{1, 2, 3, 4, 5, 6, 6, 2, 5, 9, 1};
        for (int i = 0; i < scalesX.length; ++i) {
            final int scaleX = scalesX[i];
            final int scaleY = scalesY[i];
            WarpPolynomial warp = WarpTransformTest.executeTest(new Formula(){

                @Override
                public String message() {
                    return "WarpQuadratic[" + scaleX + "," + scaleY + "]";
                }

                @Override
                public void transform(Point point) {
                    point.x *= scaleX * point.x;
                    point.y *= scaleY;
                }
            }, 2, 0.01f);
            Assert.assertTrue((String)("Expected a quatratic warp but got " + Classes.getShortClassName((Object)warp)), (boolean)(warp instanceof WarpQuadratic));
        }
    }

    @Test
    public void testAdapter() {
        AffineTransform atr = AffineTransform.getScaleInstance(0.25, 0.5);
        atr.translate(4.0, 2.0);
        AffineTransform2D transform = new AffineTransform2D(atr);
        WarpAffine warp = new WarpAffine(atr);
        WarpAdapter adapter = new WarpAdapter((CharSequence)"test", (MathTransform2D)transform);
        Random random = new Random(-854734760285695284L);
        for (int i = 0; i < 200; ++i) {
            Point2D.Double source = new Point2D.Double(random.nextDouble() * 100.0, random.nextDouble() * 100.0);
            Point2D expected = warp.mapDestPoint((Point2D)source);
            Point2D computed = adapter.mapDestPoint((Point2D)source);
            Assert.assertEquals((String)"X", (double)expected.getX(), (double)computed.getX(), (double)1.0E-5);
            Assert.assertEquals((String)"Y", (double)expected.getY(), (double)computed.getY(), (double)1.0E-5);
            expected = warp.mapSourcePoint((Point2D)source);
            computed = adapter.mapSourcePoint((Point2D)source);
            Assert.assertEquals((String)"X", (double)expected.getX(), (double)computed.getX(), (double)1.0E-5);
            Assert.assertEquals((String)"Y", (double)expected.getY(), (double)computed.getY(), (double)1.0E-5);
            float[] exp = warp.warpPoint((int)((Point2D)source).getX(), (int)((Point2D)source).getY(), null);
            float[] com = adapter.warpPoint((int)((Point2D)source).getX(), (int)((Point2D)source).getY(), null);
            Assert.assertEquals((String)"X", (double)exp[0], (double)com[0], (double)1.0E-5);
            Assert.assertEquals((String)"Y", (double)exp[1], (double)com[1], (double)1.0E-5);
        }
    }

    private static interface Formula {
        public String message();

        public void transform(Point var1);
    }
}

