/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import org.geotools.referencing.operation.TransformTestBase;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public final class PassthroughTransformTest
extends TransformTestBase {
    @Test
    public void testLinear() throws FactoryException, TransformException {
        this.runTest(this.mtFactory.createAffineTransform((Matrix)new GeneralMatrix(AffineTransform.getScaleInstance(4.0, 2.0))));
    }

    @Test
    public void testPassthrough() throws FactoryException, TransformException {
        ParameterValueGroup param = this.mtFactory.getDefaultParameters("Exponential");
        this.runTest(this.mtFactory.createParameterizedTransform(param));
    }

    private void runTest(MathTransform sub) throws FactoryException, TransformException {
        this.compare(sub, sub, 0);
        try {
            this.mtFactory.createPassThroughTransform(-1, sub, 0);
            Assert.fail((String)"An illegal argument should have been detected");
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        try {
            this.mtFactory.createPassThroughTransform(0, sub, -1);
            Assert.fail((String)"An illegal argument should have been detected");
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        Assert.assertSame((String)"Failed to recognize that no passthrough transform was needed", (Object)sub, (Object)this.mtFactory.createPassThroughTransform(0, sub, 0));
        int subLower = 2;
        int subUpper = 2 + sub.getSourceDimensions();
        MathTransform passthrough = this.mtFactory.createPassThroughTransform(2, sub, 1);
        Assert.assertEquals((String)"Wrong number of source dimensions", (long)(sub.getSourceDimensions() + 2 + 1), (long)passthrough.getSourceDimensions());
        Assert.assertEquals((String)"Wrong number of target dimensions", (long)(sub.getTargetDimensions() + 2 + 1), (long)passthrough.getTargetDimensions());
        this.compare(passthrough, sub, 2);
        DimensionFilter filter = new DimensionFilter(this.mtFactory);
        filter.addSourceDimensionRange(0, 2);
        Assert.assertTrue((String)"Expected an identity transform", (boolean)filter.separate(passthrough).isIdentity());
        filter.clear();
        filter.addSourceDimensionRange(subUpper, passthrough.getSourceDimensions());
        Assert.assertTrue((String)"Expected an identity transform", (boolean)filter.separate(passthrough).isIdentity());
        filter.clear();
        filter.addSourceDimensionRange(2, subUpper);
        Assert.assertEquals((String)"Expected the sub-transform", (Object)sub, (Object)filter.separate(passthrough));
        int[] expectedDimensions = new int[sub.getTargetDimensions()];
        for (int i = 0; i < expectedDimensions.length; ++i) {
            expectedDimensions[i] = 2 + i;
        }
        Assert.assertArrayEquals((String)"Unexpected output dimensions", (int[])expectedDimensions, (int[])filter.getTargetDimensions());
    }

    private void compare(MathTransform mt, MathTransform submt, int subOffset) throws TransformException {
        int pointCount = 200;
        int mtDimension = mt.getSourceDimensions();
        int atDimension = submt.getSourceDimensions();
        double[] atData = new double[200 * atDimension];
        double[] mtData = new double[200 * mtDimension];
        for (int j = 0; j < 200; ++j) {
            int i;
            for (i = 0; i < mtDimension; ++i) {
                mtData[j * mtDimension + i] = 100.0 * random.nextDouble() - 50.0;
            }
            for (i = 0; i < atDimension; ++i) {
                atData[j * atDimension + i] = mtData[j * mtDimension + subOffset + i];
            }
        }
        if (atDimension == mtDimension) {
            Assert.assertArrayEquals((String)"Test arrays are not correctly build.", (double[])atData, (double[])mtData, (double)0.0);
        }
        double[] reference = (double[])mtData.clone();
        submt.transform(atData, 0, atData, 0, 200);
        mt.transform(mtData, 0, mtData, 0, 200);
        Assert.assertTrue((String)"'subOffset' argument too high", (subOffset + atDimension <= mtDimension ? 1 : 0) != 0);
        for (int j = 0; j < 200; ++j) {
            for (int i = 0; i < mtDimension; ++i) {
                double expected = i < subOffset || i >= subOffset + atDimension ? reference[j * mtDimension + i] : atData[j * atDimension + i - subOffset];
                Assert.assertEquals((String)"A transformed value is wrong", (double)expected, (double)mtData[j * mtDimension + i], (double)1.0E-6);
            }
        }
    }
}

