/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.referencing.operation.projection.Mollweide;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class MollweideProviderTest {
    private String SEMI_MAJOR = Mollweide.MollweideProvider.SEMI_MAJOR.getName().getCode();
    private String SEMI_MINOR = Mollweide.MollweideProvider.SEMI_MINOR.getName().getCode();
    private String FALSE_NORTHING = Mollweide.MollweideProvider.FALSE_NORTHING.getName().getCode();
    private String FALSE_EASTING = Mollweide.MollweideProvider.FALSE_EASTING.getName().getCode();
    private String CENTRAL_MERIDIAN = Mollweide.MollweideProvider.CENTRAL_MERIDIAN.getName().getCode();

    @Test
    public void testParameters() throws Exception {
        ParameterDescriptorGroup parameters = Mollweide.MollweideProvider.PARAMETERS;
        Assert.assertNotNull((Object)parameters.descriptor(this.SEMI_MAJOR));
        Assert.assertNotNull((Object)parameters.descriptor(this.SEMI_MINOR));
        Assert.assertNotNull((Object)parameters.descriptor(this.FALSE_NORTHING));
        Assert.assertNotNull((Object)parameters.descriptor(this.FALSE_EASTING));
        Assert.assertNotNull((Object)parameters.descriptor(this.CENTRAL_MERIDIAN));
    }

    @Test
    public void testMathTransformUsesSphericalParameter() throws Exception {
        Mollweide.MollweideProvider mollweideProvider = new Mollweide.MollweideProvider();
        ParameterValueGroup parameters = Mollweide.MollweideProvider.PARAMETERS.createValue();
        parameters.parameter(this.SEMI_MAJOR).setValue(6000);
        parameters.parameter(this.SEMI_MINOR).setValue(100);
        MathTransform mathTransform = mollweideProvider.createMathTransform(parameters);
        String wkt = mathTransform.toWKT();
        Assert.assertTrue((boolean)wkt.contains("\"semi_major\", 6000.0"));
        Assert.assertTrue((String)"Mollweide is only spherically defined. Axis must be equal", (boolean)wkt.contains("\"semi_minor\", 6000.0"));
    }
}

