/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeostationarySatelliteTest {
    public static final String sphericalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"Custom Geographic CS\",    DATUM[\"Custom Datum\",      SPHEROID[\"Sphere\",6367451.5, 0]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35832548.5],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    UNIT[\"meter\", 1]]";
    public static final String ellipsoidalGeosWKT = "PROJCS[\"Geostationary_Satellite\",  GEOGCS[\"WGS 84\",    DATUM[\"WGS_1984\",      SPHEROID[\"WGS84\",6378137,298.257223563]],    PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.01745329251994328]],    PROJECTION[\"Geostationary_Satellite\"],    PARAMETER[\"central_meridian\", -135],    PARAMETER[\"satellite_height\",35785831.0],    PARAMETER[\"false_easting\",0],    PARAMETER[\"false_northing\",0],    PARAMETER[\"sweep\",0],    UNIT[\"meter\", 1]]";
    static CoordinateReferenceSystem sphericalGeosCRS;
    static MathTransform sphericalGeosToGeog;
    static MathTransform geogToSphericalGeos;
    static CoordinateReferenceSystem ellipsoidalGeosCRS;
    static MathTransform ellipsoidalGeosToGeog;
    static MathTransform geogToEllipsoidalGeos;

    @BeforeClass
    public static void setupClass() throws FactoryException, TransformException {
        sphericalGeosCRS = CRS.parseWKT((String)sphericalGeosWKT);
        sphericalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)sphericalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)sphericalGeosCRS).getBaseCRS(), (boolean)true);
        geogToSphericalGeos = sphericalGeosToGeog.inverse();
        ellipsoidalGeosCRS = CRS.parseWKT((String)ellipsoidalGeosWKT);
        ellipsoidalGeosToGeog = CRS.findMathTransform((CoordinateReferenceSystem)ellipsoidalGeosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS).getBaseCRS(), (boolean)true);
        geogToEllipsoidalGeos = ellipsoidalGeosToGeog.inverse();
    }

    @Test
    public void testSpheroidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)sphericalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.58325485E7));
        double sweep = parameters.parameter("sweep").doubleValue();
        MatcherAssert.assertThat((Object)sweep, (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testEllipsoidalWKTParameters() {
        ParameterValueGroup parameters = CRS.getMapProjection((CoordinateReferenceSystem)ellipsoidalGeosCRS).getParameterValues();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        MatcherAssert.assertThat((Object)satelliteHeight, (Matcher)CoreMatchers.is((Object)3.5785831E7));
        double sweep = parameters.parameter("sweep").doubleValue();
        MatcherAssert.assertThat((Object)sweep, (Matcher)CoreMatchers.is((Object)0.0));
    }

    @Test
    public void testEllipsoidProjection() throws Exception {
        double[] wgs84 = new double[]{-71.391245, 41.766279, -80.452193, -5.547325, -53.700994, 0.0, -135.0, 64.143628};
        double[] geos = new double[]{3778584.7403456536, 3762727.556421232, 4779926.185724244, -569498.6040787804, 5434177.815700539, 0.0, 0.0, 5159593.473948262};
        double[] actual = new double[wgs84.length];
        geogToEllipsoidalGeos.transform(wgs84, 0, actual, 0, wgs84.length / 2);
        Assert.assertArrayEquals((String)"Forward transform failed accuracy test", (double[])geos, (double[])actual, (double)1.0);
        double[] actualWgs = new double[wgs84.length];
        ellipsoidalGeosToGeog.transform(geos, 0, actualWgs, 0, geos.length / 2);
        Assert.assertArrayEquals((String)"Inverse transform failed accuracy test (check your latitude math!)", (double[])wgs84, (double[])actualWgs, (double)1.0E-6);
    }

    @Test
    public void testIsGeostationaryCRS() {
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)sphericalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)ellipsoidalGeosCRS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)GeostationarySatellite.isGeostationaryCRS(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCircumscribeFullDisk_Spheroidal() throws TransformException, FactoryException {
        Envelope2D circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaxX(), circumscribed.getCenterY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinX(), circumscribed.getCenterY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY() + 1.0);
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY() - 1.0);
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX() - 1.0, circumscribed.getCenterY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX() + 1.0, circumscribed.getCenterY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMaxY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMinY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMaxY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMinY());
            sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
    }

    @Test
    public void testCircumscribeFullDisk_Ellipsoidal() throws TransformException, FactoryException {
        Envelope2D circumscribed = GeostationarySatellite.circumscribeFullDisk((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)circumscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMaxX(), circumscribed.getCenterY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(circumscribed.getMinX(), circumscribed.getCenterY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        double tickle = 1.0;
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMaxY() + 1.0);
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getCenterX(), circumscribed.getMinY() - 1.0);
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX() - 1.0, circumscribed.getCenterY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX() + 1.0, circumscribed.getCenterY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMaxY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMaxX(), circumscribed.getMinY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMaxY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
        this.expectProjectionException(() -> {
            p.setLocation(circumscribed.getMinX(), circumscribed.getMinY());
            ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        });
    }

    @Test
    public void testInscribeFullDiskEstimate_Spheroidal() throws TransformException, FactoryException {
        Envelope2D inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)sphericalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(inscribed.getMaxX(), inscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaxX(), inscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMaxY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMinY());
        sphericalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToSphericalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testInscribeFullDiskEstimate_Ellipsoidal() throws TransformException, FactoryException {
        Envelope2D inscribed = GeostationarySatellite.inscribeFullDiskEstimate((CoordinateReferenceSystem)ellipsoidalGeosCRS);
        MatcherAssert.assertThat((Object)inscribed, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        DirectPosition2D p = new DirectPosition2D();
        p.setLocation(inscribed.getMaxX(), inscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMaxX(), inscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMaxY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        p.setLocation(inscribed.getMinX(), inscribed.getMinY());
        ellipsoidalGeosToGeog.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        geogToEllipsoidalGeos.transform((DirectPosition)p, (DirectPosition)p);
        MatcherAssert.assertThat((Object)p, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test(expected=ProjectionException.class)
    public void testOffDiskVisibility() throws Exception {
        double[] offDisk = new double[]{5500000.0, 0.0};
        double[] result = new double[2];
        ellipsoidalGeosToGeog.transform(offDisk, 0, result, 0, 1);
    }

    @Test(expected=ProjectionException.class)
    public void testHorizonPrecisionFailure() throws Exception {
        double xPastHorizon = 5434178.0;
        double y = 0.0;
        double[] result = new double[2];
        ellipsoidalGeosToGeog.transform(new double[]{xPastHorizon, y}, 0, result, 0, 1);
    }

    private void expectProjectionException(Testable testable) {
        this.expectException(ProjectionException.class, testable);
    }

    private <T extends Exception> void expectException(Class<T> clazz, Testable testable) {
        block2: {
            try {
                testable.test();
                Assert.fail((String)String.format("Expected exception, %s, but not thrown", clazz));
            }
            catch (Exception e) {
                if (clazz.isInstance(e)) break block2;
                Assert.fail((String)String.format("Expected exception of %s but got %s", clazz, e.getClass()));
            }
        }
    }

    public static interface Testable {
        public void test() throws Exception;
    }
}

