/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.referencing.wkt.Symbols;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EsriNamedIdentifierAliasesTest {
    protected void checkCitation(String sourceWkt, String esriProj, String epsgProj) throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)sourceWkt);
        Formatter esriFormatter = new Formatter(Symbols.DEFAULT, 0);
        esriFormatter.setAuthority(Citations.ESRI);
        esriFormatter.append((IdentifiedObject)crs);
        String wkt = esriFormatter.toString();
        Assert.assertTrue((boolean)wkt.contains(esriProj));
        Formatter epsgFormatter = new Formatter(Symbols.DEFAULT, 0);
        epsgFormatter.setAuthority(Citations.EPSG);
        epsgFormatter.append((IdentifiedObject)crs);
        wkt = epsgFormatter.toString();
        Assert.assertTrue((boolean)wkt.contains(epsgProj));
    }

    @Test
    public void cassiniSoldnerCitation() throws Exception {
        String cassiniSoldnerWkt = "PROJCS[\"Kertau_1968_Kelantan_Grid\",GEOGCS[\"GCS_Kertau\",DATUM[\"D_Kertau\",SPHEROID[\"Everest_1830_Modified\",6377304.063,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.1772916666667],PARAMETER[\"Latitude_Of_Origin\",5.893922222222224],UNIT[\"Meter\",1.0]]";
        this.checkCitation(cassiniSoldnerWkt, "PROJECTION[\"Cassini\"]", "PROJECTION[\"Cassini-Soldner\"]");
    }

    @Test
    public void equidistantCylindricalCitation() throws Exception {
        String equidistantCylindricalWkt = "PROJCS[\"WGS_1984_World_Equidistant_Cylindrical\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Equidistant_Cylindrical_Ellipsoidal\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0]]";
        this.checkCitation(equidistantCylindricalWkt, "PROJECTION[\"Equidistant_Cylindrical_Ellipsoidal\"]", "PROJECTION[\"Equidistant Cylindrical\"]");
    }

    @Test
    public void equidistantCylindricalSphericalCitation() throws Exception {
        String equidistantCylindricalSphericalWkt = "PROJCS[\"World_Equidistant_Cylindrical_(Sphere)\",GEOGCS[\"GCS_Sphere_GRS_1980_Authalic\",DATUM[\"D_Sphere_GRS_1980_Authalic\",SPHEROID[\"Sphere_GRS_1980_Authalic\",6371007.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Equidistant_Cylindrical\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0]]";
        this.checkCitation(equidistantCylindricalSphericalWkt, "PROJECTION[\"Equidistant_Cylindrical", "PROJECTION[\"Equidistant Cylindrical");
    }
}

