/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import java.util.Random;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.operation.builder.ExtendedPosition;
import org.geotools.referencing.operation.builder.Quadrilateral;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.builder.TriangulationException;
import org.geotools.referencing.operation.builder.TriangulationFactory;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;

public final class TriangulationFactoryTest {
    @Test
    public void testTringulationFactory() {
        DirectPosition2D sp1 = new DirectPosition2D(10.0, 10.0);
        DirectPosition2D tp1 = new DirectPosition2D(10.0, 10.0);
        DirectPosition2D sp2 = new DirectPosition2D(20.0, 10.0);
        DirectPosition2D tp2 = new DirectPosition2D(20.0, 10.0);
        DirectPosition2D sp3 = new DirectPosition2D(20.0, 20.0);
        DirectPosition2D tp3 = new DirectPosition2D(20.0, 20.0);
        DirectPosition2D sp4 = new DirectPosition2D(10.0, 20.0);
        DirectPosition2D tp4 = new DirectPosition2D(10.0, 20.0);
        DirectPosition2D sp5 = new DirectPosition2D(14.0, 16.0);
        DirectPosition2D tp5 = new DirectPosition2D(14.0, 16.0);
        ExtendedPosition mtp1 = new ExtendedPosition((DirectPosition)sp1, (DirectPosition)tp1);
        ExtendedPosition mtp2 = new ExtendedPosition((DirectPosition)sp2, (DirectPosition)tp2);
        ExtendedPosition mtp3 = new ExtendedPosition((DirectPosition)sp3, (DirectPosition)tp3);
        ExtendedPosition mtp4 = new ExtendedPosition((DirectPosition)sp4, (DirectPosition)tp4);
        ExtendedPosition mtp5 = new ExtendedPosition((DirectPosition)sp5, (DirectPosition)tp5);
        DirectPosition[] vertices = new DirectPosition[]{mtp5};
        Quadrilateral quad = new Quadrilateral((DirectPosition)mtp1, (DirectPosition)mtp2, (DirectPosition)mtp3, (DirectPosition)mtp4);
        try {
            new TriangulationFactory(quad, vertices);
        }
        catch (TriangulationException triangulationException) {
            // empty catch block
        }
    }

    @Test
    public void testDelaunay() throws TriangulationException {
        DirectPosition2D leftDown = new DirectPosition2D(100.0, 100.0);
        DirectPosition2D rightDown = new DirectPosition2D(200.0, 100.0);
        DirectPosition2D rightTop = new DirectPosition2D(200.0, 250.0);
        DirectPosition2D leftTop = new DirectPosition2D(100.0, 250.0);
        Random randomCoord = new Random(872066443L);
        int number = 5;
        DirectPosition[] vertices = new DirectPosition[number];
        for (int i = 0; i < number; ++i) {
            double x = leftDown.x + randomCoord.nextDouble() * (rightDown.x - leftDown.x);
            double y = leftDown.y + randomCoord.nextDouble() * (leftTop.y - leftDown.y);
            vertices[i] = new DirectPosition2D(x, y);
        }
        Quadrilateral quad = new Quadrilateral((DirectPosition)leftDown, (DirectPosition)rightDown, (DirectPosition)rightTop, (DirectPosition)leftTop);
        TriangulationFactory trigfac = new TriangulationFactory(quad, vertices);
        List triangles = trigfac.getTriangulation();
        int j = 1;
        for (TINTriangle triangle : triangles) {
            for (j = 0; j < vertices.length; ++j) {
                Assert.assertFalse((boolean)triangle.getCircumCicle().contains(vertices[j]));
            }
        }
    }
}

