/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Random;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public abstract class TransformTestBase {
    private static final double EPS = 1.0E-6;
    protected DatumFactory datumFactory;
    protected CRSFactory crsFactory;
    protected MathTransformFactory mtFactory;
    protected CoordinateOperationFactory opFactory;
    protected static final Random random = new Random(-3531834320875149028L);

    @Before
    public final void setUpFactories() {
        Hints hints = this.getHintsForTesting();
        this.datumFactory = ReferencingFactoryFinder.getDatumFactory((Hints)hints);
        this.crsFactory = ReferencingFactoryFinder.getCRSFactory((Hints)hints);
        this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory((Hints)hints);
        this.opFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
    }

    protected Hints getHintsForTesting() {
        return null;
    }

    public static boolean isReal(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static void assertInterfaced(MathTransform transform) {
        int dim = transform.getSourceDimensions();
        if (transform.getTargetDimensions() != dim) {
            dim = 0;
        }
        Assert.assertEquals((String)"MathTransform1D", (Object)(dim == 1 ? 1 : 0), (Object)(transform instanceof MathTransform1D));
        Assert.assertEquals((String)"MathTransform2D", (Object)(dim == 2 ? 1 : 0), (Object)(transform instanceof MathTransform2D));
    }

    public static void assertTransformEquals2_2(MathTransform transform, double x, double y, double ex, double ey) throws TransformException {
        DirectPosition2D source = new DirectPosition2D(x, y);
        DirectPosition2D target = new DirectPosition2D();
        Assert.assertSame((Object)target, (Object)transform.transform((DirectPosition)source, (DirectPosition)target));
        String message = "Expected (" + ex + ", " + ey + "), transformed=(" + target.x + ", " + target.y + ")";
        Assert.assertEquals((String)message, (double)ex, (double)target.x, (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ey, (double)target.y, (double)1.0E-6);
    }

    public static void assertTransformEquals3_3(MathTransform transform, double x, double y, double z, double ex, double ey, double ez) throws TransformException {
        GeneralDirectPosition source = new GeneralDirectPosition(x, y, z);
        GeneralDirectPosition target = new GeneralDirectPosition(3);
        Assert.assertSame((Object)target, (Object)transform.transform((DirectPosition)source, (DirectPosition)target));
        String message = "Expected (" + ex + ", " + ey + ", " + ez + "), transformed=(" + target.ordinates[0] + ", " + target.ordinates[1] + ", " + target.ordinates[2] + ")";
        Assert.assertEquals((String)message, (double)ex, (double)target.ordinates[0], (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ey, (double)target.ordinates[1], (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ez, (double)target.ordinates[2], (double)0.01);
    }

    public static void assertTransformEquals2_3(MathTransform transform, double x, double y, double ex, double ey, double ez) throws TransformException {
        GeneralDirectPosition source = new GeneralDirectPosition(x, y);
        GeneralDirectPosition target = new GeneralDirectPosition(3);
        Assert.assertSame((Object)target, (Object)transform.transform((DirectPosition)source, (DirectPosition)target));
        String message = "Expected (" + ex + ", " + ey + ", " + ez + "), transformed=(" + target.ordinates[0] + ", " + target.ordinates[1] + ", " + target.ordinates[2] + ")";
        Assert.assertEquals((String)message, (double)ex, (double)target.ordinates[0], (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ey, (double)target.ordinates[1], (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ez, (double)target.ordinates[2], (double)0.01);
    }

    public static void assertTransformEquals3_2(MathTransform transform, double x, double y, double z, double ex, double ey) throws TransformException {
        GeneralDirectPosition source = new GeneralDirectPosition(x, y, z);
        GeneralDirectPosition target = new GeneralDirectPosition(2);
        Assert.assertSame((Object)target, (Object)transform.transform((DirectPosition)source, (DirectPosition)target));
        String message = "Expected (" + ex + ", " + ey + "), transformed=(" + target.ordinates[0] + ", " + target.ordinates[1] + ")";
        Assert.assertEquals((String)message, (double)ex, (double)target.ordinates[0], (double)1.0E-6);
        Assert.assertEquals((String)message, (double)ey, (double)target.ordinates[1], (double)1.0E-6);
    }

    public static void assertTransformEquals3_1(MathTransform transform, double x, double y, double z, double ez) throws TransformException {
        GeneralDirectPosition source = new GeneralDirectPosition(x, y, z);
        GeneralDirectPosition target = new GeneralDirectPosition(1);
        Assert.assertSame((Object)target, (Object)transform.transform((DirectPosition)source, (DirectPosition)target));
        String message = "Expected (" + ez + "), transformed=(" + target.ordinates[0] + ")";
        Assert.assertEquals((String)message, (double)ez, (double)target.ordinates[0], (double)0.01);
    }

    public static void assertPointsEqual(String name, double[] expected, double[] actual, double[] delta) {
        int dimension = delta.length;
        int stop = Math.min(expected.length, actual.length) / dimension * dimension;
        Assert.assertEquals((String)"Array length for expected points", (long)stop, (long)expected.length);
        Assert.assertEquals((String)"Array length for actual points", (long)stop, (long)actual.length);
        StringBuilder buffer = new StringBuilder(name);
        buffer.append(": point[");
        int start = buffer.length();
        for (int i = 0; i < stop; ++i) {
            buffer.setLength(start);
            buffer.append(i / dimension).append(", dimension ").append(i % dimension).append(" of ").append(dimension).append(']');
            if (!TransformTestBase.isReal(expected[i])) continue;
            Assert.assertEquals((String)buffer.toString(), (double)expected[i], (double)actual[i], (double)delta[i % dimension]);
        }
    }

    @Test
    public void testAssertPointsEqual() {
        String name = "self test";
        double[] a = new double[]{10.0, 10.0};
        double[] b = new double[]{10.1, 10.1};
        double[] delta = new double[]{0.2, 0.2};
        TransformTestBase.assertPointsEqual(name, a, b, delta);
    }
}

