/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.gridshift;

import au.com.objectix.jgridshift.GridShiftFile;
import java.net.URL;
import org.geotools.referencing.factory.gridshift.NTv2GridShiftFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.FactoryException;

public class NTv2GridShiftFactoryTest {
    private static final URL TEST_GRID = NTv2GridShiftFactoryTest.class.getResource("BALR2009.gsb");
    private static final URL INEXISTENT_GRID = NTv2GridShiftFactoryTest.class.getResource("this_NTv2_grid_does_not_exist");
    private static final URL MALFORMED_GRID = NTv2GridShiftFactoryTest.class.getResource("malformedNTv2grid.gsb");
    private NTv2GridShiftFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new NTv2GridShiftFactory();
    }

    @Test
    public void testIsNTv2GridAvailable() {
        Assert.assertFalse((boolean)this.factory.isNTv2Grid(null));
        Assert.assertFalse((boolean)this.factory.isNTv2Grid(INEXISTENT_GRID));
        Assert.assertFalse((boolean)this.factory.isNTv2Grid(MALFORMED_GRID));
        Assert.assertTrue((boolean)this.factory.isNTv2Grid(TEST_GRID));
    }

    @Test
    public void testCreateNTv2Grid() {
        boolean factoryExceptionThrown = false;
        try {
            this.factory.createNTv2Grid(null);
        }
        catch (FactoryException e) {
            factoryExceptionThrown = true;
        }
        Assert.assertTrue((boolean)factoryExceptionThrown);
        factoryExceptionThrown = false;
        try {
            this.factory.createNTv2Grid(INEXISTENT_GRID);
        }
        catch (FactoryException e) {
            factoryExceptionThrown = true;
        }
        Assert.assertTrue((boolean)factoryExceptionThrown);
        factoryExceptionThrown = false;
        try {
            this.factory.createNTv2Grid(MALFORMED_GRID);
        }
        catch (FactoryException e) {
            factoryExceptionThrown = true;
        }
        Assert.assertTrue((boolean)factoryExceptionThrown);
        factoryExceptionThrown = false;
        GridShiftFile grid = null;
        try {
            grid = this.factory.createNTv2Grid(TEST_GRID);
        }
        catch (FactoryException e) {
            factoryExceptionThrown = true;
        }
        Assert.assertFalse((boolean)factoryExceptionThrown);
        Assert.assertNotNull((Object)grid);
        Assert.assertTrue((boolean)grid.isLoaded());
    }
}

