/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.geom.Rectangle2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.EnvelopeReprojector;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class EnvelopeReprojectorTest {
    public static final double EPS = 0.01;

    @Test
    public void testEnvelopeTransformation() throws FactoryException, TransformException {
        CoordinateReferenceSystem mapCRS = CRS.parseWKT((String)"PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\", 6378137, 298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\", 0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n  PARAMETER[\"False_Easting\",500000],\n  PARAMETER[\"False_Northing\",0],\n  PARAMETER[\"Central_Meridian\",-123],\n  PARAMETER[\"Scale_Factor\",0.9996],\n  PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]");
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation((CoordinateReferenceSystem)WGS84, mapCRS);
        Assert.assertFalse((boolean)operation.getMathTransform().isIdentity());
        GeneralEnvelope firstEnvelope = new GeneralEnvelope(new double[]{-124.0, 42.0}, new double[]{-122.0, 43.0});
        firstEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)WGS84);
        GeneralEnvelope transformedEnvelope = EnvelopeReprojector.transform((CoordinateOperation)operation, (Envelope)firstEnvelope);
        transformedEnvelope.setCoordinateReferenceSystem(mapCRS);
        CoordinateOperation inverse = CRS.getCoordinateOperationFactory((boolean)true).createOperation(mapCRS, (CoordinateReferenceSystem)WGS84);
        GeneralEnvelope oldEnvelope = EnvelopeReprojector.transform((CoordinateOperation)inverse, (Envelope)transformedEnvelope);
        oldEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)WGS84);
        Assert.assertTrue((boolean)oldEnvelope.contains((Envelope)firstEnvelope, true));
        Assert.assertTrue((boolean)oldEnvelope.equals((Envelope)firstEnvelope, 0.02, true));
    }

    @Test
    public void testEnvelopeTransformation2() throws FactoryException, TransformException {
        CoordinateReferenceSystem WGS84Altered = CRS.parseWKT((String)"GEOGCS[\"WGS84\",\n  DATUM[\"WGS84_altered\",\n    SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],\n  PRIMEM[\"Greenwich\", 0.0],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Longitude\",EAST],  AXIS[\"Latitude\",NORTH]]");
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        MathTransform crsTransform = CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)WGS84Altered, (boolean)true);
        Assert.assertTrue((boolean)crsTransform.isIdentity());
        GeneralEnvelope firstEnvelope = new GeneralEnvelope(new double[]{-124.0, 42.0}, new double[]{-122.0, 43.0});
        firstEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)WGS84);
        GeneralEnvelope transformed = CRS.transform((Envelope)firstEnvelope, (CoordinateReferenceSystem)WGS84Altered);
        Assert.assertEquals((Object)transformed.getCoordinateReferenceSystem(), (Object)WGS84Altered);
        double EPS = 1.0E-9;
        Assert.assertEquals((double)transformed.getMinimum(0), (double)firstEnvelope.getMinimum(0), (double)EPS);
        Assert.assertEquals((double)transformed.getMinimum(1), (double)firstEnvelope.getMinimum(1), (double)EPS);
        Assert.assertEquals((double)transformed.getMaximum(0), (double)firstEnvelope.getMaximum(0), (double)EPS);
        Assert.assertEquals((double)transformed.getMaximum(1), (double)firstEnvelope.getMaximum(1), (double)EPS);
    }

    @Test
    @Ignore
    public void testEnvelopeTransformClipping() throws Exception {
        DefaultGeographicCRS source = DefaultGeographicCRS.WGS84;
        CoordinateReferenceSystem target = CRS.parseWKT((String)"GEOGCS[\"GCS_North_American_1983\",DATUM[\"North_American_Datum_1983\", SPHEROID[\"GRS_1980\", 6378137.0, 298.257222101]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Longitude\", EAST], AXIS[\"Latitude\", NORTH]]");
        GeneralEnvelope geotiff = new GeneralEnvelope((CoordinateReferenceSystem)source);
        geotiff.add((DirectPosition)new DirectPosition2D((CoordinateReferenceSystem)source, -179.9, -90.0));
        geotiff.add((DirectPosition)new DirectPosition2D((CoordinateReferenceSystem)source, 180.0, 89.9));
        GeneralEnvelope transformed = CRS.transform((Envelope)geotiff, (CoordinateReferenceSystem)target);
        Assert.assertNotNull((Object)transformed);
        Assert.assertTrue((String)"clipped y", (transformed.getUpperCorner().getOrdinate(1) > 88.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"clipped y", (transformed.getLowerCorner().getOrdinate(1) < -88.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"clipped x", (transformed.getUpperCorner().getOrdinate(0) > 170.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"clipped x", (transformed.getLowerCorner().getOrdinate(0) < -170.0 ? 1 : 0) != 0);
    }

    @Test
    public void testTransformationOverPole() throws FactoryException, TransformException {
        CoordinateReferenceSystem mapCRS = CRS.parseWKT((String)"PROJCS[\"WGS 84 / Antarctic Polar Stereographic\",\n  GEOGCS[\"WGS 84\",\n    DATUM[\"World Geodetic System 1984\",\n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295]],\n  PROJECTION[\"Polar Stereographic (variant B)\"],\n  PARAMETER[\"standard_parallel_1\", -71.0],\n  UNIT[\"m\", 1.0]]");
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)false).createOperation(mapCRS, (CoordinateReferenceSystem)WGS84);
        MathTransform transform = operation.getMathTransform();
        Assert.assertTrue((boolean)(transform instanceof MathTransform2D));
        XRectangle2D envelope = XRectangle2D.createFromExtremums((double)-3943612.4042124213, (double)-4078471.954436003, (double)3729092.5890516187, (double)4033483.085688618);
        XRectangle2D expected = XRectangle2D.createFromExtremums((double)-178.49352310409273, (double)-88.99136583196398, (double)137.56220967463082, (double)-40.905775004205864);
        Rectangle2D actual = CRS.transform((MathTransform2D)((MathTransform2D)transform), (Rectangle2D)envelope, null);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
        expected = XRectangle2D.createFromExtremums((double)-180.0, (double)-90.0, (double)180.0, (double)-40.905775004205864);
        actual = CRS.transform((CoordinateOperation)operation, (Rectangle2D)envelope, (Rectangle2D)actual);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
        envelope = XRectangle2D.createFromExtremums((double)-4000000.0, (double)-4000000.0, (double)300000.0, (double)30000.0);
        expected = XRectangle2D.createFromExtremums((double)-180.0, (double)-90.0, (double)180.0, (double)-41.03163170198091);
        actual = CRS.transform((CoordinateOperation)operation, (Rectangle2D)envelope, (Rectangle2D)actual);
        Assert.assertTrue((boolean)XRectangle2D.equalsEpsilon((Rectangle2D)expected, (Rectangle2D)actual));
    }

    @Test
    public void testReprojectEnvelope() throws Exception {
        String wkt = "GEOGCS[\"WGS84(DD)\",DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],PRIMEM[\"Greenwich\", 0.0],UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],AXIS[\"Geodetic latitude\", NORTH]]";
        CoordinateReferenceSystem wgs84 = CRS.parseWKT((String)wkt);
        wkt = "PROJCS[\"WGS 84 / UTM zone 32N\", \n  GEOGCS[\"WGS 84\", \n    DATUM[\"World Geodetic System 1984\", \n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]], \n      AUTHORITY[\"EPSG\",\"6326\"]], \n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], \n    UNIT[\"degree\", 0.017453292519943295], \n    AXIS[\"Geodetic longitude\", EAST], \n    AXIS[\"Geodetic latitude\", NORTH], \n    AUTHORITY[\"EPSG\",\"4326\"]], \n  PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]], \n  PARAMETER[\"central_meridian\", 9.0], \n  PARAMETER[\"latitude_of_origin\", 0.0], \n  PARAMETER[\"scale_factor\", 0.9996], \n  PARAMETER[\"false_easting\", 500000.0], \n  PARAMETER[\"false_northing\", 0.0], \n  UNIT[\"m\", 1.0], \n  AXIS[\"Easting\", EAST], \n  AXIS[\"Northing\", NORTH], \n  AUTHORITY[\"EPSG\",\"32632\"]]";
        CoordinateReferenceSystem utm32n = CRS.parseWKT((String)wkt);
        GeneralEnvelope envelope = new GeneralEnvelope(utm32n);
        envelope.setEnvelope(new double[]{895817.968, 4439270.71, 1081186.865, 4617454.766});
        GeneralEnvelope transformed = CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)wgs84);
        Assert.assertEquals((double)13.63, (double)transformed.getMinimum(0), (double)0.01);
        Assert.assertEquals((double)39.9, (double)transformed.getMinimum(1), (double)0.01);
        Assert.assertEquals((double)15.96, (double)transformed.getMaximum(0), (double)0.01);
        Assert.assertEquals((double)41.61, (double)transformed.getMaximum(1), (double)0.01);
    }

    @Test
    public void testOrthographic() throws Exception {
        CoordinateReferenceSystem orthographic = CRS.decode((String)"AUTO:42003,9001,0,0");
        GeneralEnvelope bounds = new GeneralEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        bounds.setEnvelope(new double[]{-90.0, -30.0, 90.0, 90.0});
        EnvelopeReprojectorTest.testOrthographicDisc(orthographic, bounds);
    }

    private static void testOrthographicDisc(CoordinateReferenceSystem orthographic, GeneralEnvelope bounds) throws FactoryException, TransformException {
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, orthographic);
        GeneralEnvelope result = EnvelopeReprojector.transform((CoordinateOperation)operation, (Envelope)bounds);
        double radius = 6378137.0;
        Assert.assertEquals((double)(-radius), (double)result.getMinimum(0), (double)0.01);
        Assert.assertEquals((double)radius, (double)result.getMaximum(0), (double)0.01);
    }

    @Test
    public void testGeostationaryCentered() throws Exception {
        CoordinateReferenceSystem geos = CRS.decode((String)"AUTO:97004,9001,0,0");
        CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, geos);
        GeneralEnvelope bounds = new GeneralEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        bounds.setEnvelope(new double[]{-79.0, -79.0, 79.0, 79.0});
        GeneralEnvelope result = EnvelopeReprojector.transform((CoordinateOperation)operation, (Envelope)bounds);
        Assert.assertEquals((double)-5429740.0, (double)result.getMinimum(0), (double)1.0);
        Assert.assertEquals((double)5429740.0, (double)result.getMaximum(0), (double)1.0);
        Assert.assertEquals((double)-5411672.0, (double)result.getMinimum(1), (double)1.0);
        Assert.assertEquals((double)5411672.0, (double)result.getMaximum(1), (double)1.0);
    }
}

