/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class GeneralEnvelopeTest {
    @Test
    public void testConstruction() {
        GeneralEnvelope empty = new GeneralEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertTrue((boolean)empty.isEmpty());
        Envelope2D empty2d = new Envelope2D();
        Assert.assertTrue((boolean)empty2d.isEmpty());
        GeneralEnvelope world = new GeneralEnvelope(new double[]{-180.0, -90.0}, new double[]{180.0, 90.0});
        world.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeneralEnvelope copyWorld = new GeneralEnvelope((Envelope)world);
        Assert.assertEquals((Object)world, (Object)copyWorld);
        GeneralEnvelope copyEmpty = new GeneralEnvelope((Envelope)empty);
        Assert.assertEquals((Object)empty, (Object)copyEmpty);
        GeneralEnvelope nil = new GeneralEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        nil.setToNull();
        Assert.assertTrue((boolean)nil.isNull());
        GeneralEnvelope copyNil = new GeneralEnvelope((Envelope)nil);
        Assert.assertTrue((boolean)copyNil.isNull());
        Assert.assertEquals((Object)nil, (Object)copyNil);
        Envelope2D nil2 = new Envelope2D((Envelope)nil);
        GeneralEnvelope copyNil2 = new GeneralEnvelope((Envelope)nil2);
        Assert.assertTrue((boolean)copyNil2.isNull());
        GeneralEnvelope geot3045 = new GeneralEnvelope(new double[]{0.0, 0.0}, new double[]{-1.0, -1.0});
        Assert.assertTrue((boolean)geot3045.isEmpty());
        GeneralEnvelope geot4261 = new GeneralEnvelope(2);
        GeneralDirectPosition dp = new GeneralDirectPosition(new double[]{100.0, 200.0});
        Assert.assertTrue((boolean)geot4261.isEmpty());
        geot4261.add((DirectPosition)dp);
        Assert.assertEquals((Object)new GeneralEnvelope(dp, dp), (Object)geot4261);
    }

    @Test
    public void testEquals() {
        GeneralEnvelope e1 = new GeneralEnvelope(4);
        Assert.assertTrue((boolean)e1.isEmpty());
        Assert.assertTrue((boolean)e1.isNull());
        Assert.assertEquals((Object)e1.getLowerCorner(), (Object)e1.getUpperCorner());
        int i = e1.getDimension();
        while (--i >= 0) {
            e1.setRange(i, (double)(i * 5 + 2), (double)(i * 6 + 5));
        }
        Assert.assertFalse((boolean)e1.isNull());
        Assert.assertFalse((boolean)e1.isEmpty());
        Assert.assertNotEquals((Object)e1.getLowerCorner(), (Object)e1.getUpperCorner());
        GeneralEnvelope e2 = new GeneralEnvelope((Envelope)e1);
        GeneralEnvelopeTest.assertPositionEquals(e1.getLowerCorner(), e2.getLowerCorner());
        GeneralEnvelopeTest.assertPositionEquals(e1.getUpperCorner(), e2.getUpperCorner());
        Assert.assertTrue((boolean)e1.contains((Envelope)e2, true));
        Assert.assertFalse((boolean)e1.contains((Envelope)e2, false));
        Assert.assertNotSame((Object)e1, (Object)e2);
        Assert.assertEquals((Object)e1, (Object)e2);
        Assert.assertTrue((boolean)e1.equals((Envelope)e2, 1.0E-4, true));
        Assert.assertTrue((boolean)e1.equals((Envelope)e2, 1.0E-4, false));
        Assert.assertEquals((long)e1.hashCode(), (long)e2.hashCode());
        e2.setRange(2, e2.getMinimum(2) + 3.0E-5, e2.getMaximum(2) - 3.0E-5);
        Assert.assertTrue((boolean)e1.contains((Envelope)e2, true));
        Assert.assertFalse((boolean)e1.contains((Envelope)e2, false));
        Assert.assertNotEquals((Object)e1, (Object)e2);
        Assert.assertTrue((boolean)e1.equals((Envelope)e2, 1.0E-4, true));
        Assert.assertTrue((boolean)e1.equals((Envelope)e2, 1.0E-4, false));
        Assert.assertNotEquals((long)e1.hashCode(), (long)e2.hashCode());
        e2.setRange(1, e2.getMinimum(1) + 3.0, e2.getMaximum(1) - 3.0);
        Assert.assertTrue((boolean)e1.contains((Envelope)e2, true));
        Assert.assertFalse((boolean)e1.contains((Envelope)e2, false));
        Assert.assertNotEquals((Object)e1, (Object)e2);
        Assert.assertFalse((boolean)e1.equals((Envelope)e2, 1.0E-4, true));
        Assert.assertFalse((boolean)e1.equals((Envelope)e2, 1.0E-4, false));
        Assert.assertNotEquals((long)e1.hashCode(), (long)e2.hashCode());
    }

    private static void assertPositionEquals(DirectPosition p1, DirectPosition p2) {
        Assert.assertNotSame((Object)p1, (Object)p2);
        Assert.assertEquals((Object)p1, (Object)p2);
        Assert.assertEquals((long)p1.hashCode(), (long)p2.hashCode());
    }
}

