/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public final class PixelTranslation
implements Serializable {
    private static final long serialVersionUID = 2616596940766158984L;
    private static final MathTransform[] translations = new MathTransform[16];
    public final PixelOrientation orientation;
    public final double dx;
    public final double dy;
    private static Map<PixelOrientation, PixelTranslation> ORIENTATIONS = new HashMap<PixelOrientation, PixelTranslation>(12);

    private PixelTranslation(PixelOrientation orientation, double dx, double dy) {
        this.orientation = orientation;
        this.dx = dx;
        this.dy = dy;
        if (ORIENTATIONS.put(orientation, this) != null) {
            throw new AssertionError(this);
        }
    }

    private PixelTranslation(String orientation, double dx, double dy) {
        this(PixelOrientation.valueOf((String)orientation), dx, dy);
    }

    public static PixelOrientation getPixelOrientation(PixelInCell anchor) throws IllegalArgumentException {
        if (PixelInCell.CELL_CENTER.equals((Object)anchor)) {
            return PixelOrientation.CENTER;
        }
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            return PixelOrientation.UPPER_LEFT;
        }
        if (anchor == null) {
            return null;
        }
        throw new IllegalArgumentException(Errors.format((int)58, (Object)"anchor", (Object)anchor));
    }

    public static double getPixelTranslation(PixelInCell anchor) {
        if (PixelInCell.CELL_CENTER.equals((Object)anchor)) {
            return 0.0;
        }
        if (PixelInCell.CELL_CORNER.equals((Object)anchor)) {
            return -0.5;
        }
        throw new IllegalArgumentException(Errors.format((int)58, (Object)"anchor", (Object)anchor));
    }

    public static PixelTranslation getPixelTranslation(PixelOrientation anchor) throws IllegalArgumentException {
        PixelTranslation offset = ORIENTATIONS.get(anchor);
        if (offset == null) {
            throw new IllegalArgumentException(Errors.format((int)58, (Object)"anchor", (Object)anchor));
        }
        return offset;
    }

    public static PixelOrientation getPixelOrientation(double dx, double dy) {
        for (PixelTranslation candidate : ORIENTATIONS.values()) {
            if (candidate.dx != dx || candidate.dy != dy) continue;
            return candidate.orientation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathTransform translate(MathTransform gridToCRS, PixelInCell current, PixelInCell expected) {
        LinearTransform mt;
        if (Utilities.equals((Object)current, (Object)expected)) {
            return gridToCRS;
        }
        if (gridToCRS == null) {
            return null;
        }
        int dimension = gridToCRS.getSourceDimensions();
        double offset = PixelTranslation.getPixelTranslation(expected) - PixelTranslation.getPixelTranslation(current);
        int index = offset == -0.5 ? 2 * dimension : (offset == 0.5 ? 2 * dimension + 1 : translations.length);
        if (index >= translations.length) {
            mt = ProjectiveTransform.createTranslation(dimension, offset);
            return ConcatenatedTransform.create(mt, gridToCRS);
        }
        MathTransform[] mathTransformArray = translations;
        synchronized (translations) {
            mt = translations[index];
            if (mt != null) return ConcatenatedTransform.create(mt, gridToCRS);
            mt = ProjectiveTransform.createTranslation(dimension, offset);
            PixelTranslation.translations[index] = mt;
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return ConcatenatedTransform.create(mt, gridToCRS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MathTransform translate(MathTransform gridToCRS, PixelOrientation current, PixelOrientation expected, int xDimension, int yDimension) {
        LinearTransform mt;
        if (Utilities.equals((Object)current, (Object)expected)) {
            return gridToCRS;
        }
        if (gridToCRS == null) {
            return null;
        }
        int dimension = gridToCRS.getSourceDimensions();
        if (xDimension < 0 || xDimension >= dimension) {
            throw PixelTranslation.illegalDimension("xDimension", xDimension);
        }
        if (yDimension < 0 || yDimension >= dimension) {
            throw PixelTranslation.illegalDimension("yDimension", yDimension);
        }
        if (xDimension == yDimension) {
            throw PixelTranslation.illegalDimension("xDimension", "yDimension");
        }
        PixelTranslation source = PixelTranslation.getPixelTranslation(current);
        PixelTranslation target = PixelTranslation.getPixelTranslation(expected);
        double dx = target.dx - source.dx;
        double dy = target.dy - source.dy;
        if (dimension == 2 && (xDimension | yDimension) == 1 && dx == dy && Math.abs(dx) == 0.5) {
            int index = dx >= 0.0 ? 5 : 4;
            MathTransform[] mathTransformArray = translations;
            synchronized (translations) {
                mt = translations[index];
                if (mt == null) {
                    mt = ProjectiveTransform.createTranslation(dimension, dx);
                    PixelTranslation.translations[index] = mt;
                }
                // ** MonitorExit[var14_12] (shouldn't be in output)
            }
        } else {
            XMatrix matrix = MatrixFactory.create(dimension + 1);
            matrix.setElement(xDimension, dimension, dx);
            matrix.setElement(yDimension, dimension, dy);
            mt = ProjectiveTransform.create(matrix);
        }
        return ConcatenatedTransform.create(mt, gridToCRS);
    }

    private static IllegalArgumentException illegalDimension(String name, Object dimension) {
        return new IllegalArgumentException(Errors.format((int)58, (Object)name, (Object)dimension));
    }

    public String toString() {
        return String.valueOf(this.orientation) + "[" + this.dx + ", " + this.dy + "]";
    }

    static {
        new PixelTranslation(PixelOrientation.CENTER, 0.0, 0.0);
        new PixelTranslation(PixelOrientation.UPPER_LEFT, -0.5, -0.5);
        new PixelTranslation(PixelOrientation.UPPER_RIGHT, 0.5, -0.5);
        new PixelTranslation(PixelOrientation.LOWER_LEFT, -0.5, 0.5);
        new PixelTranslation(PixelOrientation.LOWER_RIGHT, 0.5, 0.5);
        new PixelTranslation("LEFT", -0.5, 0.0);
        new PixelTranslation("RIGHT", 0.5, 0.0);
        new PixelTranslation("UPPER", 0.0, -0.5);
        new PixelTranslation("LOWER", 0.0, 0.5);
    }
}

