/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.referencing.operation.TransformTestBase;
import org.geotools.referencing.operation.transform.MolodenskiTransform;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class MolodenskiTransformTest
extends TransformTestBase {
    private float[] srcFloat2 = new float[]{0.0f, 0.0f, 0.0f, 89.999f, 0.0f, -89.999f, 179.999f, 0.0f, -179.999f, 0.0f, 0.0f, 0.0f, -123.19641f, 39.26859f};
    private MolodenskiTransform molodenski00;

    @Before
    public void setUp() {
        double a = 6378137.0;
        double b = 6356752.0;
        this.molodenski00 = new MolodenskiTransform(false, a, b, false, a, b, false, 0.0, 0.0, 0.0);
    }

    @Test
    public void testArrayOverwrite() {
        int srcOff = 0;
        int dstOff = 2;
        int numPts = 2;
        float[] overWriteTestArray = (float[])this.srcFloat2.clone();
        this.molodenski00.transform(overWriteTestArray, srcOff, overWriteTestArray, dstOff, numPts);
        int dim = 2;
        for (int i = 0; i < numPts; ++i) {
            Assert.assertEquals((double)this.srcFloat2[srcOff + dim * i], (double)overWriteTestArray[dstOff + dim * i], (double)1.0E-6);
            Assert.assertEquals((double)this.srcFloat2[srcOff + dim * i + 1], (double)overWriteTestArray[dstOff + dim * i + 1], (double)1.0E-6);
        }
    }
}

