/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Random;
import org.geotools.geometry.DirectPosition1D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ConstantTransform1D;
import org.geotools.referencing.operation.transform.ExponentialTransform1D;
import org.geotools.referencing.operation.transform.LogarithmicTransform1D;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class MathTransformTest {
    private Random random;
    private DefaultMathTransformFactory factory;
    private static final double ACCURACY = 0.03;

    @Before
    public void setUp() {
        this.random = new Random(-3531834320875149028L);
        this.factory = new DefaultMathTransformFactory();
    }

    @Test
    public void testDirectPositionTransform() throws FactoryException, TransformException {
        CoordinateReferenceSystem crs = ReferencingFactoryFinder.getCRSFactory(null).createFromWKT("PROJCS[\"NAD_1983_UTM_Zone_10N\",\n  GEOGCS[\"GCS_North_American_1983\",\n    DATUM[\"D_North_American_1983\",\n      TOWGS84[0,0,0,0,0,0,0],\n      SPHEROID[\"GRS_1980\", 6378137, 298.257222101]],\n    PRIMEM[\"Greenwich\",0],\n    UNIT[\"Degree\", 0.017453292519943295]],\n  PROJECTION[\"Transverse_Mercator\"],\n  PARAMETER[\"False_Easting\",500000],\n  PARAMETER[\"False_Northing\",0],\n  PARAMETER[\"Central_Meridian\",-123],\n  PARAMETER[\"Scale_Factor\",0.9996],\n  PARAMETER[\"Latitude_Of_Origin\",0],\n  UNIT[\"Meter\",1]]");
        MathTransform t = ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, crs).getMathTransform();
        GeneralDirectPosition position = new GeneralDirectPosition(-123.0, 55.0);
        position = t.transform((DirectPosition)position, (DirectPosition)position);
        position = t.inverse().transform((DirectPosition)position, (DirectPosition)position);
        Assert.assertEquals((double)-123.0, (double)position.getOrdinate(0), (double)1.0E-6);
        Assert.assertEquals((double)55.0, (double)position.getOrdinate(1), (double)1.0E-6);
    }

    @Test
    public void testAffineTransform() throws FactoryException, TransformException {
        for (int pass = 0; pass < 10; ++pass) {
            AffineTransform transform = new AffineTransform();
            transform.rotate(Math.PI * this.random.nextDouble(), 100.0 * this.random.nextDouble(), 100.0 * this.random.nextDouble());
            transform.scale(2.0 * this.random.nextDouble(), 2.0 * this.random.nextDouble());
            transform.shear(2.0 * this.random.nextDouble(), 2.0 * this.random.nextDouble());
            transform.translate(100.0 * this.random.nextDouble(), 100.0 * this.random.nextDouble());
            this.compareTransforms("AffineTransform", new MathTransform[]{new ProjectiveTransform((Matrix)new GeneralMatrix(transform)), new AffineTransform2D(transform)});
        }
        AffineTransform at = new AffineTransform(23.157082917424454, 0.0, 3220.1613428464952, 0.0, -23.157082917424457, 1394.4593259871676);
        MathTransform mt = this.factory.createAffineTransform((Matrix)new GeneralMatrix(at));
        double[] points = new double[]{-129.992589135802, 55.9226692948365, -129.987254340541, 55.9249676996729, -129.982715772093, 55.9308988434656, -129.989772198265, 55.9289277997662, -129.992589135802, 55.9226692948365};
        double[] transformedPoints = new double[points.length];
        mt.transform(points, 0, transformedPoints, 0, points.length / 2);
        at.transform(points, 0, points, 0, points.length / 2);
        for (int i = 0; i < transformedPoints.length; ++i) {
            Assert.assertEquals((double)points[i], (double)transformedPoints[i], (double)0.03);
        }
    }

    @Test
    public void testSubAffineTransform() throws FactoryException, TransformException {
        for (int pass = 0; pass < 5; ++pass) {
            int i;
            int dimension = 10;
            GeneralMatrix matrix = new GeneralMatrix(11, 11);
            for (int i2 = 0; i2 < 10; ++i2) {
                matrix.setElement(i2, i2, 400.0 * Math.random() - 200.0);
                matrix.setElement(i2, 10, 400.0 * Math.random() - 200.0);
            }
            Assert.assertTrue((boolean)matrix.isAffine());
            MathTransform[] transforms = new MathTransform[10];
            for (i = 1; i <= 10; ++i) {
                GeneralMatrix sub = new GeneralMatrix(i + 1, i + 1);
                matrix.copySubMatrix(0, 0, i, i, 0, 0, sub);
                matrix.copySubMatrix(0, 10, i, 1, 0, i, sub);
                MathTransform mathTransform = this.factory.createAffineTransform((Matrix)sub);
                transforms[i - 1] = mathTransform;
                MathTransform transform = mathTransform;
                Assert.assertTrue((boolean)sub.isAffine());
                Assert.assertEquals((Object)sub, (Object)new GeneralMatrix(((LinearTransform)transform).getMatrix()));
                MathTransformTest.assertInterfaced(transform);
                Assert.assertEquals((long)i, (long)transform.getSourceDimensions());
            }
            Assert.assertTrue((String)"MathTransform1D", (boolean)(transforms[0] instanceof MathTransform1D));
            Assert.assertTrue((String)"MathTransform2D", (boolean)(transforms[1] instanceof MathTransform2D));
            Assert.assertEquals((Object)matrix, (Object)((LinearTransform)transforms[9]).getMatrix());
            this.compareTransforms("SubAffineTransform", transforms);
            for (i = 0; i < transforms.length; ++i) {
                transforms[i] = transforms[i].inverse();
            }
            this.compareTransforms("SubAffineTransform.inverse", transforms);
        }
    }

    @Test
    public void testAffineTransformConcatenation() throws FactoryException, TransformException {
        MathTransform[] transforms = new MathTransform[2];
        int numDim = 4;
        int numPts = 200;
        for (int pass = 0; pass < 100; ++pass) {
            int i;
            int dimSource = this.random.nextInt(4) + 1;
            int dimTarget = this.random.nextInt(4) + 1;
            int dimInterm = this.random.nextInt(4) + 1;
            Matrix matrix1 = this.getRandomMatrix(dimSource, dimInterm);
            Matrix matrix2 = this.getRandomMatrix(dimInterm, dimTarget);
            MathTransform tr1 = this.factory.createAffineTransform(matrix1);
            MathTransform tr2 = this.factory.createAffineTransform(matrix2);
            double[] sourcePt = new double[dimSource * 200];
            double[] intermPt = new double[dimInterm * 200];
            double[] targetPt = new double[dimTarget * 200];
            double[] compare = new double[dimTarget * 200];
            double[] delta = new double[dimTarget];
            for (i = 0; i < 200; ++i) {
                sourcePt[i] = 100.0 * this.random.nextDouble() - 50.0;
            }
            tr1.transform(sourcePt, 0, intermPt, 0, 200);
            tr2.transform(intermPt, 0, targetPt, 0, 200);
            Arrays.fill(delta, 1.0E-6);
            transforms[0] = this.factory.createConcatenatedTransform(tr1, tr2);
            transforms[1] = ConcatenatedTransform.createConcatenatedTransform((MathTransform)tr1, (MathTransform)tr2);
            Assert.assertTrue((boolean)(transforms[0] instanceof LinearTransform));
            Assert.assertFalse((boolean)(transforms[1] instanceof LinearTransform));
            for (i = 0; i < transforms.length; ++i) {
                MathTransform transform = transforms[i];
                MathTransformTest.assertInterfaced(transform);
                Assert.assertEquals((String)("dimSource[" + i + "]"), (long)dimSource, (long)transform.getSourceDimensions());
                Assert.assertEquals((String)("dimTarget[" + i + "]"), (long)dimTarget, (long)transform.getTargetDimensions());
                transform.transform(sourcePt, 0, compare, 0, 200);
                String name = "transform[" + i + "](" + dimSource + " -> " + dimInterm + " -> " + dimTarget + ")";
                MathTransformTest.assertPointsEqual(name, targetPt, compare, delta);
            }
        }
    }

    @Test
    public void testNaN() throws FactoryException, TransformException {
        XMatrix matrix = MatrixFactory.create((int)2);
        matrix.setElement(0, 0, 0.0);
        for (int i = 0; i < 200; ++i) {
            int rawBits = 2143289344 + this.random.nextInt(100);
            float value = Float.intBitsToFloat(rawBits);
            Assert.assertTrue((String)"isNaN", (boolean)Float.isNaN(value));
            matrix.setElement(0, 1, (double)value);
            MathTransform1D tr = (MathTransform1D)this.factory.createAffineTransform((Matrix)matrix);
            Assert.assertTrue((String)"ConstantTransform1D", (boolean)(tr instanceof ConstantTransform1D));
            float compare = (float)tr.transform(0.0);
            Assert.assertEquals((String)"rawBits", (long)rawBits, (long)Float.floatToRawIntBits(compare));
        }
    }

    @Test
    public void testLogarithmicTransform() throws FactoryException, TransformException {
        double[] POWER_2 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0};
        double[] VALUE_2 = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 256.0, 512.0, 1024.0, 2048.0, 4096.0, 8192.0};
        double[] POWER_10 = new double[]{-5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        double[] VALUE_10 = new double[]{1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0};
        this.compareTransform1D("Exponential", 2.0, POWER_2, VALUE_2);
        this.compareTransform1D("Exponential", 10.0, POWER_10, VALUE_10);
        this.compareTransform1D("Logarithmic", 2.0, VALUE_2, POWER_2);
        this.compareTransform1D("Logarithmic", 10.0, VALUE_10, POWER_10);
    }

    @Test
    public void testLogarithmicAndExponentialConcatenation() throws FactoryException, TransformException {
        int numPts = 200;
        double[] sourcePt = new double[200];
        double[] targetPt = new double[200];
        double[] compare = new double[200];
        double[] delta = new double[200];
        for (int pass = 0; pass < 100; ++pass) {
            for (int i = 0; i < 200; ++i) {
                sourcePt[i] = 20.0 * this.random.nextDouble() + 0.1;
            }
            MathTransform1D ctr = this.getRandomTransform1D();
            ctr.transform(sourcePt, 0, targetPt, 0, 200);
            int i = this.random.nextInt(2) + 1;
            while (--i >= 0) {
                MathTransform1D step = this.getRandomTransform1D();
                ctr = this.factory.createConcatenatedTransform((MathTransform)ctr, (MathTransform)step);
                step.transform(targetPt, 0, targetPt, 0, 200);
            }
            ctr.transform(sourcePt, 0, compare, 0, 200);
            double EPS = Math.pow(10.0, -5 + MathTransformTest.countNonlinear((MathTransform)ctr));
            for (int i2 = 0; i2 < 200; ++i2) {
                delta[i2] = Math.max(1.0E-9, Math.abs(targetPt[i2] * EPS));
                if (targetPt[i2] >= 1.0E300) {
                    targetPt[i2] = Double.POSITIVE_INFINITY;
                }
                if (!(targetPt[i2] <= -1.0E300)) continue;
                targetPt[i2] = Double.NEGATIVE_INFINITY;
            }
            MathTransformTest.assertPointsEqual("transform[" + String.valueOf(ctr) + "]", targetPt, compare, delta);
            try {
                MathTransform inv = ctr.inverse();
                Arrays.fill(delta, Math.pow(10.0, MathTransformTest.countNonlinear(inv)));
                inv.transform(targetPt, 0, compare, 0, 200);
                for (int i3 = 0; i3 < 200; ++i3) {
                    if (MathTransformTest.isReal(targetPt[i3]) && MathTransformTest.isReal(compare[i3])) continue;
                    sourcePt[i3] = Double.NaN;
                }
                MathTransformTest.assertPointsEqual("inverse[" + String.valueOf(inv) + "]", sourcePt, compare, delta);
                continue;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    private Matrix getRandomMatrix(int dimSource, int dimTarget) {
        XMatrix matrix = MatrixFactory.create((int)(dimTarget + 1), (int)(dimSource + 1));
        for (int j = 0; j < dimTarget; ++j) {
            for (int i = 0; i <= dimSource; ++i) {
                matrix.setElement(j, i, 10.0 * this.random.nextDouble() - 5.0);
            }
            if (j <= dimSource) {
                matrix.setElement(j, j, 40.0 * this.random.nextDouble() + 10.0);
            }
            matrix.setElement(j, dimSource, 80.0 * this.random.nextDouble() - 40.0);
        }
        if (dimSource == dimTarget) {
            Assert.assertTrue((String)"Affine", (boolean)matrix.isAffine());
        }
        return matrix;
    }

    private MathTransform1D getRandomTransform1D() throws FactoryException {
        String[] candidates = new String[]{"Logarithmic", "Exponential", "Affine"};
        String classification = candidates[this.random.nextInt(candidates.length)];
        ParameterValueGroup parameters = this.factory.getDefaultParameters(classification);
        if (classification.equalsIgnoreCase("Affine")) {
            parameters.parameter("num_row").setValue(2);
            parameters.parameter("num_col").setValue(2);
            parameters.parameter("elt_0_0").setValue(this.random.nextDouble() * 2.0 + 0.1);
            parameters.parameter("elt_0_1").setValue(this.random.nextDouble() * 1.0 - 2.0);
        } else {
            parameters.parameter("base").setValue(this.random.nextDouble() * 4.0 + 0.1);
        }
        return (MathTransform1D)this.factory.createParameterizedTransform(parameters);
    }

    private void compareTransforms(String name, MathTransform[] transforms) throws TransformException {
        GeneralDirectPosition[] sources = new GeneralDirectPosition[transforms.length];
        GeneralDirectPosition[] targets = new GeneralDirectPosition[transforms.length];
        int maxDimSource = 0;
        int maxDimTarget = 0;
        for (int i = 0; i < transforms.length; ++i) {
            int dimSource = transforms[i].getSourceDimensions();
            int dimTarget = transforms[i].getTargetDimensions();
            if (dimSource > maxDimSource) {
                maxDimSource = dimSource;
            }
            if (dimTarget > maxDimTarget) {
                maxDimTarget = dimTarget;
            }
            sources[i] = new GeneralDirectPosition(dimSource);
            targets[i] = new GeneralDirectPosition(dimTarget);
        }
        for (int pass = 0; pass < 200; ++pass) {
            int j;
            for (j = 0; j < maxDimSource; ++j) {
                double ord = 100.0 * this.random.nextDouble();
                for (GeneralDirectPosition source : sources) {
                    if (j >= source.ordinates.length) continue;
                    source.ordinates[j] = ord;
                }
            }
            for (j = 0; j < transforms.length; ++j) {
                Assert.assertSame((Object)transforms[j].transform((DirectPosition)sources[j], (DirectPosition)targets[j]), (Object)targets[j]);
            }
            StringBuilder buffer = new StringBuilder(name);
            buffer.append(": Compare transform[");
            int lengthJ = buffer.length();
            for (int j2 = 0; j2 < targets.length; ++j2) {
                buffer.setLength(lengthJ);
                buffer.append(j2).append("] with [");
                int lengthI = buffer.length();
                GeneralDirectPosition targetJ = targets[j2];
                for (int i = j2 + 1; i < targets.length; ++i) {
                    buffer.setLength(lengthI);
                    buffer.append(i).append(']');
                    String label = buffer.toString();
                    GeneralDirectPosition targetI = targets[i];
                    Assert.assertNotSame((Object)targetJ.ordinates, (Object)targetI.ordinates);
                    int k = Math.min(targetJ.ordinates.length, targetI.ordinates.length);
                    while (--k >= 0) {
                        Assert.assertEquals((String)label, (double)targetJ.ordinates[k], (double)targetI.ordinates[k], (double)1.0E-6);
                    }
                }
            }
        }
    }

    private void compareTransform1D(String classification, double base, double[] input, double[] expected) throws FactoryException, TransformException {
        Assert.assertEquals((long)input.length, (long)expected.length);
        ParameterValueGroup parameters = this.factory.getDefaultParameters(classification);
        parameters.parameter("base").setValue(base);
        MathTransform1D direct = (MathTransform1D)this.factory.createParameterizedTransform(parameters);
        MathTransform1D inverse = direct.inverse();
        DirectPosition1D point = new DirectPosition1D();
        for (int i = 0; i < expected.length; ++i) {
            double x = input[i];
            double y = direct.transform(x);
            Assert.assertEquals((String)("transform[x=" + x + "]"), (double)expected[i], (double)y, (double)1.0E-6);
            Assert.assertEquals((String)("inverse  [y=" + y + "]"), (double)x, (double)inverse.transform(y), (double)1.0E-6);
            point.setOrdinate(0, x);
            Assert.assertSame((Object)direct.transform((DirectPosition)point, (DirectPosition)point), (Object)point);
            Assert.assertEquals((double)y, (double)point.getOrdinate(0), (double)1.0E-9);
        }
    }

    private static int countNonlinear(MathTransform transform) {
        if (transform instanceof ExponentialTransform1D || transform instanceof LogarithmicTransform1D) {
            return 1;
        }
        if (transform instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)transform;
            return MathTransformTest.countNonlinear(ct.transform1) + MathTransformTest.countNonlinear(ct.transform2);
        }
        return 0;
    }

    private static boolean isReal(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    private static void assertInterfaced(MathTransform transform) {
        Matrix matrix;
        if (transform instanceof LinearTransform && !((XMatrix)(matrix = ((LinearTransform)transform).getMatrix())).isAffine()) {
            return;
        }
        int dim = transform.getSourceDimensions();
        if (transform.getTargetDimensions() != dim) {
            dim = 0;
        }
        Assert.assertEquals((String)"MathTransform1D", (Object)(dim == 1 ? 1 : 0), (Object)(transform instanceof MathTransform1D));
        Assert.assertEquals((String)"MathTransform2D", (Object)(dim == 2 ? 1 : 0), (Object)(transform instanceof MathTransform2D));
    }

    private static void assertPointsEqual(String name, double[] expected, double[] actual, double[] delta) {
        int dimension = delta.length;
        int stop = Math.min(expected.length, actual.length) / dimension * dimension;
        Assert.assertEquals((String)"Array length for expected points", (long)stop, (long)expected.length);
        Assert.assertEquals((String)"Array length for actual points", (long)stop, (long)actual.length);
        StringBuffer buffer = new StringBuffer(name);
        buffer.append(": point[");
        int start = buffer.length();
        for (int i = 0; i < stop; ++i) {
            buffer.setLength(start);
            buffer.append(i / dimension);
            buffer.append(", dimension ");
            buffer.append(i % dimension);
            buffer.append(" of ");
            buffer.append(dimension);
            buffer.append(']');
            if (!MathTransformTest.isReal(expected[i])) continue;
            Assert.assertEquals((String)buffer.toString(), (double)expected[i], (double)actual[i], (double)delta[i % dimension]);
        }
    }

    @Test
    public void testWGS84toWGS843D() throws Exception {
        String wkt = "GEOGCS[\"GDA94\", DATUM[\"Geocentric Datum of Australia 1994\",  SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101, AUTHORITY[\"EPSG\",\"7019\"]],  TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],  AUTHORITY[\"EPSG\",\"6283\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Geodetic latitude\", NORTH],  AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Ellipsoidal height\", UP],  AUTHORITY[\"EPSG\",\"4939\"]]";
        CoordinateReferenceSystem gda94 = CRS.parseWKT((String)wkt);
        MathTransform toWgs84_3d = CRS.findMathTransform((CoordinateReferenceSystem)gda94, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
        MathTransform toWgs84_2d = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        MathTransform transform = ConcatenatedTransform.create((MathTransform)toWgs84_3d, (MathTransform)toWgs84_2d);
        Assert.assertNotNull((Object)transform);
        Assert.assertEquals((long)3L, (long)transform.getSourceDimensions());
        Assert.assertEquals((long)2L, (long)transform.getTargetDimensions());
        ConcatenatedTransform concatenated = (ConcatenatedTransform)transform;
        Assert.assertEquals((long)3L, (long)concatenated.transform1.getSourceDimensions());
        Assert.assertEquals((long)3L, (long)concatenated.transform1.getTargetDimensions());
        Assert.assertEquals((long)3L, (long)concatenated.transform2.getSourceDimensions());
        Assert.assertEquals((long)2L, (long)concatenated.transform2.getTargetDimensions());
        try {
            MathTransform inverse = transform.inverse();
            Assert.assertNotNull((Object)inverse);
            Assert.assertEquals((long)2L, (long)inverse.getSourceDimensions());
            Assert.assertEquals((long)3L, (long)inverse.getTargetDimensions());
            Assert.fail((String)"Inverse of gda94 to WGS84 not expected to work at this time");
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }
}

