/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public final class GeocentricTranslationTest {
    @Test
    public void testTranslation() throws FactoryException, TransformException {
        String classification = "Geocentric translations (geog2d domain)";
        MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup param = factory.getDefaultParameters("Geocentric translations (geog2d domain)");
        param.parameter("dx").setValue(84.87);
        param.parameter("dy").setValue(96.49);
        param.parameter("dz").setValue(116.95);
        MathTransform test = factory.createParameterizedTransform(param);
        GeneralDirectPosition position = new GeneralDirectPosition(3);
        position.setOrdinate(0, 3771793.97);
        position.setOrdinate(1, 140253.34);
        position.setOrdinate(2, 5124304.35);
        Assert.assertSame((Object)position, (Object)test.transform((DirectPosition)position, (DirectPosition)position));
        Assert.assertEquals((double)3771878.84, (double)position.getOrdinate(0), (double)1.0E-5);
        Assert.assertEquals((double)140349.83, (double)position.getOrdinate(1), (double)1.0E-5);
        Assert.assertEquals((double)5124421.3, (double)position.getOrdinate(2), (double)1.0E-5);
    }

    @Test
    public void testSevenParam() throws FactoryException, TransformException {
        String classification = "Position Vector transformation (geog2d domain)";
        MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup param = factory.getDefaultParameters("Position Vector transformation (geog2d domain)");
        param.parameter("dx").setValue(0.0);
        param.parameter("dy").setValue(0.0);
        param.parameter("dz").setValue(4.5);
        param.parameter("ex").setValue(0.0);
        param.parameter("ey").setValue(0.0);
        param.parameter("ez").setValue(0.554);
        param.parameter("ppm").setValue(0.219);
        MathTransform test = factory.createParameterizedTransform(param);
        GeneralDirectPosition position = new GeneralDirectPosition(3);
        position.setOrdinate(0, 3657660.66);
        position.setOrdinate(1, 255768.55);
        position.setOrdinate(2, 5201382.11);
        Assert.assertSame((Object)position, (Object)test.transform((DirectPosition)position, (DirectPosition)position));
        Assert.assertEquals((double)3657660.78, (double)position.getOrdinate(0), (double)0.01);
        Assert.assertEquals((double)255778.43, (double)position.getOrdinate(1), (double)1.0E-5);
        Assert.assertEquals((double)5201387.75, (double)position.getOrdinate(2), (double)0.01);
    }

    @Test
    public void testFrameRotation() throws FactoryException, TransformException {
        String classification = "Coordinate Frame rotation (geog2d domain)";
        MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup param = factory.getDefaultParameters("Coordinate Frame rotation (geog2d domain)");
        param.parameter("dx").setValue(0.0);
        param.parameter("dy").setValue(0.0);
        param.parameter("dz").setValue(4.5);
        param.parameter("ex").setValue(0.0);
        param.parameter("ey").setValue(0.0);
        param.parameter("ez").setValue(-0.554);
        param.parameter("ppm").setValue(0.219);
        MathTransform test = factory.createParameterizedTransform(param);
        GeneralDirectPosition position = new GeneralDirectPosition(3);
        position.setOrdinate(0, 3657660.66);
        position.setOrdinate(1, 255768.55);
        position.setOrdinate(2, 5201382.11);
        Assert.assertSame((Object)position, (Object)test.transform((DirectPosition)position, (DirectPosition)position));
        Assert.assertEquals((double)3657660.78, (double)position.getOrdinate(0), (double)0.01);
        Assert.assertEquals((double)255778.43, (double)position.getOrdinate(1), (double)1.0E-5);
        Assert.assertEquals((double)5201387.75, (double)position.getOrdinate(2), (double)0.01);
    }

    @Test
    public void testGeotoolsExtensions() throws FactoryException, TransformException {
        String classification = "Coordinate Frame rotation (geog2d domain)";
        MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
        ParameterValueGroup param = factory.getDefaultParameters("Coordinate Frame rotation (geog2d domain)");
        DefaultEllipsoid sourceEllipsoid = DefaultEllipsoid.INTERNATIONAL_1924;
        DefaultEllipsoid targetEllipsoid = DefaultEllipsoid.WGS84;
        param.parameter("dx").setValue(0.0);
        param.parameter("dy").setValue(0.0);
        param.parameter("dz").setValue(4.5);
        param.parameter("ex").setValue(0.0);
        param.parameter("ey").setValue(0.0);
        param.parameter("ez").setValue(-0.554);
        param.parameter("ppm").setValue(0.219);
        param.parameter("src_dim").setValue(3);
        param.parameter("tgt_dim").setValue(3);
        param.parameter("src_semi_major").setValue(sourceEllipsoid.getSemiMajorAxis());
        param.parameter("src_semi_minor").setValue(sourceEllipsoid.getSemiMinorAxis());
        param.parameter("tgt_semi_major").setValue(targetEllipsoid.getSemiMajorAxis());
        param.parameter("tgt_semi_minor").setValue(targetEllipsoid.getSemiMinorAxis());
        MathTransform test = factory.createParameterizedTransform(param);
        GeneralDirectPosition position = new GeneralDirectPosition(3);
        position.setOrdinate(0, 4.0);
        position.setOrdinate(1, 55.0);
        position.setOrdinate(2, -191.61);
        Assert.assertSame((Object)position, (Object)test.transform((DirectPosition)position, (DirectPosition)position));
        Assert.assertEquals((double)4.0, (double)position.getOrdinate(0), (double)0.01);
        Assert.assertEquals((double)55.0, (double)position.getOrdinate(1), (double)0.01);
        Assert.assertEquals((double)3.23, (double)position.getOrdinate(2), (double)0.01);
    }
}

