/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.awt.RenderingHints;
import java.util.Set;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.operation.AuthorityBackedFactory;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.TransformTestBase;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;

public final class CoordinateOperationFactoryTest
extends TransformTestBase {
    private static final String WGS84_Z = "COMPD_CS[\"WGS84 + Z\",GEOGCS[\"WGS 84\",\n  DATUM[\"WGS_1984\",\n    SPHEROID[\"WGS 84\", 6378137, 298.257223563,\n      AUTHORITY[\"EPSG\",\"7030\"]],\n    TOWGS84[0,0,0,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6326\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4326\"]],VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]]";
    private static final String NAD27_Z = "COMPD_CS[\"NAD27 + Z\",GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]],VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]]";
    private static final String Z_NAD27 = "COMPD_CS[\"Z + NAD27\",VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]],GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]]]";
    private static final String WGS84_H = "COMPD_CS[\"WGS84 + H\",GEOGCS[\"WGS 84\",\n  DATUM[\"WGS_1984\",\n    SPHEROID[\"WGS 84\", 6378137, 298.257223563,\n      AUTHORITY[\"EPSG\",\"7030\"]],\n    TOWGS84[0,0,0,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6326\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4326\"]],VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]]";
    private static final String NAD27_H = "COMPD_CS[\"NAD27 + Z\",GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]],VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]]";
    private boolean usingDefaultFactory;

    @Before
    public void ensureClassLoaded() {
        Assert.assertNotNull((Object)PositionalAccuracyImpl.DATUM_SHIFT_APPLIED);
        Assert.assertNotNull((Object)PositionalAccuracyImpl.DATUM_SHIFT_OMITTED);
        this.usingDefaultFactory = !(this.opFactory instanceof AuthorityBackedFactory);
    }

    @Test
    public void testFactoryWithHints() {
        Hints hints = new Hints();
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_DIRECTIONS, (Object)Boolean.TRUE);
        hints.put((Object)Hints.FORCE_STANDARD_AXIS_UNITS, (Object)Boolean.TRUE);
        CoordinateOperationFactory factory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        Assert.assertSame((Object)this.opFactory, (Object)factory);
    }

    @Test
    public void testGenericTransform() throws FactoryException {
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_3D, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_3D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D).getMathTransform().isIdentity());
        Assert.assertTrue((boolean)this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84).getMathTransform().isIdentity());
        try {
            this.opFactory.createOperation((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            Assert.fail();
        }
        catch (OperationNotFoundException operationNotFoundException) {
            // empty catch block
        }
        try {
            this.opFactory.createOperation((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
            Assert.fail();
        }
        catch (OperationNotFoundException operationNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUnitConversion() throws Exception {
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("PROJCS[\"TransverseMercator\",\n  GEOGCS[\"Sphere\",\n    DATUM[\"Sphere\",\n      SPHEROID[\"Sphere\", 6370997.0, 0.0],\n      TOWGS84[0,0,0,0,0,0,0]],\n    PRIMEM[\"Greenwich\", 0.0],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Longitude\", EAST],\n    AXIS[\"Latitude\", NORTH]],\n  PROJECTION[\"Transverse_Mercator\",\n    AUTHORITY[\"OGC\",\"Transverse_Mercator\"]],\n  PARAMETER[\"central_meridian\", 170.0],\n  PARAMETER[\"latitude_of_origin\", 50.0],\n  PARAMETER[\"scale_factor\", 0.95],\n  PARAMETER[\"false_easting\", 0.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"feet\", 0.304800609601219],\n  AXIS[\"x\", EAST],\n  AXIS[\"y\", NORTH]]\n");
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"Sphere\",\n  DATUM[\"Sphere\",\n    SPHEROID[\"Sphere\", 6370997.0, 0.0],\n    TOWGS84[0,0,0,0,0,0,0]],\n  PRIMEM[\"Greenwich\", 0.0],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Longitude\", EAST],\n  AXIS[\"Latitude\", NORTH]]");
        CoordinateOperation operation = this.opFactory.createOperation(sourceCRS, targetCRS);
        Assert.assertEquals((Object)sourceCRS, (Object)operation.getSourceCRS());
        Assert.assertEquals((Object)targetCRS, (Object)operation.getTargetCRS());
        Assert.assertTrue((boolean)(operation instanceof Projection));
        ParameterValueGroup param = ((Operation)operation).getParameterValues();
        Assert.assertEquals((String)"semi_major", (double)6370997.0, (double)param.parameter("semi_major").doubleValue(), (double)1.0E-5);
        Assert.assertEquals((String)"semi_minor", (double)6370997.0, (double)param.parameter("semi_minor").doubleValue(), (double)1.0E-5);
        Assert.assertEquals((String)"latitude_of_origin", (double)50.0, (double)param.parameter("latitude_of_origin").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"central_meridian", (double)170.0, (double)param.parameter("central_meridian").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"scale_factor", (double)0.95, (double)param.parameter("scale_factor").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_easting", (double)0.0, (double)param.parameter("false_easting").doubleValue(), (double)1.0E-8);
        Assert.assertEquals((String)"false_northing", (double)0.0, (double)param.parameter("false_northing").doubleValue(), (double)1.0E-8);
        MathTransform transform = operation.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(transform);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform.inverse(), 0.0, 0.0, 170.0, 50.0);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 170.0, 50.0, 0.0, 0.0);
    }

    @Test
    public void testEllipsoidShift() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NAD83\",\n  DATUM[\"North_American_Datum_1983\",\n    SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101,\n      AUTHORITY[\"EPSG\",\"7019\"]],\n    TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],\n    AUTHORITY[\"EPSG\",\"6269\"]],\n  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Lon\", EAST],\n  AXIS[\"Lat\", NORTH],\n  AUTHORITY[\"EPSG\",\"4269\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("GEOGCS[\"GCS_WGS_1984\",\n  DATUM[\"D_WGS_1984\",\n    SPHEROID[\"WGS_1984\", 6378137.0, 298.257223563]],\n  PRIMEM[\"Greenwich\", 0.0],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Lon\", EAST],\n  AXIS[\"Lat\", NORTH]]");
        CoordinateOperation operation = this.opFactory.createOperation(sourceCRS, targetCRS);
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)operation.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)operation.getTargetCRS());
        }
        MathTransform transform = operation.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(transform);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, -180.0, -88.21076182660325, -180.0, -88.2107618265547);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 180.0, 85.41283436546335, -180.0, 85.41283436531322);
    }

    @Test
    public void testDatumShift() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NTF (Paris)\",\n  DATUM[\"Nouvelle_Triangulation_Francaise\",\n    SPHEROID[\"Clarke 1880 (IGN)\", 6378249.2, 293.466021293627,\n      AUTHORITY[\"EPSG\",\"7011\"]],\n    TOWGS84[-168,-60,320,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6275\"]],\n  PRIMEM[\"Paris\", 2.5969213, AUTHORITY[\"EPSG\",\"8903\"]],\n  UNIT[\"grad\", 0.015707963267949, AUTHORITY[\"EPSG\", \"9105\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4807\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("GEOGCS[\"WGS84\",\n  DATUM[\"WGS84\",\n    SPHEROID[\"WGS84\", 6378137.0, 298.257223563]],\n  PRIMEM[\"Greenwich\", 0.0],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Longitude\",EAST],  AXIS[\"Latitude\",NORTH]]");
        CoordinateOperation operation = this.opFactory.createOperation(sourceCRS, targetCRS);
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)operation.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)operation.getTargetCRS());
            Assert.assertTrue((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED));
            Assert.assertFalse((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED));
        }
        MathTransform transform = operation.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(transform);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 0.0, 0.0, 2.3367521703619816, 0.0028940088671177986);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 20.0, -10.0, -6.663517606186469, 18.00134508026729);
        Object wkt = sourceCRS.toWKT();
        int start = ((String)wkt).indexOf("TOWGS84");
        Assert.assertTrue((start >= 0 ? 1 : 0) != 0);
        int end = ((String)wkt).indexOf(93, start);
        Assert.assertTrue((end >= 0 ? 1 : 0) != 0);
        int comma = ((String)wkt).indexOf(44, end);
        Assert.assertTrue((comma >= 0 ? 1 : 0) != 0);
        wkt = ((String)wkt).substring(0, start) + ((String)wkt).substring(comma + 1);
        CoordinateReferenceSystem amputedCRS = this.crsFactory.createFromWKT((String)wkt);
        try {
            Assert.assertNotNull((Object)this.opFactory.createOperation(amputedCRS, targetCRS));
            Assert.fail((String)"Operation without Bursa-Wolf parameters should not have been allowed.");
        }
        catch (OperationNotFoundException operationNotFoundException) {
            // empty catch block
        }
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.FALSE);
        CoordinateOperationFactory lenientFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        Assert.assertSame((Object)this.opFactory, (Object)lenientFactory);
        hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        lenientFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        Assert.assertNotSame((Object)this.opFactory, (Object)lenientFactory);
        CoordinateOperation lenient = lenientFactory.createOperation(amputedCRS, targetCRS);
        Assert.assertSame((Object)amputedCRS, (Object)lenient.getSourceCRS());
        Assert.assertSame((Object)targetCRS, (Object)lenient.getTargetCRS());
        Assert.assertFalse((boolean)lenient.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED));
        Assert.assertTrue((boolean)lenient.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED));
        MathTransform lenientTr = lenient.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(lenientTr);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(lenientTr, 0.0, 0.0, 2.33722917, 0.0);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(lenientTr, 20.0, -10.0, -6.66277083, 17.99814879585781);
    }

    @Test
    public void testDatumShift7Param() throws Exception {
        DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("PROJCS[\"IGN53 Mare / UTM zone 58S\",\n  GEOGCS[\"IGN53 Mare\",\n    DATUM[\"IGN53 Mare\",\n      SPHEROID[\"International 1924\", 6378388.0, 297.0, AUTHORITY[\"EPSG\",\"7022\"]],\n      TOWGS84[-408.809, 366.856, -412.987, 1.8842, -0.5308, 2.1655, -24.978523651158998],\n      AUTHORITY[\"EPSG\",\"6641\"]],\n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Geodetic latitude\", NORTH, AUTHORITY[\"EPSG\",\"106\"]],\n    AXIS[\"Geodetic longitude\", EAST, AUTHORITY[\"EPSG\",\"107\"]],\n    AUTHORITY[\"EPSG\",\"4641\"]],\n  PROJECTION[\"Transverse Mercator\", AUTHORITY[\"EPSG\",\"9807\"]],\n  PARAMETER[\"central_meridian\", 165.0],\n  PARAMETER[\"latitude_of_origin\", 0.0],\n  PARAMETER[\"scale_factor\", 0.9996],\n  PARAMETER[\"false_easting\", 500000.0],\n  PARAMETER[\"false_northing\", 10000000.0],\n  UNIT[\"m\", 1.0],\n  AXIS[\"Easting\", EAST, AUTHORITY[\"EPSG\",\"1\"]],\n  AXIS[\"Northing\", NORTH, AUTHORITY[\"EPSG\",\"2\"]],\n  AUTHORITY[\"EPSG\",\"2995\"]]");
        CoordinateOperation operation = this.opFactory.createOperation((CoordinateReferenceSystem)sourceCRS, targetCRS);
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)operation.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)operation.getTargetCRS());
            Assert.assertTrue((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED));
            Assert.assertFalse((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED));
        }
        MathTransform transform = operation.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(transform);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 168.1075, -21.597283333333, 822023.338884308, 7608648.67486555);
        Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
        CoordinateOperationFactory lenientFactory = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)hints);
        Assert.assertNotSame((Object)this.opFactory, (Object)lenientFactory);
        operation = lenientFactory.createOperation((CoordinateReferenceSystem)sourceCRS, targetCRS);
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)operation.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)operation.getTargetCRS());
            Assert.assertTrue((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED));
            Assert.assertFalse((boolean)operation.getCoordinateOperationAccuracy().contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED));
        }
        transform = operation.getMathTransform();
        CoordinateOperationFactoryTest.assertInterfaced(transform);
        CoordinateOperationFactoryTest.assertTransformEquals2_2(transform, 168.1075, -21.597283333333, 822023.338884308, 7608648.67486555);
    }

    @Test
    public void testDMHS() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("GEOGCS[\"WGS 84\",\n  DATUM[\"WGS_1984\",\n    SPHEROID[\"WGS 84\", 6378137, 298.257223563,\n      AUTHORITY[\"EPSG\",\"7030\"]],\n    TOWGS84[0,0,0,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6326\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4326\"]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        Assert.assertTrue((boolean)(op instanceof Transformation));
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        if (this.usingDefaultFactory) {
            CoordinateOperationFactoryTest.assertTransformEquals2_2(mt, 0.0, 0.0, 0.001654978796746043, 0.0012755944235822696);
            CoordinateOperationFactoryTest.assertTransformEquals2_2(mt, 5.0, 8.0, 5.001262960018587, 8.001271733843957);
        }
    }

    @Test
    public void testZIdentity() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertTrue((boolean)(op instanceof Conversion));
        Assert.assertTrue((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
    }

    @Test
    public void testHeightIdentity() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertTrue((boolean)(op instanceof Conversion));
        Assert.assertTrue((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
    }

    @Test(expected=OperationNotFoundException.class)
    public void testIncompatibleVertical() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        Assert.assertNull((Object)op);
    }

    @Test
    public void testGeographic3D() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_Z);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(WGS84_Z);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        Assert.assertNotSame((Object)sourceCRS, (Object)op.getSourceCRS());
        Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        Assert.assertTrue((boolean)(op instanceof Transformation));
        Assert.assertTrue((boolean)(sourceCRS instanceof CompoundCRS));
        Assert.assertTrue((boolean)(op.getSourceCRS() instanceof GeographicCRS));
        Assert.assertTrue((boolean)(targetCRS instanceof CompoundCRS));
        Assert.assertTrue((boolean)(op.getTargetCRS() instanceof GeographicCRS));
        Assert.assertNotEquals((Object)sourceCRS, (Object)targetCRS);
        Assert.assertNotEquals((Object)op.getSourceCRS(), (Object)op.getTargetCRS());
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, 0.0, 0.0, 0.0, 0.001654978796746043, 0.0012755944235822696, 66.4042236590758);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, 5.0, 8.0, 20.0, 5.0012629560319874, 8.001271729856333, 120.27929787151515);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, 5.0, 8.0, -20.0, 5.001262964005206, 8.001271737831601, 80.2792978901416);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, -5.0, -8.0, -20.0, -4.99799698932651, -7.998735783965731, 9.007854541763663);
    }

    @Test
    public void testGeographic3D_ZFirst() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(Z_NAD27);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(WGS84_Z);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        Assert.assertNotSame((Object)sourceCRS, (Object)op.getSourceCRS());
        Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        Assert.assertTrue((boolean)(op instanceof Transformation));
        Assert.assertTrue((boolean)(sourceCRS instanceof CompoundCRS));
        Assert.assertTrue((boolean)(op.getSourceCRS() instanceof GeographicCRS));
        Assert.assertTrue((boolean)(targetCRS instanceof CompoundCRS));
        Assert.assertTrue((boolean)(op.getTargetCRS() instanceof GeographicCRS));
        Assert.assertNotEquals((Object)sourceCRS, (Object)targetCRS);
        Assert.assertNotEquals((Object)op.getSourceCRS(), (Object)op.getTargetCRS());
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, 0.0, 0.0, 0.0, 0.001654978796746043, 0.0012755944235822696, 66.4042236590758);
        CoordinateOperationFactoryTest.assertTransformEquals3_3(mt, -20.0, 5.0, 8.0, 5.001262964005206, 8.001271737831601, 80.2792978901416);
    }

    @Test
    public void test3D_to_2D() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_Z);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("GEOGCS[\"WGS 84\",\n  DATUM[\"WGS_1984\",\n    SPHEROID[\"WGS 84\", 6378137, 298.257223563,\n      AUTHORITY[\"EPSG\",\"7030\"]],\n    TOWGS84[0,0,0,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6326\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4326\"]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertNotSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals3_2(mt, 0.0, 0.0, 0.0, 0.001654978796746043, 0.0012755944235822696);
        CoordinateOperationFactoryTest.assertTransformEquals3_2(mt, 5.0, 8.0, 20.0, 5.0012629560319874, 8.001271729856333);
        CoordinateOperationFactoryTest.assertTransformEquals3_2(mt, 5.0, 8.0, -20.0, 5.001262964005206, 8.001271737831601);
    }

    @Test
    public void test3D_to_Z() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_Z);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("VERT_CS[\"ellipsoid Z in meters\",\n  VERT_DATUM[\"Ellipsoid\",2002],\n  UNIT[\"metre\", 1],\n  AXIS[\"Z\",UP]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, 0.0, 0.0, 0.0, 0.0);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, 5.0, 8.0, 20.0, 20.0);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, -5.0, -8.0, 20.0, 20.0);
    }

    @Test
    public void test2D_to_3D() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(WGS84_Z);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals2_3(mt, 0.0, 0.0, 0.001654978796746043, 0.0012755944235822696, 66.4042236590758);
        CoordinateOperationFactoryTest.assertTransformEquals2_3(mt, 5.0, 8.0, 5.001262960018587, 8.001271733843957, 100.27929787896574);
    }

    @Test(expected=OperationNotFoundException.class)
    public void testHtoZ() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_H);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(NAD27_Z);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        Assert.assertNotSame((Object)sourceCRS, (Object)op.getSourceCRS());
        Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
    }

    @Test(expected=OperationNotFoundException.class)
    public void testHtoH() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_H);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(WGS84_H);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        Assert.assertNotSame((Object)sourceCRS, (Object)op.getSourceCRS());
        Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
    }

    @Test(expected=OperationNotFoundException.class)
    public void test2DtoH() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NAD27\",\n  DATUM[\"North_American_Datum_1927\",\n    SPHEROID[\"Clarke 1866\", 6378206.4, 294.978698213901,\n      AUTHORITY[\"EPSG\",\"7008\"]],\n    TOWGS84[-3,142,183,0,0,0,0],\n    AUTHORITY[\"EPSG\",\"6267\"]],\n  PRIMEM[\"Greenwich\", 0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"DMSH\",0.0174532925199433, AUTHORITY[\"EPSG\",\"9108\"]],\n  AXIS[\"Lat\",NORTH],\n  AXIS[\"Long\",EAST],\n  AUTHORITY[\"EPSG\",\"4267\"]]");
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT(WGS84_H);
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertNotSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
    }

    @Test
    public void test3D_to_H() throws Exception {
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT(NAD27_H);
        CoordinateReferenceSystem targetCRS = this.crsFactory.createFromWKT("VERT_CS[\"mean sea level height\",\n  VERT_DATUM[\"Mean Sea Level\", 2005, AUTHORITY[\"EPSG\",\"5100\"]],\n  UNIT[\"metre\", 1, AUTHORITY[\"EPSG\",\"9001\"]],\n  AXIS[\"Z\",UP], AUTHORITY[\"EPSG\",\"5714\"]]");
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        CoordinateOperationFactoryTest.assertInterfaced(mt);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, 0.0, 0.0, 0.0, 0.0);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, 5.0, 8.0, 20.0, 20.0);
        CoordinateOperationFactoryTest.assertTransformEquals3_1(mt, -5.0, -8.0, 20.0, 20.0);
    }

    @Test
    public void test4D_to_2D() throws Exception {
        CoordinateReferenceSystem targetCRS;
        CoordinateReferenceSystem sourceCRS = targetCRS = this.crsFactory.createFromWKT("PROJCS[\"WGS 84 / World Mercator\",\n  GEOGCS[\"WGS 84\",\n    DATUM[\"World Geodetic System 1984\",\n      SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],\n      AUTHORITY[\"EPSG\",\"6326\"]],\n    PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n    UNIT[\"degree\", 0.017453292519943295],\n    AXIS[\"Geodetic latitude\", NORTH],\n    AXIS[\"Geodetic longitude\", EAST],\n    AUTHORITY[\"EPSG\",\"4326\"]],\n  PROJECTION[\"Mercator (1SP)\", AUTHORITY[\"EPSG\",\"9804\"]],\n  PARAMETER[\"latitude_of_origin\", 0.0],\n  PARAMETER[\"central_meridian\", 0.0],\n  PARAMETER[\"scale_factor\", 1.0],\n  PARAMETER[\"false_easting\", 0.0],\n  PARAMETER[\"false_northing\", 0.0],\n  UNIT[\"m\", 1.0],\n  AXIS[\"Easting\", EAST],\n  AXIS[\"Northing\", NORTH],\n  AUTHORITY[\"EPSG\",\"3395\"]]");
        sourceCRS = new DefaultCompoundCRS("Mercator 3D", new CoordinateReferenceSystem[]{sourceCRS, DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT});
        sourceCRS = new DefaultCompoundCRS("Mercator 4D", new CoordinateReferenceSystem[]{sourceCRS, DefaultTemporalCRS.MODIFIED_JULIAN});
        CoordinateOperation op = this.opFactory.createOperation(sourceCRS, targetCRS);
        MathTransform mt = op.getMathTransform();
        if (this.usingDefaultFactory) {
            Assert.assertSame((Object)sourceCRS, (Object)op.getSourceCRS());
            Assert.assertSame((Object)targetCRS, (Object)op.getTargetCRS());
        }
        Assert.assertFalse((boolean)mt.isIdentity());
        Assert.assertTrue((String)"The somewhat complex MathTransform chain should have been simplified to a single affine transform.", (boolean)(mt instanceof LinearTransform));
        Assert.assertTrue((String)"The operation should be a simple axis change, not a complexchain of ConcatenatedOperations.", (boolean)(op instanceof Conversion));
    }

    @Test
    public void testFindOperations() throws Exception {
        MathTransform transform;
        DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
        CoordinateReferenceSystem sourceCRS = this.crsFactory.createFromWKT("GEOGCS[\"NAD83\",\n  DATUM[\"North_American_Datum_1983\",\n    SPHEROID[\"GRS 1980\", 6378137.0, 298.257222101,\n      AUTHORITY[\"EPSG\",\"7019\"]],\n    TOWGS84[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],\n    AUTHORITY[\"EPSG\",\"6269\"]],\n  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],\n  UNIT[\"degree\", 0.017453292519943295],\n  AXIS[\"Lon\", EAST],\n  AXIS[\"Lat\", NORTH],\n  AUTHORITY[\"EPSG\",\"4269\"]]");
        Set operations = this.opFactory.findOperations(sourceCRS, (CoordinateReferenceSystem)targetCRS);
        int size = operations.size();
        for (CoordinateOperation operation : operations) {
            if (this.usingDefaultFactory) {
                Assert.assertSame((Object)sourceCRS, (Object)operation.getSourceCRS());
                Assert.assertSame((Object)targetCRS, (Object)operation.getTargetCRS());
            }
            transform = operation.getMathTransform();
            CoordinateOperationFactoryTest.assertInterfaced(transform);
        }
        operations = this.opFactory.findOperations((CoordinateReferenceSystem)targetCRS, sourceCRS);
        Assert.assertEquals((long)size, (long)operations.size());
        for (CoordinateOperation operation : operations) {
            if (this.usingDefaultFactory) {
                Assert.assertSame((Object)targetCRS, (Object)operation.getSourceCRS());
                Assert.assertSame((Object)sourceCRS, (Object)operation.getTargetCRS());
            }
            transform = operation.getMathTransform();
            TransformTestBase.assertInterfaced(transform);
        }
    }
}

