/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.factory.DatumAliases;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.ReferencingObjectFactory;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.GenericName;
import org.opengis.util.ScopedName;
import si.uom.NonSI;
import si.uom.SI;

public final class FactoriesTest {
    private static PrintStream out = System.out;

    private static Map<String, ?> name(String name) {
        return Collections.singletonMap("name", name);
    }

    @Test
    public void testCreation() throws FactoryException {
        out.println();
        out.println("Testing CRS creations");
        out.println("---------------------");
        out.println();
        out.println("create Coodinate Reference System....1: ");
        DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(null);
        CSFactory csFactory = ReferencingFactoryFinder.getCSFactory(null);
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        Unit meters = SI.METRE;
        Ellipsoid airy1830 = datumFactory.createEllipsoid(FactoriesTest.name("Airy1830"), 6377563.396, 6356256.91, meters);
        out.println();
        out.println("create Coodinate Reference System....2: ");
        out.println(airy1830.toWKT());
        Unit degrees = NonSI.DEGREE_ANGLE;
        PrimeMeridian greenwich = datumFactory.createPrimeMeridian(FactoriesTest.name("Greenwich"), 0.0, degrees);
        out.println();
        out.println("create Coodinate Reference System....3: ");
        out.println(greenwich.toWKT());
        GeodeticDatum datum = datumFactory.createGeodeticDatum(FactoriesTest.name("Airy1830"), airy1830, greenwich);
        out.println();
        out.println("create Coodinate Reference System....4: ");
        out.println(datum.toWKT());
        EllipsoidalCS ellCS = csFactory.createEllipsoidalCS(FactoriesTest.name("Ellipsoidal"), csFactory.createCoordinateSystemAxis(FactoriesTest.name("Longitude"), "long", AxisDirection.EAST, degrees), csFactory.createCoordinateSystemAxis(FactoriesTest.name("Latitude"), "lat", AxisDirection.NORTH, degrees));
        out.println();
        out.println("create Coodinate Reference System....5: ");
        out.println(ellCS);
        GeographicCRS geogCRS = crsFactory.createGeographicCRS(FactoriesTest.name("Airy1830"), datum, ellCS);
        out.println();
        out.println("create Coodinate Reference System....6: ");
        out.println(geogCRS.toWKT());
        ParameterValueGroup param = mtFactory.getDefaultParameters("Transverse_Mercator");
        param.parameter("semi_major").setValue(airy1830.getSemiMajorAxis());
        param.parameter("semi_minor").setValue(airy1830.getSemiMinorAxis());
        param.parameter("central_meridian").setValue(49);
        param.parameter("latitude_of_origin").setValue(-2);
        param.parameter("false_easting").setValue(400000);
        param.parameter("false_northing").setValue(-100000);
        out.println();
        out.println("create Coodinate System....7: ");
        out.println(param);
        CartesianCS cartCS = csFactory.createCartesianCS(FactoriesTest.name("Cartesian"), csFactory.createCoordinateSystemAxis(FactoriesTest.name("Easting"), "x", AxisDirection.EAST, meters), csFactory.createCoordinateSystemAxis(FactoriesTest.name("Northing"), "y", AxisDirection.NORTH, meters));
        out.println();
        out.println("create Coodinate Reference System....8: ");
        out.println(cartCS);
        Hints hints = new Hints();
        hints.put((Object)Hints.DATUM_FACTORY, (Object)datumFactory);
        hints.put((Object)Hints.CS_FACTORY, (Object)csFactory);
        hints.put((Object)Hints.CRS_FACTORY, (Object)crsFactory);
        hints.put((Object)Hints.MATH_TRANSFORM_FACTORY, (Object)mtFactory);
        ReferencingFactoryContainer container = new ReferencingFactoryContainer(hints);
        Assert.assertSame((Object)datumFactory, (Object)container.getDatumFactory());
        Assert.assertSame((Object)csFactory, (Object)container.getCSFactory());
        Assert.assertSame((Object)crsFactory, (Object)container.getCRSFactory());
        Assert.assertSame((Object)mtFactory, (Object)container.getMathTransformFactory());
        DefiningConversion conversion = new DefiningConversion("GBN grid", param);
        ProjectedCRS projCRS = crsFactory.createProjectedCRS(FactoriesTest.name("Great_Britian_National_Grid"), geogCRS, (Conversion)conversion, cartCS);
        out.println();
        out.println("create Coodinate System....9: ");
        out.println(projCRS.toWKT());
    }

    @Test
    public void testMapProjections() throws FactoryException {
        out.println();
        out.println("Testing classification names");
        out.println("----------------------------");
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        Set methods = mtFactory.getAvailableMethods(Projection.class);
        Map<String, String> dummyName = Collections.singletonMap("name", "Test");
        for (OperationMethod method : methods) {
            boolean skip;
            MathTransform mt;
            String classification = method.getName().getCode();
            ParameterValueGroup param = mtFactory.getDefaultParameters(classification);
            try {
                param.parameter("semi_major").setValue(6377563.396);
                param.parameter("semi_minor").setValue(6356256.909237285);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                mt = mtFactory.createParameterizedTransform(param);
            }
            catch (UnsupportedOperationException | FactoryException e) {
                continue;
            }
            if (!(mt instanceof MapProjection)) continue;
            out.println(classification);
            boolean bl = skip = classification.equalsIgnoreCase("Transverse Mercator (South Orientated)") || classification.equalsIgnoreCase("Equidistant_Cylindrical") || classification.equalsIgnoreCase("Behrmann") || classification.equalsIgnoreCase("Lambert Cylindrical Equal Area (Spherical)");
            if (!skip) {
                Assert.assertEquals((Object)classification, (Object)((MapProjection)mt).getParameterDescriptors().getName().getCode());
            }
            ProjectedCRS projCRS = crsFactory.createProjectedCRS(dummyName, (GeographicCRS)DefaultGeographicCRS.WGS84, (Conversion)new DefiningConversion(dummyName, method, mt), (CartesianCS)DefaultCartesianCS.PROJECTED);
            Projection conversion = projCRS.getConversionFromBase();
            Assert.assertSame((Object)mt, (Object)conversion.getMathTransform());
            OperationMethod projMethod = conversion.getMethod();
            Assert.assertEquals((Object)classification, (Object)projMethod.getName().getCode());
        }
    }

    @Test
    public void testDatumAliases() throws FactoryException {
        String name0 = "Nouvelle Triangulation Francaise (Paris)";
        String name1 = "Nouvelle_Triangulation_Francaise_Paris";
        String name2 = "D_NTF";
        String name3 = "NTF (Paris meridian)";
        DefaultEllipsoid ellipsoid = DefaultEllipsoid.WGS84;
        DefaultPrimeMeridian meridian = DefaultPrimeMeridian.GREENWICH;
        ReferencingObjectFactory factory = new ReferencingObjectFactory();
        Map<String, String> properties = Collections.singletonMap("name", "Nouvelle_Triangulation_Francaise_Paris");
        GeodeticDatum datum = factory.createGeodeticDatum(properties, (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertTrue((boolean)datum.getAlias().isEmpty());
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    factory = new DatumAliases((DatumFactory)factory);
                    break;
                }
                case 1: {
                    factory = ReferencingFactoryFinder.getDatumFactory(null);
                    break;
                }
                case 2: {
                    ((DatumAliases)factory).freeUnused();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            String pass = "Pass #" + i;
            datum = factory.createGeodeticDatum(properties, (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
            GenericName[] aliases = datum.getAlias().toArray(new GenericName[0]);
            Assert.assertEquals((String)pass, (long)4L, (long)aliases.length);
            Assert.assertEquals((String)pass, (Object)"Nouvelle Triangulation Francaise (Paris)", (Object)aliases[0].tip().toString());
            Assert.assertEquals((String)pass, (Object)"Nouvelle_Triangulation_Francaise_Paris", (Object)aliases[1].tip().toString());
            Assert.assertEquals((String)pass, (Object)"D_NTF", (Object)aliases[2].tip().toString());
            Assert.assertEquals((String)pass, (Object)"NTF (Paris meridian)", (Object)aliases[3].tip().toString());
            Assert.assertTrue((String)pass, (boolean)(aliases[0] instanceof ScopedName));
            Assert.assertTrue((String)pass, (boolean)(aliases[1] instanceof ScopedName));
            Assert.assertTrue((String)pass, (boolean)(aliases[2] instanceof ScopedName));
            Assert.assertTrue((String)pass, (boolean)(aliases[3] instanceof ScopedName));
        }
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "Tokyo"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Collection aliases = datum.getAlias();
        Assert.assertEquals((long)4L, (long)aliases.size());
        ((DatumAliases)factory).freeUnused();
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "_toKyo  _"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertEquals((long)4L, (long)datum.getAlias().size());
        Assert.assertEquals((Object)aliases, (Object)datum.getAlias());
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "D_Tokyo"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertEquals((long)4L, (long)datum.getAlias().size());
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "Luxembourg 1930"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertEquals((long)3L, (long)datum.getAlias().size());
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "Dummy"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertTrue((String)"Non existing datum should have no alias.", (boolean)datum.getAlias().isEmpty());
        datum = factory.createGeodeticDatum(Collections.singletonMap("name", "WGS 84"), (Ellipsoid)ellipsoid, (PrimeMeridian)meridian);
        Assert.assertTrue((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)datum, (String)"WGS 84"));
        Assert.assertTrue((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)datum, (String)"WGS_1984"));
        Assert.assertTrue((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)datum, (String)"World Geodetic System 1984"));
        Assert.assertFalse((boolean)AbstractIdentifiedObject.nameMatches((IdentifiedObject)datum, (String)"WGS 72"));
    }
}

