/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.MatrixParameterDescriptors;
import org.geotools.parameter.MatrixParameters;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.parameter.ParameterWriter;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.CodeList;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public final class ParametersTest {
    @Test
    public void testSequence() {
        for (int i = -1000; i <= 1000; ++i) {
            Assert.assertEquals((String)"new (Integer, ...)", (long)i, (long)Parameter.create((String)"Integer", (int)i).intValue());
            Assert.assertEquals((String)"new (Double, ...)", (double)i, (double)Parameter.create((String)"Double", (double)i, null).doubleValue(), (double)0.0);
            Assert.assertEquals((String)"new (Double, ...)", (double)i, (double)Parameter.create((String)"Double", (double)i, (Unit)AbstractUnit.ONE).doubleValue(), (double)0.0);
            Assert.assertEquals((String)"new (Double, ...)", (double)Math.toRadians(i), (double)Parameter.create((String)"Double", (double)i, (Unit)NonSI.DEGREE_ANGLE).doubleValue(SI.RADIAN), (double)1.0E-6);
        }
    }

    @Test
    public void testRangeIntegers() {
        Parameter param = new Parameter((ParameterDescriptor)DefaultParameterDescriptor.create((String)"Range", (int)15, (int)-30, (int)40));
        Assert.assertEquals((String)"intValue", (long)15L, (long)param.intValue());
        Assert.assertEquals((String)"doubleValue", (double)15.0, (double)param.doubleValue(), (double)0.0);
        param.setValue(12);
        Assert.assertEquals((String)"intValue", (long)12L, (long)param.intValue());
        Assert.assertEquals((String)"doubleValue", (double)12.0, (double)param.doubleValue(), (double)0.0);
        try {
            param.setValue(50);
            Assert.fail((String)"setValue(> max)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        try {
            param.setValue(-40);
            Assert.fail((String)"setValue(< min)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        try {
            param.setValue(10.0);
            Assert.fail((String)"setValue(double)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        Assert.assertEquals((String)"Clone not equals: ", (Object)param, (Object)param.clone());
    }

    @Test
    public void testRangeDoubles() {
        Parameter param = new Parameter((ParameterDescriptor)DefaultParameterDescriptor.create((String)"Range", (double)15.0, (double)-30.0, (double)40.0, null));
        Assert.assertEquals((String)"intValue", (long)15L, (long)param.intValue());
        Assert.assertEquals((String)"doubleValue", (double)15.0, (double)param.doubleValue(), (double)0.0);
        param.setValue(12.0);
        Assert.assertEquals((String)"intValue", (long)12L, (long)param.intValue());
        Assert.assertEquals((String)"doubleValue", (double)12.0, (double)param.doubleValue(), (double)0.0);
        try {
            param.setValue(50.0);
            Assert.fail((String)"setValue(> max)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        try {
            param.setValue(-40.0);
            Assert.fail((String)"setValue(< min)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        try {
            param.setValue((Object)"12");
            Assert.fail((String)"setValue(String)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Range", (Object)exception.getParameterName());
        }
        Assert.assertEquals((String)"equals(clone)", (Object)param, (Object)param.clone());
    }

    @Test
    public void testCodeList() {
        Parameter param = Parameter.create((String)"Test", AxisDirection.class, (CodeList)AxisDirection.DISPLAY_UP);
        ParameterDescriptor op = param.getDescriptor();
        Assert.assertEquals((String)"Set<AxisDirection>", new HashSet<AxisDirection>(Arrays.asList(AxisDirection.values())), (Object)op.getValidValues());
        Assert.assertNull((String)"defaultValue", (Object)op.getDefaultValue());
        param.setValue((Object)AxisDirection.DOWN);
        try {
            param.setValue((Object)VerticalDatumType.ELLIPSOIDAL);
            Assert.fail((String)"setValue(VerticalDatumType)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        AxisDirection dummy = AxisDirection.valueOf((String)"Dummy");
        try {
            param.setValue((Object)dummy);
            Assert.fail((String)"setValue(AxisDirection)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        param = Parameter.create((String)"Test", AxisDirection.class, (CodeList)AxisDirection.DISPLAY_UP);
        param.setValue((Object)dummy);
        Assert.assertEquals((String)"equals(clone)", (Object)param, (Object)param.clone());
    }

    @Test
    public void testParameterDescriptor() {
        DefaultParameterDescriptor dDescriptor = DefaultParameterDescriptor.create((String)"Test", (double)12.0, (double)4.0, (double)20.0, (Unit)SI.METRE);
        ParameterValue parameter = dDescriptor.createValue();
        Assert.assertEquals((String)"name", (Object)"Test", (Object)dDescriptor.getName().getCode());
        Assert.assertEquals((String)"unit", (Object)SI.METRE, (Object)dDescriptor.getUnit());
        Assert.assertEquals((String)"class", Double.class, (Object)dDescriptor.getValueClass());
        Assert.assertEquals((String)"defaultValue", (double)12.0, (double)((Double)dDescriptor.getDefaultValue()), (double)0.0);
        Assert.assertEquals((String)"minimum", (Object)4.0, (Object)dDescriptor.getMinimumValue());
        Assert.assertEquals((String)"maximum", (Object)20.0, (Object)dDescriptor.getMaximumValue());
        Assert.assertEquals((String)"value", (long)12L, (long)parameter.intValue());
        Assert.assertEquals((String)"unit", (Object)SI.METRE, (Object)parameter.getUnit());
        for (int i = 4; i <= 20; ++i) {
            parameter.setValue(i);
            Assert.assertEquals((String)"value", (Object)i, (Object)parameter.getValue());
            Assert.assertEquals((String)"unit", (Object)SI.METRE, (Object)parameter.getUnit());
            Assert.assertEquals((String)"value", (double)i, (double)parameter.doubleValue(SI.METRE), (double)0.0);
        }
        try {
            parameter.setValue(3.0);
            Assert.fail((String)"setValue(< min)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        try {
            parameter.setValue((Object)"12");
            Assert.fail((String)"setValue(Sring)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        for (int i = 400; i <= 2000; i += 100) {
            parameter.setValue((double)i, MetricPrefix.CENTI((Unit)SI.METRE));
            Assert.assertEquals((String)"value", (Object)i, (Object)parameter.getValue());
            Assert.assertEquals((String)"unit", (Object)MetricPrefix.CENTI((Unit)SI.METRE), (Object)parameter.getUnit());
            Assert.assertEquals((String)"value", (double)(i / 100), (double)parameter.doubleValue(SI.METRE), (double)0.0);
        }
        try {
            DefaultParameterDescriptor.create((String)"Test", (int)3, (int)4, (int)20);
            Assert.fail((String)"setValue(< min)");
        }
        catch (InvalidParameterValueException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        try {
            DefaultParameterDescriptor.create((String)"Test", (int)12, (int)20, (int)4);
            Assert.fail((String)"ParameterDescriptor(min > max)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParameterValue() throws IOException, ClassNotFoundException {
        Parameter parameter = Parameter.create((String)"Test", (int)14);
        ParameterDescriptor descriptor = parameter.getDescriptor();
        Assert.assertNull((String)"unit", (Object)parameter.getUnit());
        Assert.assertEquals((String)"intValue", (long)14L, (long)parameter.intValue());
        Assert.assertEquals((String)"doubleValue", (double)14.0, (double)parameter.doubleValue(), (double)0.0);
        Assert.assertEquals((String)"type", Integer.class, (Object)descriptor.getValueClass());
        Assert.assertEquals((String)"name", (Object)"Test", (Object)descriptor.getName().getCode());
        Assert.assertEquals((String)"defaultValue", (Object)0, (Object)descriptor.getDefaultValue());
        Assert.assertNull((String)"minimum", (Object)descriptor.getMinimumValue());
        Assert.assertNull((String)"maximum", (Object)descriptor.getMaximumValue());
        Assert.assertNull((String)"unit", (Object)descriptor.getUnit());
        Assert.assertNull((String)"validValues", (Object)descriptor.getValidValues());
        try {
            parameter.doubleValue(SI.METRE);
            Assert.fail((String)"doubleValue(METER)");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            parameter.stringValue();
            Assert.fail((String)"stringValue()");
        }
        catch (InvalidParameterTypeException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        ParametersTest.serialize(parameter);
        parameter = Parameter.create((String)"Test", (double)3.0, (Unit)SI.METRE);
        descriptor = parameter.getDescriptor();
        Assert.assertEquals((String)"intValue", (long)3L, (long)parameter.intValue());
        Assert.assertEquals((String)"doubleValue", (double)3.0, (double)parameter.doubleValue(), (double)0.0);
        Assert.assertEquals((String)"doubleValue", (double)300.0, (double)parameter.doubleValue(MetricPrefix.CENTI((Unit)SI.METRE)), (double)0.0);
        Assert.assertEquals((String)"name", (Object)"Test", (Object)descriptor.getName().getCode());
        Assert.assertEquals((String)"unit", (Object)SI.METRE, (Object)descriptor.getUnit());
        Assert.assertNull((String)"defaultValue", (Object)descriptor.getDefaultValue());
        Assert.assertNull((String)"minimum", (Object)descriptor.getMinimumValue());
        Assert.assertNull((String)"maximum", (Object)descriptor.getMaximumValue());
        Assert.assertNull((String)"validValues", (Object)descriptor.getValidValues());
        try {
            parameter.stringValue();
            Assert.fail((String)"stringValue()");
        }
        catch (InvalidParameterTypeException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        ParametersTest.serialize(parameter);
        parameter = Parameter.create((String)"Test", AxisDirection.class, (CodeList)AxisDirection.NORTH);
        descriptor = parameter.getDescriptor();
        Set validValues = descriptor.getValidValues();
        Assert.assertEquals((String)"value", (Object)AxisDirection.NORTH, (Object)parameter.getValue());
        Assert.assertEquals((String)"name", (Object)"Test", (Object)descriptor.getName().getCode());
        Assert.assertNull((String)"unit", (Object)descriptor.getUnit());
        Assert.assertNull((String)"defaultValue", (Object)descriptor.getDefaultValue());
        Assert.assertNull((String)"minimum", (Object)descriptor.getMinimumValue());
        Assert.assertNull((String)"maximum", (Object)descriptor.getMaximumValue());
        Assert.assertTrue((String)"validValues", (boolean)validValues.contains(AxisDirection.NORTH));
        Assert.assertTrue((String)"validValues", (boolean)validValues.contains(AxisDirection.SOUTH));
        Assert.assertTrue((String)"validValues", (boolean)validValues.contains(AxisDirection.DISPLAY_LEFT));
        Assert.assertTrue((String)"validValues", (boolean)validValues.contains(AxisDirection.PAST));
        Assert.assertEquals((String)"validValues", new HashSet<AxisDirection>(Arrays.asList(AxisDirection.values())), (Object)validValues);
        try {
            parameter.doubleValue();
            Assert.fail((String)"doubleValue should not be allowed on AxisDirection");
        }
        catch (InvalidParameterTypeException exception) {
            Assert.assertEquals((Object)"Test", (Object)exception.getParameterName());
        }
        ParametersTest.serialize(parameter);
    }

    @Test
    public void testGroup() throws IOException {
        ParameterWriter writer = new ParameterWriter((Writer)new StringWriter());
        Integer ONE = 1;
        DefaultParameterDescriptor p1 = new DefaultParameterDescriptor(Collections.singletonMap("name", "1"), Integer.class, null, (Object)ONE, null, null, null, true);
        DefaultParameterDescriptor p2 = new DefaultParameterDescriptor(Collections.singletonMap("name", "2"), Integer.class, null, (Object)ONE, null, null, null, true);
        DefaultParameterDescriptor p3 = new DefaultParameterDescriptor(Collections.singletonMap("name", "3"), Integer.class, null, (Object)ONE, null, null, null, false);
        DefaultParameterDescriptor<Integer> p4 = new DefaultParameterDescriptor<Integer>(Collections.singletonMap("name", "4"), Integer.class, null, ONE, null, null, null, false){

            public int getMaximumOccurs() {
                return 2;
            }
        };
        Parameter v1 = new Parameter((ParameterDescriptor)p1);
        v1.setValue(10);
        Parameter v2 = new Parameter((ParameterDescriptor)p2);
        v2.setValue(20);
        Parameter v3 = new Parameter((ParameterDescriptor)p3);
        v3.setValue(30);
        Parameter v4 = new Parameter((ParameterDescriptor)p4);
        v4.setValue(40);
        Parameter v1b = new Parameter((ParameterDescriptor)p1);
        v1b.setValue(-10);
        Parameter v2b = new Parameter((ParameterDescriptor)p2);
        v2b.setValue(-20);
        Parameter v3b = new Parameter((ParameterDescriptor)p3);
        v3b.setValue(-30);
        Parameter v4b = new Parameter((ParameterDescriptor)p4);
        v4b.setValue(-40);
        Map<String, String> properties = Collections.singletonMap("name", "group");
        ParameterGroup group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v2, v3});
        ParameterDescriptorGroup descriptor = group.getDescriptor();
        List content = descriptor.descriptors();
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"name", (Object)"group", (Object)descriptor.getName().getCode());
        Assert.assertEquals((String)"descriptors", (long)3L, (long)content.size());
        Assert.assertTrue((String)"contains(p1)", (boolean)content.contains(p1));
        Assert.assertTrue((String)"contains(p2)", (boolean)content.contains(p2));
        Assert.assertTrue((String)"contains(p3)", (boolean)content.contains(p3));
        Assert.assertFalse((String)"contains(p4)", (boolean)content.contains(p4));
        Assert.assertSame((String)"descriptor(\"1\")", (Object)p1, (Object)descriptor.descriptor("1"));
        Assert.assertSame((String)"descriptor(\"2\")", (Object)p2, (Object)descriptor.descriptor("2"));
        Assert.assertSame((String)"descriptor(\"3\")", (Object)p3, (Object)descriptor.descriptor("3"));
        content = group.values();
        Assert.assertEquals((String)"values.size()", (long)3L, (long)content.size());
        Assert.assertTrue((String)"contains(v1)", (boolean)content.contains(v1));
        Assert.assertTrue((String)"contains(v2)", (boolean)content.contains(v2));
        Assert.assertTrue((String)"contains(v3)", (boolean)content.contains(v3));
        Assert.assertFalse((String)"contains(v4)", (boolean)content.contains(v4));
        Assert.assertFalse((String)"contains(v1b)", (boolean)content.contains(v1b));
        Assert.assertFalse((String)"contains(v2b)", (boolean)content.contains(v2b));
        Assert.assertFalse((String)"contains(v3b)", (boolean)content.contains(v3b));
        Assert.assertSame((String)"parameter(\"1\")", (Object)v1, (Object)group.parameter("1"));
        Assert.assertSame((String)"parameter(\"2\")", (Object)v2, (Object)group.parameter("2"));
        Assert.assertSame((String)"parameter(\"3\")", (Object)v3, (Object)group.parameter("3"));
        Assert.assertEquals((String)"parameter(\"1\")", (long)10L, (long)group.parameter("1").intValue());
        Assert.assertEquals((String)"parameter(\"2\")", (long)20L, (long)group.parameter("2").intValue());
        Assert.assertEquals((String)"parameter(\"3\")", (long)30L, (long)group.parameter("3").intValue());
        Assert.assertFalse((String)"remove(v1b)", (boolean)content.remove(v1b));
        try {
            Assert.assertTrue((boolean)content.remove(v1));
            Assert.fail((String)"v1 is a mandatory parameter; it should not be removeable.");
        }
        catch (InvalidParameterCardinalityException e) {
            Assert.assertEquals((Object)"1", (Object)e.getParameterName());
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            Assert.assertTrue((boolean)content.add(v4));
            Assert.fail((String)"v4 is not a parameter for this group.");
        }
        catch (InvalidParameterNameException e) {
            Assert.assertEquals((Object)"4", (Object)e.getParameterName());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertTrue((String)"add(v1b)", (boolean)content.add(v1b));
        Assert.assertTrue((String)"add(v2b)", (boolean)content.add(v2b));
        Assert.assertTrue((String)"add(v3b)", (boolean)content.add(v3b));
        Assert.assertFalse((String)"add(v1b)", (boolean)content.add(v1b));
        Assert.assertFalse((String)"add(v2b)", (boolean)content.add(v2b));
        Assert.assertFalse((String)"add(v3b)", (boolean)content.add(v3b));
        Assert.assertEquals((String)"parameter(\"1b\")", (long)-10L, (long)group.parameter("1").intValue());
        Assert.assertEquals((String)"parameter(\"2b\")", (long)-20L, (long)group.parameter("2").intValue());
        Assert.assertEquals((String)"parameter(\"3b\")", (long)-30L, (long)group.parameter("3").intValue());
        Assert.assertEquals((String)"values.size()", (long)3L, (long)content.size());
        ParameterGroup parameterGroup = group;
        group = new ParameterGroup(descriptor, (GeneralParameterValue[])new Parameter[]{v1b, v2b, v3b});
        Assert.assertEquals((String)"new", (Object)parameterGroup, (Object)group);
        group = new ParameterGroup(descriptor, (GeneralParameterValue[])new Parameter[]{v1, v2});
        descriptor = group.getDescriptor();
        content = group.values();
        Parameter automatic = (Parameter)v3.getDescriptor().createValue();
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"values.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"contains(v1)", (boolean)content.contains(v1));
        Assert.assertTrue((String)"contains(v2)", (boolean)content.contains(v2));
        Assert.assertFalse((String)"contains(v3)", (boolean)content.contains(v3));
        Assert.assertFalse((String)"contains(v4)", (boolean)content.contains(v4));
        Assert.assertFalse((String)"contains(v1b)", (boolean)content.contains(v1b));
        Assert.assertFalse((String)"contains(v2b)", (boolean)content.contains(v2b));
        Assert.assertFalse((String)"contains(v3b)", (boolean)content.contains(v3b));
        Assert.assertSame((String)"parameter(\"1\")", (Object)v1, (Object)group.parameter("1"));
        Assert.assertSame((String)"parameter(\"2\")", (Object)v2, (Object)group.parameter("2"));
        Assert.assertFalse((String)"contains(automatic)", (boolean)content.contains(automatic));
        ParametersTest.assertNotEquals("parameter(\"3\")", v3, group.parameter("3"));
        Assert.assertTrue((String)"contains(automatic)", (boolean)content.contains(automatic));
        try {
            Assert.assertNotNull((Object)group.parameter("4"));
            Assert.fail((String)"v4 parameter should not be allowed in this group.");
        }
        catch (ParameterNotFoundException e) {
            Assert.assertEquals((Object)"4", (Object)e.getParameterName());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertFalse((String)"remove(v1b)", (boolean)content.remove(v1b));
        Assert.assertEquals((String)"values.size()", (long)3L, (long)content.size());
        Assert.assertFalse((String)"remove(v3)", (boolean)content.remove(v3));
        Assert.assertEquals((String)"values.size()", (long)3L, (long)content.size());
        Assert.assertTrue((String)"remove(auto)", (boolean)content.remove(automatic));
        Assert.assertEquals((String)"values.size()", (long)2L, (long)content.size());
        try {
            Assert.assertTrue((boolean)content.remove(v1));
            Assert.fail((String)"v1 is a mandatory parameter; it should not be removeable.");
        }
        catch (InvalidParameterCardinalityException e) {
            Assert.assertEquals((Object)"1", (Object)e.getParameterName());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertEquals((String)"values.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"add(v1b)", (boolean)content.add(v1b));
        Assert.assertTrue((String)"add(v2b)", (boolean)content.add(v2b));
        Assert.assertTrue((String)"add(v3b)", (boolean)content.add(v3b));
        Assert.assertFalse((String)"add(v1b)", (boolean)content.add(v1b));
        Assert.assertFalse((String)"add(v2b)", (boolean)content.add(v2b));
        Assert.assertFalse((String)"add(v3b)", (boolean)content.add(v3b));
        Assert.assertEquals((String)"parameter(\"1b\")", (long)-10L, (long)group.parameter("1").intValue());
        Assert.assertEquals((String)"parameter(\"2b\")", (long)-20L, (long)group.parameter("2").intValue());
        Assert.assertEquals((String)"parameter(\"3b\")", (long)-30L, (long)group.parameter("3").intValue());
        Assert.assertEquals((String)"values.size()", (long)3L, (long)content.size());
        try {
            group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v3, v4, v3b});
            Assert.fail((String)"Adding two 'v3' value should not be allowed");
        }
        catch (InvalidParameterCardinalityException e) {
            Assert.assertEquals((Object)"3", (Object)e.getParameterName());
            Assert.assertNotNull((Object)e.getMessage());
        }
        group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v4, v3, v4b});
        descriptor = group.getDescriptor();
        content = group.values();
        automatic = (Parameter)v3.getDescriptor().createValue();
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"values.size()", (long)4L, (long)content.size());
        Assert.assertTrue((String)"contains(v1)", (boolean)content.contains(v1));
        Assert.assertFalse((String)"contains(v2)", (boolean)content.contains(v2));
        Assert.assertTrue((String)"contains(v3)", (boolean)content.contains(v3));
        Assert.assertTrue((String)"contains(v4)", (boolean)content.contains(v4));
        Assert.assertFalse((String)"contains(v1b)", (boolean)content.contains(v1b));
        Assert.assertFalse((String)"contains(v2b)", (boolean)content.contains(v2b));
        Assert.assertFalse((String)"contains(v3b)", (boolean)content.contains(v3b));
        Assert.assertTrue((String)"contains(v4b)", (boolean)content.contains(v4b));
        Assert.assertSame((String)"parameter(\"1\")", (Object)v1, (Object)group.parameter("1"));
        Assert.assertSame((String)"parameter(\"3\")", (Object)v3, (Object)group.parameter("3"));
        Assert.assertSame((String)"parameter(\"4\")", (Object)v4, (Object)group.parameter("4"));
        Assert.assertTrue((String)"remove(v3)", (boolean)content.remove(v3));
        Assert.assertFalse((String)"contains(automatic)", (boolean)content.contains(automatic));
        ParametersTest.assertNotEquals("parameter(\"3\")", v3, group.parameter("3"));
        Assert.assertTrue((String)"contains(automatic)", (boolean)content.contains(automatic));
        try {
            new ParameterGroup(descriptor, (GeneralParameterValue[])new Parameter[]{v4, v3});
            Assert.fail((String)"Parameter 1 was mandatory.");
        }
        catch (InvalidParameterCardinalityException exception) {
            Assert.assertEquals((Object)"1", (Object)exception.getParameterName());
        }
        try {
            new ParameterGroup(descriptor, (GeneralParameterValue[])new Parameter[]{v1, v4, v3, v3b});
            Assert.fail((String)"Parameter 3 was not allowed to be inserted twice.");
        }
        catch (InvalidParameterCardinalityException exception) {
            Assert.assertEquals((Object)"3", (Object)exception.getParameterName());
        }
        try {
            new ParameterGroup(descriptor, (GeneralParameterValue[])new Parameter[]{v1, v3, v1b});
            Assert.fail((String)"Parameter 1 was not allowed to be inserted twice.");
        }
        catch (InvalidParameterCardinalityException exception) {
            Assert.assertEquals((Object)"1", (Object)exception.getParameterName());
        }
        group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v2});
        descriptor = group.getDescriptor();
        content = descriptor.descriptors();
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"name", (Object)"group", (Object)descriptor.getName().getCode());
        Assert.assertEquals((String)"descriptors.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"contains(p1)", (boolean)content.contains(p1));
        Assert.assertTrue((String)"contains(p2)", (boolean)content.contains(p2));
        Assert.assertFalse((String)"contains(p3)", (boolean)content.contains(p3));
        Assert.assertSame((String)"descriptor(\"1\")", (Object)p1, (Object)descriptor.descriptor("1"));
        Assert.assertSame((String)"descriptor(\"2\")", (Object)p2, (Object)descriptor.descriptor("2"));
        try {
            Assert.assertSame((String)"p3", (Object)p3, (Object)descriptor.descriptor("3"));
            Assert.fail((String)"p3 should not exists.");
        }
        catch (ParameterNotFoundException e) {
            Assert.assertEquals((Object)"3", (Object)e.getParameterName());
        }
        content = group.values();
        Assert.assertEquals((String)"values.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"contains(v1)", (boolean)content.contains(v1));
        Assert.assertTrue((String)"contains(v2)", (boolean)content.contains(v2));
        Assert.assertFalse((String)"contains(v3)", (boolean)content.contains(v3));
        Assert.assertFalse((String)"contains(v1b)", (boolean)content.contains(v1b));
        Assert.assertFalse((String)"contains(v2b)", (boolean)content.contains(v2b));
        Assert.assertFalse((String)"contains(v3b)", (boolean)content.contains(v3b));
        Assert.assertSame((String)"parameter(\"1\")", (Object)v1, (Object)group.parameter("1"));
        Assert.assertSame((String)"parameter(\"2\")", (Object)v2, (Object)group.parameter("2"));
        try {
            Assert.assertSame((String)"parameter(\"3\")", (Object)v3, (Object)group.parameter("3"));
            Assert.fail((String)"v3 should not exists");
        }
        catch (ParameterNotFoundException e) {
            Assert.assertEquals((Object)"3", (Object)e.getParameterName());
        }
        group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v3});
        descriptor = group.getDescriptor();
        content = descriptor.descriptors();
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"name", (Object)"group", (Object)descriptor.getName().getCode());
        Assert.assertEquals((String)"descriptors.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"contains(p1)", (boolean)content.contains(p1));
        Assert.assertFalse((String)"contains(p2)", (boolean)content.contains(p2));
        Assert.assertTrue((String)"contains(p3)", (boolean)content.contains(p3));
        Assert.assertSame((String)"descriptor(\"1\")", (Object)p1, (Object)descriptor.descriptor("1"));
        Assert.assertSame((String)"descriptor(\"3\")", (Object)p3, (Object)descriptor.descriptor("3"));
        try {
            Assert.assertSame((String)"descriptor(\"2\")", (Object)p2, (Object)descriptor.descriptor("2"));
            Assert.fail((String)"p2 should not exists");
        }
        catch (ParameterNotFoundException e) {
            Assert.assertEquals((Object)"2", (Object)e.getParameterName());
        }
        content = group.values();
        Assert.assertEquals((String)"values.size()", (long)2L, (long)content.size());
        Assert.assertTrue((String)"contains(v1)", (boolean)content.contains(v1));
        Assert.assertFalse((String)"contains(v2)", (boolean)content.contains(v2));
        Assert.assertTrue((String)"contains(v3)", (boolean)content.contains(v3));
        Assert.assertFalse((String)"contains(v1b)", (boolean)content.contains(v1b));
        Assert.assertFalse((String)"contains(v2b)", (boolean)content.contains(v2b));
        Assert.assertFalse((String)"contains(v3b)", (boolean)content.contains(v3b));
        Assert.assertSame((String)"parameter(\"1\")", (Object)v1, (Object)group.parameter("1"));
        Assert.assertSame((String)"parameter(\"3\")", (Object)v3, (Object)group.parameter("3"));
        try {
            Assert.assertSame((String)"parameter(\"2\")", (Object)v2, (Object)group.parameter("2"));
            Assert.fail((String)"v2 should not exists");
        }
        catch (ParameterNotFoundException e) {
            Assert.assertEquals((Object)"2", (Object)e.getParameterName());
        }
        group = new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v2, v3, v4, v4b});
        writer.format((ParameterValueGroup)group);
        Assert.assertEquals((String)"values.size()", (long)5L, (long)group.values().size());
        try {
            new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v2, v3, v3b});
            Assert.fail((String)"Parameter 3 was not allowed to be inserted twice.");
        }
        catch (InvalidParameterCardinalityException e) {
            Assert.assertEquals((Object)"3", (Object)e.getParameterName());
        }
        try {
            new ParameterGroup(properties, (GeneralParameterValue[])new Parameter[]{v1, v3, v1b});
            Assert.fail((String)"Parameter 1 was not allowed to be inserted twice.");
        }
        catch (InvalidParameterCardinalityException e) {
            Assert.assertEquals((Object)"1", (Object)e.getParameterName());
        }
    }

    @Test
    public void testMatrix() {
        Formatter formatter = new Formatter();
        GeneralMatrix matrix = new GeneralMatrix(4);
        matrix.setElement(0, 2, 4.0);
        matrix.setElement(1, 0, -2.0);
        matrix.setElement(2, 3, 7.0);
        LinearTransform transform = ProjectiveTransform.create((Matrix)matrix);
        Assert.assertFalse((boolean)(transform instanceof AffineTransform));
        formatter.append((MathTransform)transform);
        Assert.assertEquals((Object)"PARAM_MT[\"Affine\", PARAMETER[\"num_row\", 4], PARAMETER[\"num_col\", 4], PARAMETER[\"elt_0_2\", 4.0], PARAMETER[\"elt_1_0\", -2.0], PARAMETER[\"elt_2_3\", 7.0]]", (Object)formatter.toString());
        matrix.setSize(3, 3);
        transform = ProjectiveTransform.create((Matrix)matrix);
        Assert.assertTrue((boolean)(transform instanceof AffineTransform));
        formatter.clear();
        formatter.append((MathTransform)transform);
        Assert.assertEquals((Object)"PARAM_MT[\"Affine\", PARAMETER[\"num_row\", 3], PARAMETER[\"num_col\", 3], PARAMETER[\"elt_0_2\", 4.0], PARAMETER[\"elt_1_0\", -2.0]]", (Object)formatter.toString());
    }

    @Test
    public void testMatrixEdit() {
        int size = 8;
        Random random = new Random(47821365L);
        GeneralMatrix matrix = new GeneralMatrix(8);
        for (int j = 0; j < 8; ++j) {
            for (int i = 0; i < 8; ++i) {
                matrix.setElement(j, i, 200.0 * random.nextDouble() - 100.0);
            }
        }
        MatrixParameterDescriptors descriptor = new MatrixParameterDescriptors(Collections.singletonMap("name", "Test"));
        for (int height = 2; height <= 8; ++height) {
            for (int width = 2; width <= 8; ++width) {
                MatrixParameters parameters = (MatrixParameters)descriptor.createValue();
                GeneralMatrix copy = matrix.clone();
                copy.setSize(height, width);
                parameters.setMatrix((Matrix)copy);
                Assert.assertEquals((String)"height", (long)height, (long)parameters.parameter("num_row").intValue());
                Assert.assertEquals((String)"width", (long)width, (long)parameters.parameter("num_col").intValue());
                Assert.assertTrue((String)"equals", (boolean)copy.equals(parameters.getMatrix(), 0.0));
                Assert.assertEquals((String)"equals", (Object)parameters, (Object)parameters.clone());
            }
        }
    }

    private static void serialize(Object object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream outs = new ObjectOutputStream(out);
        outs.writeObject(object);
        outs.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        Object test = in.readObject();
        in.close();
        Assert.assertNotSame((String)"Serialization", (Object)object, (Object)test);
        Assert.assertEquals((String)"Serialization", (Object)object, (Object)test);
        Assert.assertEquals((String)"Serialization", (long)object.hashCode(), (long)test.hashCode());
    }

    private static void assertNotEquals(String message, Object o1, Object o2) {
        Assert.assertNotNull((String)message, (Object)o1);
        Assert.assertNotNull((String)message, (Object)o2);
        Assert.assertNotSame((String)message, (Object)o1, (Object)o2);
        Assert.assertNotEquals((String)message, (Object)o1, (Object)o2);
    }
}

