/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.referencing.CoordinateFormat;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

public final class FormatTest {
    @Before
    public void setUp() {
        Locale.setDefault(Locale.ENGLISH);
    }

    @After
    public void tearDown() {
        AngleFormat.setDefaultRoundingMethod((AngleFormat.RoundingMethod)AngleFormat.DEFAULT_ROUNDING_METHOD);
    }

    @Test
    public void testAngleFormat() throws ParseException {
        AngleFormat f = new AngleFormat("DD.ddd\u00b0", Locale.CANADA);
        FormatTest.assertFormat("20.000\u00b0", new Angle(20.0), (Format)f);
        FormatTest.assertFormat("20.749\u00b0", new Angle(20.749), (Format)f);
        FormatTest.assertFormat("-12.247\u00b0", new Angle(-12.247), (Format)f);
        FormatTest.assertFormat("13.214\u00b0N", new Latitude(13.214), (Format)f);
        FormatTest.assertFormat("12.782\u00b0S", new Latitude(-12.782), (Format)f);
        f = new AngleFormat("DD.ddd\u00b0", Locale.FRANCE);
        FormatTest.assertFormat("19,457\u00b0E", new Longitude(19.457), (Format)f);
        FormatTest.assertFormat("78,124\u00b0S", new Latitude(-78.124), (Format)f);
        f = new AngleFormat("DDddd", Locale.CANADA);
        FormatTest.assertFormat("19457E", new Longitude(19.457), (Format)f);
        FormatTest.assertFormat("78124S", new Latitude(-78.124), (Format)f);
        f = new AngleFormat("DD\u00b0MM.m", Locale.CANADA);
        FormatTest.assertFormat("12\u00b030.0", new Angle(12.5), (Format)f);
        FormatTest.assertFormat("-10\u00b015.0", new Angle(-10.25), (Format)f);
    }

    private static void assertFormat(String expected, Object value, Format format) throws ParseException {
        String label = value.toString();
        String text = format.format(value);
        Assert.assertEquals((String)("Formatting of \"" + label + "\""), (Object)expected, (Object)text);
        Assert.assertEquals((String)("Parsing of \"" + label + "\""), (Object)value, (Object)format.parseObject(text));
    }

    @Test
    public void testCoordinateFormat() {
        Date epoch = new Date(1041375600000L);
        DefaultTemporalDatum datum = new DefaultTemporalDatum("Time", epoch);
        DefaultCompoundCRS crs = new DefaultCompoundCRS("WGS84 3D + time", new CoordinateReferenceSystem[]{DefaultGeographicCRS.WGS84, DefaultVerticalCRS.ELLIPSOIDAL_HEIGHT, new DefaultTemporalCRS("Time", (TemporalDatum)datum, (TimeCS)DefaultTimeCS.DAYS)});
        CoordinateFormat format = new CoordinateFormat(Locale.FRANCE);
        format.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        format.setTimeZone(TimeZone.getTimeZone("GMT+01:00"));
        GeneralDirectPosition position = new GeneralDirectPosition(new double[]{23.78, -12.74, 127.9, 3.2});
        format.setDatePattern("dd MM yyyy");
        Assert.assertEquals((Object)"23\u00b046,8'E 12\u00b044,4'S 127,9\u00a0m 04 01 2003", (Object)format.format((DirectPosition)position));
        GeneralDirectPosition wrong = new GeneralDirectPosition(new double[]{23.78, -12.74, 127.9, 3.2, 8.5});
        try {
            Assert.assertNotNull((Object)format.format((DirectPosition)wrong));
            Assert.fail((String)"Excepted a mismatched dimension exception.");
        }
        catch (MismatchedDimensionException mismatchedDimensionException) {
            // empty catch block
        }
        format.setCoordinateReferenceSystem(null);
        Assert.assertEquals((Object)"23,78 -12,74 127,9 3,2", (Object)format.format((DirectPosition)position));
        Assert.assertEquals((Object)"23,78 -12,74 127,9 3,2 8,5", (Object)format.format((DirectPosition)wrong));
        format.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        format.setTimeZone(TimeZone.getTimeZone("GMT+01:00"));
        format.setSeparator("; ");
        format.setDatePattern("dd MM yyyy");
        Assert.assertEquals((Object)"23\u00b046,8'E; 12\u00b044,4'S; 127,9\u00a0m; 04 01 2003", (Object)format.format((DirectPosition)position));
    }

    @Test
    public void testInstanceRoundingMethod() {
        double value = 2.5;
        AngleFormat af = new AngleFormat("D");
        Assert.assertEquals((Object)"2", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_UP);
        Assert.assertEquals((Object)"3", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_DOWN);
        Assert.assertEquals((Object)"2", (Object)af.format(value));
        value = 3.5;
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        Assert.assertEquals((Object)"4", (Object)af.format(value));
        af = new AngleFormat("D M.m");
        value = 0.5075;
        Assert.assertEquals((Object)"0 30.4", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_UP);
        Assert.assertEquals((Object)"0 30.5", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_DOWN);
        Assert.assertEquals((Object)"0 30.4", (Object)af.format(value));
        value = 0.5091666666666667;
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        Assert.assertEquals((Object)"0 30.6", (Object)af.format(value));
        af = new AngleFormat("D M S.s");
        value = 1.0170694444444444;
        Assert.assertEquals((Object)"1 1 1.4", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_UP);
        Assert.assertEquals((Object)"1 1 1.5", (Object)af.format(value));
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_DOWN);
        Assert.assertEquals((Object)"1 1 1.4", (Object)af.format(value));
        value = 1.0170972222222223;
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        Assert.assertEquals((Object)"1 1 1.6", (Object)af.format(value));
    }

    @Test
    public void testSetGlobalRoundingMethod() {
        double value = 3.5;
        AngleFormat af1 = new AngleFormat("D");
        af1.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_DOWN);
        AngleFormat.setDefaultRoundingMethod((AngleFormat.RoundingMethod)AngleFormat.RoundingMethod.ROUND_HALF_UP);
        AngleFormat af2 = new AngleFormat("D");
        Assert.assertEquals((Object)"3", (Object)af1.format(value));
        Assert.assertEquals((Object)"4", (Object)af2.format(value));
    }

    @Test
    public void testOverflow() {
        AngleFormat af = new AngleFormat("DD MM SS.ss");
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        double value = 0.0;
        Assert.assertEquals((Object)"00 00 00.00", (Object)af.format(value));
        value = 2.7777777777777776E-7;
        Assert.assertEquals((Object)"00 00 00.00", (Object)af.format(value));
        value = 2.777777777777778E-6;
        Assert.assertEquals((Object)"00 00 00.01", (Object)af.format(value));
        value = 0.016663888888888888;
        Assert.assertEquals((Object)"00 00 59.99", (Object)af.format(value));
        value = 0.01666638888888889;
        Assert.assertEquals((Object)"00 01 00.00", (Object)af.format(value));
        value = 0.03333055555555556;
        Assert.assertEquals((Object)"00 01 59.99", (Object)af.format(value));
        value = 0.03333305555555556;
        Assert.assertEquals((Object)"00 02 00.00", (Object)af.format(value));
        value = 0.9999972222222222;
        Assert.assertEquals((Object)"00 59 59.99", (Object)af.format(value));
        value = 0.9999997222222222;
        Assert.assertEquals((Object)"01 00 00.00", (Object)af.format(value));
        value = 359.99999722222225;
        Assert.assertEquals((Object)"359 59 59.99", (Object)af.format(value));
        value = 359.99999972222224;
        Assert.assertEquals((Object)"00 00 00.00", (Object)af.format(value));
        af = new AngleFormat("DD MM SS");
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        value = 0.01638888888888889;
        Assert.assertEquals((Object)"00 00 59", (Object)af.format(value));
        value = 0.016638888888888887;
        Assert.assertEquals((Object)"00 01 00", (Object)af.format(value));
        value = 0.9833333333333333;
        Assert.assertEquals((Object)"00 59 00", (Object)af.format(value));
        value = 0.9999833333333333;
        Assert.assertEquals((Object)"01 00 00", (Object)af.format(value));
        value = 0.9999722222222222;
        Assert.assertEquals((Object)"01 00 00", (Object)af.format(value));
        af = new AngleFormat("DD MM");
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        value = 0.9999722222222222;
        Assert.assertEquals((Object)"01 00", (Object)af.format(value));
        value = 361.0;
        Assert.assertEquals((Object)"01 00", (Object)af.format(value));
        af = new AngleFormat("DDD");
        af.setRoundingMethod(AngleFormat.RoundingMethod.ROUND_HALF_EVEN);
        value = 0.9999;
        Assert.assertEquals((Object)"001", (Object)af.format(value));
        value = 361.1111;
        Assert.assertEquals((Object)"001", (Object)af.format(value));
        value = 361.999;
        Assert.assertEquals((Object)"002", (Object)af.format(value));
    }
}

