/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Rectangle2D;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class Envelope2DTest {
    private Envelope2D envelope2D;
    private Envelope2D australia;
    private Envelope2D newZealand;
    private Envelope2D somewhereIntersectingAustralia;
    private Envelope2D somewhereInAustralia;
    private final CoordinateReferenceSystem crs = DefaultGeographicCRS.WGS84;

    @Before
    public void setupTest() {
        Rectangle2D.Double bounds = new Rectangle2D.Double(-20.0, -20.0, 40.0, 40.0);
        this.envelope2D = new Envelope2D(this.crs, (Rectangle2D)bounds);
        this.australia = new Envelope2D(this.crs);
        this.australia.include(40.0, 110.0);
        this.australia.include(10.0, 150.0);
        this.newZealand = new Envelope2D((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        this.newZealand.include(50.0, 165.0);
        this.newZealand.include(33.0, 180.0);
        this.somewhereIntersectingAustralia = new Envelope2D(this.crs);
        this.somewhereIntersectingAustralia.include(50.0, 145.0);
        this.somewhereIntersectingAustralia.include(33.0, 180.0);
        this.somewhereInAustralia = new Envelope2D(this.crs);
        this.somewhereInAustralia.include(35.0, 140.0);
        this.somewhereInAustralia.include(40.0, 145.0);
    }

    @Test
    public void testSetBounds() {
        Envelope2D testEnvelope = new Envelope2D();
        testEnvelope.setBounds((BoundingBox)this.envelope2D);
        Assert.assertNotNull((String)"envelope2d is null", (Object)testEnvelope);
        Assert.assertEquals((String)"setbounds envelopes do not match", (Object)this.envelope2D, (Object)testEnvelope);
    }

    @Test
    public void testInclude() throws Exception {
        Assert.assertEquals((String)"unexpected bounds x min after include", (double)10.0, (double)this.australia.x, (double)0.0);
        Assert.assertEquals((String)"unexpected bounds y min after include", (double)110.0, (double)this.australia.y, (double)0.0);
        Assert.assertEquals((String)"unexpected bounds width after include", (double)30.0, (double)this.australia.width, (double)0.0);
        Assert.assertEquals((String)"unexpected bounds height after include", (double)40.0, (double)this.australia.height, (double)0.0);
        try {
            this.australia.include((BoundingBox)this.newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
        try {
            this.australia.include((BoundingBox)this.envelope2D);
            Assert.assertEquals((String)"unexpected bounds x min after include", (double)-20.0, (double)this.australia.x, (double)0.0);
            Assert.assertEquals((String)"unexpected bounds y min after include", (double)-20.0, (double)this.australia.y, (double)0.0);
            Assert.assertEquals((String)"unexpected bounds width after include", (double)60.0, (double)this.australia.width, (double)0.0);
            Assert.assertEquals((String)"unexpected bounds height after include", (double)170.0, (double)this.australia.height, (double)0.0);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
    }

    @Test
    public void testIntersectsBoundingBox() {
        boolean testIntersects;
        try {
            this.australia.intersects((BoundingBox)this.newZealand);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (MismatchedReferenceSystemException mismatchedReferenceSystemException) {
            // empty catch block
        }
        try {
            testIntersects = this.australia.intersects((BoundingBox)this.envelope2D);
            Assert.assertFalse((boolean)testIntersects);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
        try {
            testIntersects = this.australia.intersects((BoundingBox)this.somewhereIntersectingAustralia);
            Assert.assertTrue((boolean)testIntersects);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
    }

    @Test
    public void testContainsBoundingBox() {
        boolean testContains;
        try {
            testContains = this.australia.contains((BoundingBox)this.envelope2D);
            Assert.assertFalse((boolean)testContains);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
        try {
            testContains = this.australia.contains((BoundingBox)this.somewhereInAustralia);
            Assert.assertTrue((boolean)testContains);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
    }

    @Test
    public void testContainsDirectPosition() {
        boolean testContains;
        DirectPosition2D positionInAustralia = new DirectPosition2D(this.crs, 30.0, 120.0);
        DirectPosition2D positionOutsideAustralia = new DirectPosition2D(this.crs, 30.0, 170.0);
        try {
            testContains = this.australia.contains((DirectPosition)positionOutsideAustralia);
            Assert.assertFalse((boolean)testContains);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
        try {
            testContains = this.australia.contains((DirectPosition)positionInAustralia);
            Assert.assertTrue((boolean)testContains);
        }
        catch (MismatchedReferenceSystemException t) {
            Assert.fail((String)"Expected a match of CoordinateReferenceSystem");
        }
    }

    @Test
    public void testToBounds() {
        try {
            this.newZealand.toBounds(this.crs);
            Assert.fail((String)"Expected a mismatch of CoordinateReferenceSystem");
        }
        catch (TransformException transformException) {
            // empty catch block
        }
        try {
            BoundingBox testBox = this.australia.toBounds(this.crs);
            Assert.assertEquals((String)"unexpected bounds x min after toBounds", (double)10.0, (double)testBox.getMinX(), (double)0.0);
            Assert.assertEquals((String)"unexpected bounds y min after toBounds", (double)110.0, (double)testBox.getMinY(), (double)0.0);
            Assert.assertEquals((String)"unexpected bounds x max after toBounds", (double)40.0, (double)testBox.getMaxX(), (double)0.0);
            Assert.assertEquals((String)"unexpected bounds y max after toBounds", (double)150.0, (double)testBox.getMaxY(), (double)0.0);
        }
        catch (TransformException t) {
            Assert.fail((String)"Missmatch of CoordinateReferenceSystem");
        }
    }
}

