/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PropertyFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger(PropertyFeatureReader.class);
    BufferedReader reader;
    SimpleFeatureType type;
    String line;
    String next;
    String[] text;
    String fid;
    WKTReader2 wktReader;

    public PropertyFeatureReader(String namespace, File file) throws IOException {
        this(namespace, file, null);
    }

    public PropertyFeatureReader(String namespace, File file, GeometryFactory geometryFactory) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
        while ((this.line = this.reader.readLine()) != null && !this.line.startsWith("_=")) {
        }
        if (this.line == null || !this.line.startsWith("_=")) {
            throw new IOException("Property file schema not available found");
        }
        String typeSpec = this.line.substring(2);
        String name = file.getName();
        String typeName = name.substring(0, name.lastIndexOf(46));
        try {
            this.type = DataUtilities.createType((String)namespace, (String)typeName, (String)typeSpec);
        }
        catch (SchemaException e) {
            throw new DataSourceException(typeName + " schema not available", (Throwable)e);
        }
        this.line = null;
        this.next = null;
        this.wktReader = geometryFactory == null ? new WKTReader2() : new WKTReader2(geometryFactory);
    }

    public SimpleFeatureType getFeatureType() {
        return this.type;
    }

    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.hasNext()) {
            this.line = this.next;
            this.next = null;
            int split = this.line.indexOf(61);
            this.fid = this.line.substring(0, split);
            this.text = this.line.substring(split + 1).split("\\|", -1);
            if (this.type.getAttributeCount() != this.text.length) {
                throw new DataSourceException("Format error: expected " + this.type.getAttributeCount() + " attributes, but found " + this.text.length + ". [" + this.line + "]");
            }
        } else {
            throw new NoSuchElementException();
        }
        Object[] values = new Object[this.type.getAttributeCount()];
        for (int i = 0; i < this.type.getAttributeCount(); ++i) {
            try {
                values[i] = this.read(i);
                continue;
            }
            catch (RuntimeException e) {
                values[i] = null;
                continue;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])values, (String)this.fid);
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        CoordinateReferenceSystem crs;
        if (this.line == null) {
            throw new IOException("No content available - did you remeber to call next?");
        }
        AttributeDescriptor attType = this.type.getDescriptor(index);
        String stringValue = null;
        try {
            stringValue = this.text[index];
        }
        catch (RuntimeException e1) {
            Logger.getGlobal().log(Level.INFO, "", e1);
            stringValue = null;
        }
        if ("<null>".equals(stringValue)) {
            stringValue = null;
        }
        if (stringValue == null && attType.isNillable()) {
            return null;
        }
        Object value = null;
        if (attType instanceof GeometryDescriptor && stringValue != null && !stringValue.isEmpty()) {
            try {
                Geometry geometry = this.wktReader.read(stringValue);
                value = Converters.convert((Object)geometry, (Class)attType.getType().getBinding());
            }
            catch (ParseException e) {
                value = null;
            }
        } else {
            value = Converters.convert((Object)stringValue, (Class)attType.getType().getBinding());
        }
        if (attType.getType() instanceof GeometryType && (crs = ((GeometryType)attType.getType()).getCoordinateReferenceSystem()) != null && value != null && value instanceof Geometry) {
            ((Geometry)value).setUserData((Object)crs);
        }
        return value;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.readLine();
        return this.next != null;
    }

    String readLine() throws IOException {
        String txt;
        StringBuilder buffer = new StringBuilder();
        while ((txt = this.reader.readLine()) != null) {
            if (txt.startsWith("#") || txt.startsWith("!")) continue;
            if ((txt = this.trimLeft(txt)).endsWith("\\")) {
                buffer.append(txt.substring(0, txt.length() - 1));
                buffer.append("\n");
                continue;
            }
            buffer.append(txt);
            break;
        }
        if (buffer.length() == 0) {
            return null;
        }
        String raw = buffer.toString();
        raw = raw.replace("\\n", "\n");
        raw = raw.replace("\\r", "\r");
        raw = raw.replace("\\t", "\t");
        return raw;
    }

    String trimLeft(String txt) {
        int start = 0;
        for (int i = 0; i < txt.length(); ++i) {
            char ch = txt.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            start = i;
            break;
        }
        return txt.substring(start);
    }

    public void close() throws IOException {
        if (this.reader == null) {
            LOGGER.warning("Stream seems to be already closed.");
        } else {
            this.reader.close();
        }
        this.reader = null;
    }

    void setWKTReader(WKTReader2 wktReader) {
        this.wktReader = wktReader;
    }
}

