/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.geotools.process.Process;
import org.geotools.process.Progress;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class ProgressTask
implements Runnable,
Progress {
    private final Synchronizer synchronizer;

    public ProgressTask(Process process, Map<String, Object> input) {
        if (process == null) {
            throw new NullPointerException();
        }
        this.synchronizer = new Synchronizer(process, input);
    }

    @Override
    public float getProgress() {
        return this.synchronizer.getProgress();
    }

    @Override
    public boolean isCancelled() {
        return this.synchronizer.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.synchronizer.innerIsDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.synchronizer.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public Map<String, Object> get() throws InterruptedException, ExecutionException {
        return this.synchronizer.innerGet();
    }

    @Override
    public Map<String, Object> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.synchronizer.innerGet(unit.toNanos(timeout));
    }

    protected void done() {
    }

    protected void set(Map<String, Object> value) {
        this.synchronizer.innerSet(value);
    }

    protected void setException(Throwable t) {
        this.synchronizer.innerSetException(t);
    }

    @Override
    public void run() {
        this.synchronizer.innerRun();
    }

    protected boolean runAndReset() {
        return this.synchronizer.innerRunAndReset();
    }

    private final class Synchronizer
    extends AbstractQueuedSynchronizer
    implements ProgressListener {
        private static final long serialVersionUID = 6633428077533811475L;
        private static final int RUNNING = 1;
        private static final int COMPLETED = 2;
        private static final int CANCELED = 4;
        private final Process process;
        private Map<String, Object> input;
        private Map<String, Object> result;
        private Throwable exception;
        private volatile Thread runningThread;
        private float percentComplete;
        private InternationalString processName;

        Synchronizer(Process process, Map<String, Object> input) {
            this.process = process;
            this.input = input;
        }

        private boolean ranOrCancelled(int state) {
            return (state & 6) != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.runningThread = null;
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 4;
        }

        boolean innerIsDone() {
            return this.ranOrCancelled(this.getState()) && this.runningThread == null;
        }

        Map<String, Object> innerGet() throws InterruptedException, ExecutionException {
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        Map<String, Object> innerGet(long nanosTimeout) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 4) {
                throw new CancellationException();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        void innerSet(Map<String, Object> v) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.result = v;
            this.releaseShared(0);
            ProgressTask.this.done();
        }

        void innerSetException(Throwable t) {
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return;
            } while (!this.compareAndSetState(s, 2));
            this.exception = t;
            this.result = null;
            this.releaseShared(0);
            ProgressTask.this.done();
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            Thread r;
            int s;
            do {
                if (!this.ranOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 4));
            if (mayInterruptIfRunning && (r = this.runningThread) != null) {
                r.interrupt();
            }
            this.releaseShared(0);
            ProgressTask.this.done();
            return true;
        }

        void innerRun() {
            if (!this.compareAndSetState(0, 1)) {
                return;
            }
            try {
                this.runningThread = Thread.currentThread();
                this.innerSet(this.process.execute(this.input, this));
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
            }
        }

        boolean innerRunAndReset() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            try {
                this.runningThread = Thread.currentThread();
                this.process.execute(this.input, this);
                this.runningThread = null;
                return this.compareAndSetState(1, 0);
            }
            catch (Throwable ex) {
                this.innerSetException(ex);
                return false;
            }
        }

        public void complete() {
        }

        public void dispose() {
        }

        public void exceptionOccurred(Throwable t) {
            this.innerSetException(t);
        }

        public float getProgress() {
            return this.percentComplete;
        }

        public InternationalString getTask() {
            return this.processName;
        }

        public boolean isCanceled() {
            return this.innerIsCancelled();
        }

        public void progress(float percent) {
            this.percentComplete = percent;
        }

        public void setCanceled(boolean stop) {
            this.innerCancel(stop);
        }

        public void setTask(InternationalString name) {
            this.processName = name;
        }

        public void started() {
        }

        public void warningOccurred(String arg0, String arg1, String arg2) {
        }
    }
}

